/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc.security;

import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.CredentialsSys;
import org.junit.Assert;
import org.junit.Test;

public class TestCredentialsSys {
    @Test
    public void testReadWrite() {
        CredentialsSys credential = new CredentialsSys();
        credential.setUID(0);
        credential.setGID(1);
        credential.setStamp(1234);
        XDR xdr = new XDR();
        credential.write(xdr);
        CredentialsSys newCredential = new CredentialsSys();
        newCredential.read(xdr.asReadOnlyWrap());
        Assert.assertEquals((long)0L, (long)newCredential.getUID());
        Assert.assertEquals((long)1L, (long)newCredential.getGID());
        Assert.assertEquals((long)1234L, (long)newCredential.getStamp());
    }

    @Test
    public void testHostNameNotMultipleOf4() {
        CredentialsSys credential = new CredentialsSys();
        credential.setUID(0);
        credential.setGID(1);
        credential.setStamp(1234);
        credential.setHostName("hadoop-nfs");
        XDR xdr = new XDR();
        credential.write(xdr);
        CredentialsSys newCredential = new CredentialsSys();
        newCredential.read(xdr.asReadOnlyWrap());
        Assert.assertEquals((long)0L, (long)newCredential.getUID());
        Assert.assertEquals((long)1L, (long)newCredential.getGID());
        Assert.assertEquals((long)1234L, (long)newCredential.getStamp());
        Assert.assertEquals((long)32L, (long)newCredential.getCredentialLength());
    }

    @Test
    public void testHostNameMultipleOf4() {
        CredentialsSys credential = new CredentialsSys();
        credential.setUID(0);
        credential.setGID(1);
        credential.setStamp(1234);
        credential.setHostName("apachehadoop");
        XDR xdr = new XDR();
        credential.write(xdr);
        CredentialsSys newCredential = new CredentialsSys();
        newCredential.read(xdr.asReadOnlyWrap());
        Assert.assertEquals((long)0L, (long)newCredential.getUID());
        Assert.assertEquals((long)1L, (long)newCredential.getGID());
        Assert.assertEquals((long)1234L, (long)newCredential.getStamp());
        Assert.assertEquals((long)32L, (long)newCredential.getCredentialLength());
    }
}

