/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mount.MountdBase;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.SimpleTcpServer;

public abstract class Nfs3Base {
    public static final Log LOG = LogFactory.getLog(Nfs3Base.class);
    private final MountdBase mountd;
    private final RpcProgram rpcProgram;
    private final int nfsPort;

    public MountdBase getMountBase() {
        return this.mountd;
    }

    public RpcProgram getRpcProgram() {
        return this.rpcProgram;
    }

    protected Nfs3Base(MountdBase mountd, RpcProgram program, Configuration conf) {
        this.mountd = mountd;
        this.rpcProgram = program;
        this.nfsPort = conf.getInt("nfs3.server.port", 2049);
        LOG.info((Object)("NFS server port set to: " + this.nfsPort));
    }

    protected Nfs3Base(MountdBase mountd, RpcProgram program) {
        this.mountd = mountd;
        this.rpcProgram = program;
        this.nfsPort = 2049;
    }

    public void start(boolean register) {
        this.mountd.start(register);
        this.startTCPServer();
        if (register) {
            this.rpcProgram.register(6);
        }
    }

    private void startTCPServer() {
        SimpleTcpServer tcpServer = new SimpleTcpServer(this.nfsPort, this.rpcProgram, 0);
        tcpServer.run();
    }
}

