/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcInfo;
import org.apache.hadoop.oncrpc.RpcResponse;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.apache.hadoop.oncrpc.SimpleUdpClient;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.portmap.PortmapMapping;
import org.apache.hadoop.portmap.PortmapRequest;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public abstract class RpcProgram
extends SimpleChannelUpstreamHandler {
    private static final Log LOG = LogFactory.getLog(RpcProgram.class);
    public static final int RPCB_PORT = 111;
    private final String program;
    private final String host;
    private final int port;
    private final int progNumber;
    private final int lowProgVersion;
    private final int highProgVersion;

    protected RpcProgram(String program, String host, int port, int progNumber, int lowProgVersion, int highProgVersion) {
        this.program = program;
        this.host = host;
        this.port = port;
        this.progNumber = progNumber;
        this.lowProgVersion = lowProgVersion;
        this.highProgVersion = highProgVersion;
    }

    public void register(int transport) {
        for (int vers = this.lowProgVersion; vers <= this.highProgVersion; ++vers) {
            this.register(vers, transport);
        }
    }

    private void register(int progVersion, int transport) {
        PortmapMapping mapEntry = new PortmapMapping(this.progNumber, progVersion, transport, this.port);
        this.register(mapEntry);
    }

    protected void register(PortmapMapping mapEntry) {
        XDR mappingRequest = PortmapRequest.create(mapEntry);
        SimpleUdpClient registrationClient = new SimpleUdpClient(this.host, 111, mappingRequest);
        try {
            registrationClient.run();
        }
        catch (IOException e) {
            LOG.error((Object)("Registration failure with " + this.host + ":" + this.port + ", portmap entry: " + mapEntry));
            throw new RuntimeException("Registration failure");
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        RpcInfo info = (RpcInfo)e.getMessage();
        RpcCall call = (RpcCall)info.header();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.program + " procedure #" + call.getProcedure()));
        }
        if (this.progNumber != call.getProgram()) {
            LOG.warn((Object)("Invalid RPC call program " + call.getProgram()));
            RpcAcceptedReply reply = RpcAcceptedReply.getInstance(call.getXid(), RpcAcceptedReply.AcceptState.PROG_UNAVAIL, Verifier.VERIFIER_NONE);
            XDR out = new XDR();
            reply.write(out);
            ChannelBuffer b = ChannelBuffers.wrappedBuffer((ByteBuffer)out.asReadOnlyWrap().buffer());
            RpcResponse rsp = new RpcResponse(b, info.remoteAddress());
            RpcUtil.sendRpcResponse(ctx, rsp);
            return;
        }
        int ver = call.getVersion();
        if (ver < this.lowProgVersion || ver > this.highProgVersion) {
            LOG.warn((Object)("Invalid RPC call version " + ver));
            RpcAcceptedReply reply = RpcAcceptedReply.getInstance(call.getXid(), RpcAcceptedReply.AcceptState.PROG_MISMATCH, Verifier.VERIFIER_NONE);
            XDR out = new XDR();
            reply.write(out);
            out.writeInt(this.lowProgVersion);
            out.writeInt(this.highProgVersion);
            ChannelBuffer b = ChannelBuffers.wrappedBuffer((ByteBuffer)out.asReadOnlyWrap().buffer());
            RpcResponse rsp = new RpcResponse(b, info.remoteAddress());
            RpcUtil.sendRpcResponse(ctx, rsp);
            return;
        }
        this.handleInternal(ctx, info);
    }

    protected abstract void handleInternal(ChannelHandlerContext var1, RpcInfo var2);

    public String toString() {
        return "Rpc program: " + this.program + " at " + this.host + ":" + this.port;
    }

    protected abstract boolean isIdempotent(RpcCall var1);

    public int getPort() {
        return this.port;
    }
}

