/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.portmap;

import java.util.Arrays;
import java.util.Collection;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.apache.hadoop.portmap.PortmapMapping;

public class PortmapResponse {
    public static XDR voidReply(XDR xdr, int xid) {
        RpcAcceptedReply.getAcceptInstance(xid, new VerifierNone()).write(xdr);
        return xdr;
    }

    public static XDR intReply(XDR xdr, int xid, int value) {
        RpcAcceptedReply.getAcceptInstance(xid, new VerifierNone()).write(xdr);
        xdr.writeInt(value);
        return xdr;
    }

    public static XDR booleanReply(XDR xdr, int xid, boolean value) {
        RpcAcceptedReply.getAcceptInstance(xid, new VerifierNone()).write(xdr);
        xdr.writeBoolean(value);
        return xdr;
    }

    public static XDR pmapList(XDR xdr, int xid, Collection<PortmapMapping> list) {
        RpcAcceptedReply.getAcceptInstance(xid, new VerifierNone()).write(xdr);
        for (PortmapMapping mapping : list) {
            System.out.println(mapping);
            xdr.writeBoolean(true);
            mapping.serialize(xdr);
        }
        xdr.writeBoolean(false);
        return xdr;
    }

    public static XDR pmapList(XDR xdr, int xid, PortmapMapping[] list) {
        return PortmapResponse.pmapList(xdr, xid, Arrays.asList(list));
    }
}

