/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3;

import org.apache.hadoop.nfs.NfsFileType;
import org.apache.hadoop.nfs.NfsTime;
import org.apache.hadoop.nfs.nfs3.Nfs3FileAttributes;
import org.apache.hadoop.nfs.nfs3.response.WccAttr;
import org.apache.hadoop.oncrpc.XDR;

/*
 * Exception performing whole class analysis ignored.
 */
public class Nfs3FileAttributes {
    private int type;
    private int mode;
    private int nlink;
    private int uid;
    private int gid;
    private long size;
    private long used;
    private Specdata3 rdev;
    private long fsid;
    private long fileid;
    private NfsTime atime;
    private NfsTime mtime;
    private NfsTime ctime;

    public Nfs3FileAttributes() {
        this(NfsFileType.NFSREG, 0, 0, 0, 0, 0L, 0L, 0L, 0L, 0L);
    }

    public Nfs3FileAttributes(NfsFileType nfsType, int nlink, short mode, int uid, int gid, long size, long fsid, long fileid, long mtime, long atime) {
        this.type = nfsType.toValue();
        this.mode = mode;
        this.nlink = this.type == NfsFileType.NFSDIR.toValue() ? nlink + 2 : 1;
        this.uid = uid;
        this.gid = gid;
        this.size = size;
        if (this.type == NfsFileType.NFSDIR.toValue()) {
            this.size = Nfs3FileAttributes.getDirSize((int)nlink);
        }
        this.used = this.size;
        this.rdev = new Specdata3();
        this.fsid = fsid;
        this.fileid = fileid;
        this.mtime = new NfsTime(mtime);
        this.atime = atime != 0L ? new NfsTime(atime) : this.mtime;
        this.ctime = this.mtime;
    }

    public Nfs3FileAttributes(Nfs3FileAttributes other) {
        this.type = other.getType();
        this.mode = other.getMode();
        this.nlink = other.getNlink();
        this.uid = other.getUid();
        this.gid = other.getGid();
        this.size = other.getSize();
        this.used = other.getUsed();
        this.rdev = new Specdata3();
        this.fsid = other.getFsid();
        this.fileid = other.getFileid();
        this.mtime = new NfsTime(other.getMtime());
        this.atime = new NfsTime(other.getAtime());
        this.ctime = new NfsTime(other.getCtime());
    }

    public void serialize(XDR xdr) {
        xdr.writeInt(this.type);
        xdr.writeInt(this.mode);
        xdr.writeInt(this.nlink);
        xdr.writeInt(this.uid);
        xdr.writeInt(this.gid);
        xdr.writeLongAsHyper(this.size);
        xdr.writeLongAsHyper(this.used);
        xdr.writeInt(this.rdev.getSpecdata1());
        xdr.writeInt(this.rdev.getSpecdata2());
        xdr.writeLongAsHyper(this.fsid);
        xdr.writeLongAsHyper(this.fileid);
        this.atime.serialize(xdr);
        this.mtime.serialize(xdr);
        this.ctime.serialize(xdr);
    }

    public static Nfs3FileAttributes deserialize(XDR xdr) {
        Nfs3FileAttributes attr = new Nfs3FileAttributes();
        attr.type = xdr.readInt();
        attr.mode = xdr.readInt();
        attr.nlink = xdr.readInt();
        attr.uid = xdr.readInt();
        attr.gid = xdr.readInt();
        attr.size = xdr.readHyper();
        attr.used = xdr.readHyper();
        xdr.readInt();
        xdr.readInt();
        attr.rdev = new Specdata3();
        attr.fsid = xdr.readHyper();
        attr.fileid = xdr.readHyper();
        attr.atime = NfsTime.deserialize((XDR)xdr);
        attr.mtime = NfsTime.deserialize((XDR)xdr);
        attr.ctime = NfsTime.deserialize((XDR)xdr);
        return attr;
    }

    public String toString() {
        return String.format("type:%d, mode:%d, nlink:%d, uid:%d, gid:%d, size:%d, used:%d, rdev:%s, fsid:%d, fileid:%d, atime:%s, mtime:%s, ctime:%s", this.type, this.mode, this.nlink, this.uid, this.gid, this.size, this.used, this.rdev, this.fsid, this.fileid, this.atime, this.mtime, this.ctime);
    }

    public int getNlink() {
        return this.nlink;
    }

    public long getUsed() {
        return this.used;
    }

    public long getFsid() {
        return this.fsid;
    }

    public long getFileid() {
        return this.fileid;
    }

    public NfsTime getAtime() {
        return this.atime;
    }

    public NfsTime getMtime() {
        return this.mtime;
    }

    public NfsTime getCtime() {
        return this.ctime;
    }

    public int getType() {
        return this.type;
    }

    public WccAttr getWccAttr() {
        return new WccAttr(this.size, this.mtime, this.ctime);
    }

    public long getFileId() {
        return this.fileid;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setUsed(long used) {
        this.used = used;
    }

    public int getMode() {
        return this.mode;
    }

    public int getUid() {
        return this.uid;
    }

    public int getGid() {
        return this.gid;
    }

    public static long getDirSize(int childNum) {
        return (childNum + 2) * 32;
    }
}

