/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.request;

import java.io.IOException;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.oncrpc.XDR;

public class RENAME3Request {
    private final FileHandle fromDirHandle = new FileHandle();
    private final String fromName;
    private final FileHandle toDirHandle;
    private final String toName;

    public RENAME3Request(XDR xdr) throws IOException {
        if (!this.fromDirHandle.deserialize(xdr)) {
            throw new IOException("can't deserialize file handle");
        }
        this.fromName = xdr.readString();
        this.toDirHandle = new FileHandle();
        if (!this.toDirHandle.deserialize(xdr)) {
            throw new IOException("can't deserialize file handle");
        }
        this.toName = xdr.readString();
    }

    public FileHandle getFromDirHandle() {
        return this.fromDirHandle;
    }

    public String getFromName() {
        return this.fromName;
    }

    public FileHandle getToDirHandle() {
        return this.toDirHandle;
    }

    public String getToName() {
        return this.toName;
    }
}

