/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.XDR;

public class FileHandle {
    private static final Log LOG = LogFactory.getLog(FileHandle.class);
    private static final String HEXES = "0123456789abcdef";
    private static final int HANDLE_LEN = 32;
    private byte[] handle;
    private long fileId = -1L;

    public FileHandle() {
        this.handle = null;
    }

    public FileHandle(long v) {
        this.fileId = v;
        this.handle = new byte[32];
        this.handle[0] = (byte)(v >>> 56);
        this.handle[1] = (byte)(v >>> 48);
        this.handle[2] = (byte)(v >>> 40);
        this.handle[3] = (byte)(v >>> 32);
        this.handle[4] = (byte)(v >>> 24);
        this.handle[5] = (byte)(v >>> 16);
        this.handle[6] = (byte)(v >>> 8);
        this.handle[7] = (byte)(v >>> 0);
        for (int i = 8; i < 32; ++i) {
            this.handle[i] = 0;
        }
    }

    public FileHandle(String s) {
        int i;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
            this.handle = new byte[32];
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn((Object)"MD5 MessageDigest unavailable.");
            this.handle = null;
            return;
        }
        byte[] in = s.getBytes();
        for (int i2 = 0; i2 < in.length; ++i2) {
            digest.update(in[i2]);
        }
        byte[] digestbytes = digest.digest();
        for (i = 0; i < 16; ++i) {
            this.handle[i] = 0;
        }
        for (i = 16; i < 32; ++i) {
            this.handle[i] = digestbytes[i - 16];
        }
    }

    public boolean serialize(XDR out) {
        out.writeInt(this.handle.length);
        out.writeFixedOpaque(this.handle);
        return true;
    }

    private long bytesToLong(byte[] data) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        for (int i = 0; i < 8; ++i) {
            buffer.put(data[i]);
        }
        buffer.flip();
        return buffer.getLong();
    }

    public boolean deserialize(XDR xdr) {
        if (!XDR.verifyLength(xdr, 32)) {
            return false;
        }
        int size = xdr.readInt();
        this.handle = xdr.readFixedOpaque(size);
        this.fileId = this.bytesToLong(this.handle);
        return true;
    }

    private static String hex(byte b) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        return strBuilder.toString();
    }

    public long getFileId() {
        return this.fileId;
    }

    public byte[] getContent() {
        return (byte[])this.handle.clone();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.handle.length; ++i) {
            s.append(FileHandle.hex(this.handle[i]));
        }
        return s.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileHandle)) {
            return false;
        }
        FileHandle h = (FileHandle)o;
        return Arrays.equals(this.handle, h.handle);
    }

    public int hashCode() {
        return Arrays.hashCode(this.handle);
    }
}

