/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.nfs.nfs3.IdUserGroup;
import org.apache.hadoop.util.Time;

/*
 * Exception performing whole class analysis ignored.
 */
public class IdUserGroup {
    static final Log LOG = LogFactory.getLog(IdUserGroup.class);
    private static final String OS = System.getProperty("os.name");
    static final String LINUX_GET_ALL_USERS_CMD = "getent passwd | cut -d: -f1,3";
    static final String LINUX_GET_ALL_GROUPS_CMD = "getent group | cut -d: -f1,3";
    static final String MAC_GET_ALL_USERS_CMD = "dscl . -list /Users UniqueID";
    static final String MAC_GET_ALL_GROUPS_CMD = "dscl . -list /Groups PrimaryGroupID";
    private final File staticMappingFile;
    private static final Pattern EMPTY_LINE = Pattern.compile("^\\s*$");
    private static final Pattern COMMENT_LINE = Pattern.compile("^\\s*#.*$");
    private static final Pattern MAPPING_LINE = Pattern.compile("^(uid|gid)\\s+(\\d+)\\s+(\\d+)\\s*(#.*)?$");
    private final long timeout;
    private BiMap<Integer, String> uidNameMap = HashBiMap.create();
    private BiMap<Integer, String> gidNameMap = HashBiMap.create();
    private long lastUpdateTime = 0L;
    private static final String DUPLICATE_NAME_ID_DEBUG_INFO = "NFS gateway could have problem starting with duplicate name or id on the host system.\nThis is because HDFS (non-kerberos cluster) uses name as the only way to identify a user or group.\nThe host system with duplicated user/group name or id might work fine most of the time by itself.\nHowever when NFS gateway talks to HDFS, HDFS accepts only user and group name.\nTherefore, same name means the same user or same group. To find the duplicated names/ids, one can do:\n<getent passwd | cut -d: -f1,3> and <getent group | cut -d: -f1,3> on Linux systms,\n<dscl . -list /Users UniqueID> and <dscl . -list /Groups PrimaryGroupID> on MacOS.";

    public IdUserGroup(Configuration conf) throws IOException {
        long updateTime = conf.getLong("nfs.usergroup.update.millis", 900000L);
        if (updateTime < 60000L) {
            LOG.info((Object)"User configured user account update time is less than 1 minute. Use 1 minute instead.");
            this.timeout = 60000L;
        } else {
            this.timeout = updateTime;
        }
        String staticFilePath = conf.get("nfs.static.mapping.file", "/etc/nfs.map");
        this.staticMappingFile = new File(staticFilePath);
        this.updateMaps();
    }

    @VisibleForTesting
    public long getTimeout() {
        return this.timeout;
    }

    private synchronized boolean isExpired() {
        return Time.monotonicNow() - this.lastUpdateTime > this.timeout;
    }

    private void checkAndUpdateMaps() {
        if (this.isExpired()) {
            LOG.info((Object)"Update cache now");
            try {
                this.updateMaps();
            }
            catch (IOException e) {
                LOG.error((Object)"Can't update the maps. Will use the old ones, which can potentially cause problem.", (Throwable)e);
            }
        }
    }

    private static void reportDuplicateEntry(String header, Integer key, String value, Integer ekey, String evalue) {
        LOG.warn((Object)("\n" + header + String.format("new entry (%d, %s), existing entry: (%d, %s).\n%s\n%s", key, value, ekey, evalue, "The new entry is to be ignored for the following reason.", "NFS gateway could have problem starting with duplicate name or id on the host system.\nThis is because HDFS (non-kerberos cluster) uses name as the only way to identify a user or group.\nThe host system with duplicated user/group name or id might work fine most of the time by itself.\nHowever when NFS gateway talks to HDFS, HDFS accepts only user and group name.\nTherefore, same name means the same user or same group. To find the duplicated names/ids, one can do:\n<getent passwd | cut -d: -f1,3> and <getent group | cut -d: -f1,3> on Linux systms,\n<dscl . -list /Users UniqueID> and <dscl . -list /Groups PrimaryGroupID> on MacOS.")));
    }

    private static Integer parseId(String idStr) {
        Long longVal = Long.parseLong(idStr);
        int intVal = longVal.intValue();
        return intVal;
    }

    @VisibleForTesting
    public static void updateMapInternal(BiMap<Integer, String> map, String mapName, String command, String regex, Map<Integer, Integer> staticMapping) throws IOException {
        BufferedReader br = null;
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"bash", "-c", command});
            br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] nameId = line.split(regex);
                if (nameId == null || nameId.length != 2) {
                    throw new IOException("Can't parse " + mapName + " list entry:" + line);
                }
                LOG.debug((Object)("add to " + mapName + "map:" + nameId[0] + " id:" + nameId[1]));
                Integer key = staticMapping.get(IdUserGroup.parseId((String)nameId[1]));
                String value = nameId[0];
                if (map.containsKey((Object)key)) {
                    String prevValue = (String)map.get((Object)key);
                    if (value.equals(prevValue)) continue;
                    IdUserGroup.reportDuplicateEntry((String)"Got multiple names associated with the same id: ", (Integer)key, (String)value, (Integer)key, (String)prevValue);
                    continue;
                }
                if (map.containsValue((Object)value)) {
                    Integer prevKey = (Integer)map.inverse().get((Object)value);
                    IdUserGroup.reportDuplicateEntry((String)"Got multiple ids associated with the same name: ", (Integer)key, (String)value, (Integer)prevKey, (String)value);
                    continue;
                }
                map.put((Object)key, (Object)value);
            }
            LOG.info((Object)("Updated " + mapName + " map size: " + map.size()));
        }
        catch (IOException e) {
            LOG.error((Object)("Can't update " + mapName + " map"));
            throw e;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e1) {
                    LOG.error((Object)"Can't close BufferedReader of command result", (Throwable)e1);
                }
            }
        }
    }

    public synchronized void updateMaps() throws IOException {
        HashBiMap uMap = HashBiMap.create();
        HashBiMap gMap = HashBiMap.create();
        if (!OS.startsWith("Linux") && !OS.startsWith("Mac")) {
            LOG.error((Object)("Platform is not supported:" + OS + ". Can't update user map and group map and" + " 'nobody' will be used for any user and group."));
            return;
        }
        StaticMapping staticMapping = new StaticMapping(new HashMap(), new HashMap());
        if (this.staticMappingFile.exists()) {
            LOG.info((Object)("Using '" + this.staticMappingFile + "' for static UID/GID mapping..."));
            staticMapping = IdUserGroup.parseStaticMap((File)this.staticMappingFile);
        } else {
            LOG.info((Object)("Not doing static UID/GID mapping because '" + this.staticMappingFile + "' does not exist."));
        }
        if (OS.startsWith("Linux")) {
            IdUserGroup.updateMapInternal((BiMap)uMap, (String)"user", (String)"getent passwd | cut -d: -f1,3", (String)":", (Map)staticMapping.uidMapping);
            IdUserGroup.updateMapInternal((BiMap)gMap, (String)"group", (String)"getent group | cut -d: -f1,3", (String)":", (Map)staticMapping.gidMapping);
        } else {
            IdUserGroup.updateMapInternal((BiMap)uMap, (String)"user", (String)"dscl . -list /Users UniqueID", (String)"\\s+", (Map)staticMapping.uidMapping);
            IdUserGroup.updateMapInternal((BiMap)gMap, (String)"group", (String)"dscl . -list /Groups PrimaryGroupID", (String)"\\s+", (Map)staticMapping.gidMapping);
        }
        this.uidNameMap = uMap;
        this.gidNameMap = gMap;
        this.lastUpdateTime = Time.monotonicNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static StaticMapping parseStaticMap(File staticMapFile) throws IOException {
        HashMap<Integer, Integer> uidMapping = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> gidMapping = new HashMap<Integer, Integer>();
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(staticMapFile)));
        try {
            String line = null;
            while ((line = in.readLine()) != null) {
                if (EMPTY_LINE.matcher(line).matches() || COMMENT_LINE.matcher(line).matches()) continue;
                Matcher lineMatcher = MAPPING_LINE.matcher(line);
                if (!lineMatcher.matches()) {
                    LOG.warn((Object)("Could not parse line '" + line + "'. Lines should be of " + "the form '[uid|gid] [remote id] [local id]'. Blank lines and " + "everything following a '#' on a line will be ignored."));
                    continue;
                }
                String firstComponent = lineMatcher.group(1);
                int remoteId = Integer.parseInt(lineMatcher.group(2));
                int localId = Integer.parseInt(lineMatcher.group(3));
                if (firstComponent.equals("uid")) {
                    uidMapping.put(localId, remoteId);
                    continue;
                }
                gidMapping.put(localId, remoteId);
            }
        }
        finally {
            in.close();
        }
        return new StaticMapping(uidMapping, gidMapping);
    }

    public synchronized int getUid(String user) throws IOException {
        this.checkAndUpdateMaps();
        Integer id = (Integer)this.uidNameMap.inverse().get((Object)user);
        if (id == null) {
            throw new IOException("User just deleted?:" + user);
        }
        return id;
    }

    public synchronized int getGid(String group) throws IOException {
        this.checkAndUpdateMaps();
        Integer id = (Integer)this.gidNameMap.inverse().get((Object)group);
        if (id == null) {
            throw new IOException("No such group:" + group);
        }
        return id;
    }

    public synchronized String getUserName(int uid, String unknown) {
        this.checkAndUpdateMaps();
        String uname = (String)this.uidNameMap.get((Object)uid);
        if (uname == null) {
            LOG.warn((Object)("Can't find user name for uid " + uid + ". Use default user name " + unknown));
            uname = unknown;
        }
        return uname;
    }

    public synchronized String getGroupName(int gid, String unknown) {
        this.checkAndUpdateMaps();
        String gname = (String)this.gidNameMap.get((Object)gid);
        if (gname == null) {
            LOG.warn((Object)("Can't find group name for gid " + gid + ". Use default group name " + unknown));
            gname = unknown;
        }
        return gname;
    }

    public int getUidAllowingUnknown(String user) {
        int uid;
        this.checkAndUpdateMaps();
        try {
            uid = this.getUid(user);
        }
        catch (IOException e) {
            uid = user.hashCode();
            LOG.info((Object)("Can't map user " + user + ". Use its string hashcode:" + uid), (Throwable)e);
        }
        return uid;
    }

    public int getGidAllowingUnknown(String group) {
        int gid;
        this.checkAndUpdateMaps();
        try {
            gid = this.getGid(group);
        }
        catch (IOException e) {
            gid = group.hashCode();
            LOG.info((Object)("Can't map group " + group + ". Use its string hashcode:" + gid), (Throwable)e);
        }
        return gid;
    }
}

