/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcDeniedReply;
import org.apache.hadoop.oncrpc.RpcInfo;
import org.apache.hadoop.oncrpc.RpcReply;
import org.apache.hadoop.oncrpc.RpcResponse;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.apache.hadoop.oncrpc.SimpleUdpClient;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.apache.hadoop.portmap.PortmapMapping;
import org.apache.hadoop.portmap.PortmapRequest;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public abstract class RpcProgram
extends SimpleChannelUpstreamHandler {
    static final Log LOG = LogFactory.getLog(RpcProgram.class);
    public static final int RPCB_PORT = 111;
    private final String program;
    private final String host;
    private int port;
    private final int progNumber;
    private final int lowProgVersion;
    private final int highProgVersion;
    protected final boolean allowInsecurePorts;
    private final DatagramSocket registrationSocket;

    protected RpcProgram(String program, String host, int port, int progNumber, int lowProgVersion, int highProgVersion, DatagramSocket registrationSocket, boolean allowInsecurePorts) {
        this.program = program;
        this.host = host;
        this.port = port;
        this.progNumber = progNumber;
        this.lowProgVersion = lowProgVersion;
        this.highProgVersion = highProgVersion;
        this.registrationSocket = registrationSocket;
        this.allowInsecurePorts = allowInsecurePorts;
        LOG.info((Object)("Will " + (allowInsecurePorts ? "" : "not ") + "accept client " + "connections from unprivileged ports"));
    }

    public void register(int transport, int boundPort) {
        if (boundPort != this.port) {
            LOG.info((Object)("The bound port is " + boundPort + ", different with configured port " + this.port));
            this.port = boundPort;
        }
        for (int vers = this.lowProgVersion; vers <= this.highProgVersion; ++vers) {
            PortmapMapping mapEntry = new PortmapMapping(this.progNumber, vers, transport, this.port);
            this.register(mapEntry, true);
        }
    }

    public void unregister(int transport, int boundPort) {
        if (boundPort != this.port) {
            LOG.info((Object)("The bound port is " + boundPort + ", different with configured port " + this.port));
            this.port = boundPort;
        }
        for (int vers = this.lowProgVersion; vers <= this.highProgVersion; ++vers) {
            PortmapMapping mapEntry = new PortmapMapping(this.progNumber, vers, transport, this.port);
            this.register(mapEntry, false);
        }
    }

    protected void register(PortmapMapping mapEntry, boolean set) {
        XDR mappingRequest = PortmapRequest.create(mapEntry, set);
        SimpleUdpClient registrationClient = new SimpleUdpClient(this.host, 111, mappingRequest, this.registrationSocket);
        try {
            registrationClient.run();
        }
        catch (IOException e) {
            String request = set ? "Registration" : "Unregistration";
            LOG.error((Object)(request + " failure with " + this.host + ":" + this.port + ", portmap entry: " + mapEntry));
            throw new RuntimeException(request + " failure", e);
        }
    }

    public void startDaemons() {
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        RpcInfo info = (RpcInfo)e.getMessage();
        RpcCall call = (RpcCall)info.header();
        SocketAddress remoteAddress = info.remoteAddress();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.program + " procedure #" + call.getProcedure()));
        }
        if (this.progNumber != call.getProgram()) {
            LOG.warn((Object)("Invalid RPC call program " + call.getProgram()));
            this.sendAcceptedReply(call, remoteAddress, RpcAcceptedReply.AcceptState.PROG_UNAVAIL, ctx);
            return;
        }
        int ver = call.getVersion();
        if (ver < this.lowProgVersion || ver > this.highProgVersion) {
            LOG.warn((Object)("Invalid RPC call version " + ver));
            this.sendAcceptedReply(call, remoteAddress, RpcAcceptedReply.AcceptState.PROG_MISMATCH, ctx);
            return;
        }
        this.handleInternal(ctx, info);
    }

    public boolean doPortMonitoring(SocketAddress remoteAddress) {
        if (!this.allowInsecurePorts) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)"Will not allow connections from unprivileged ports. Checking for valid client port...");
            }
            if (remoteAddress instanceof InetSocketAddress) {
                InetSocketAddress inetRemoteAddress = (InetSocketAddress)remoteAddress;
                if (inetRemoteAddress.getPort() > 1023) {
                    LOG.warn((Object)("Connection attempted from '" + inetRemoteAddress + "' " + "which is an unprivileged port. Rejecting connection."));
                    return false;
                }
            } else {
                LOG.warn((Object)("Could not determine remote port of socket address '" + remoteAddress + "'. Rejecting connection."));
                return false;
            }
        }
        return true;
    }

    private void sendAcceptedReply(RpcCall call, SocketAddress remoteAddress, RpcAcceptedReply.AcceptState acceptState, ChannelHandlerContext ctx) {
        RpcAcceptedReply reply = RpcAcceptedReply.getInstance(call.getXid(), acceptState, Verifier.VERIFIER_NONE);
        XDR out = new XDR();
        reply.write(out);
        if (acceptState == RpcAcceptedReply.AcceptState.PROG_MISMATCH) {
            out.writeInt(this.lowProgVersion);
            out.writeInt(this.highProgVersion);
        }
        ChannelBuffer b = ChannelBuffers.wrappedBuffer((ByteBuffer)out.asReadOnlyWrap().buffer());
        RpcResponse rsp = new RpcResponse(b, remoteAddress);
        RpcUtil.sendRpcResponse(ctx, rsp);
    }

    protected static void sendRejectedReply(RpcCall call, SocketAddress remoteAddress, ChannelHandlerContext ctx) {
        XDR out = new XDR();
        RpcDeniedReply reply = new RpcDeniedReply(call.getXid(), RpcReply.ReplyState.MSG_DENIED, RpcDeniedReply.RejectState.AUTH_ERROR, new VerifierNone());
        reply.write(out);
        ChannelBuffer buf = ChannelBuffers.wrappedBuffer((ByteBuffer)out.asReadOnlyWrap().buffer());
        RpcResponse rsp = new RpcResponse(buf, remoteAddress);
        RpcUtil.sendRpcResponse(ctx, rsp);
    }

    protected abstract void handleInternal(ChannelHandlerContext var1, RpcInfo var2);

    public String toString() {
        return "Rpc program: " + this.program + " at " + this.host + ":" + this.port;
    }

    protected abstract boolean isIdempotent(RpcCall var1);

    public int getPort() {
        return this.port;
    }
}

