/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.SimpleTcpServer;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;

public abstract class Nfs3Base {
    public static final Log LOG = LogFactory.getLog(Nfs3Base.class);
    private final RpcProgram rpcProgram;
    private int nfsBoundPort;
    public static final int SHUTDOWN_HOOK_PRIORITY = 10;

    public RpcProgram getRpcProgram() {
        return this.rpcProgram;
    }

    protected Nfs3Base(RpcProgram rpcProgram, Configuration conf) {
        this.rpcProgram = rpcProgram;
        LOG.info((Object)("NFS server port set to: " + rpcProgram.getPort()));
    }

    public void start(boolean register) {
        this.startTCPServer();
        if (register) {
            ShutdownHookManager.get().addShutdownHook((Runnable)new NfsShutdownHook(), 10);
            try {
                this.rpcProgram.register(6, this.nfsBoundPort);
            }
            catch (Throwable e) {
                LOG.fatal((Object)"Failed to start the server. Cause:", e);
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    private void startTCPServer() {
        SimpleTcpServer tcpServer = new SimpleTcpServer(this.rpcProgram.getPort(), this.rpcProgram, 0);
        this.rpcProgram.startDaemons();
        tcpServer.run();
        this.nfsBoundPort = tcpServer.getBoundPort();
    }

    private class NfsShutdownHook
    implements Runnable {
        private NfsShutdownHook() {
        }

        @Override
        public synchronized void run() {
            Nfs3Base.this.rpcProgram.unregister(6, Nfs3Base.this.nfsBoundPort);
            Nfs3Base.this.rpcProgram.stopDaemons();
        }
    }
}

