/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcMessage;
import org.apache.hadoop.oncrpc.RpcReply;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.junit.Assert;
import org.junit.Test;

public class TestRpcAcceptedReply {
    @Test
    public void testAcceptState() {
        Assert.assertEquals((Object)RpcAcceptedReply.AcceptState.SUCCESS, (Object)RpcAcceptedReply.AcceptState.fromValue((int)0));
        Assert.assertEquals((Object)RpcAcceptedReply.AcceptState.PROG_UNAVAIL, (Object)RpcAcceptedReply.AcceptState.fromValue((int)1));
        Assert.assertEquals((Object)RpcAcceptedReply.AcceptState.PROG_MISMATCH, (Object)RpcAcceptedReply.AcceptState.fromValue((int)2));
        Assert.assertEquals((Object)RpcAcceptedReply.AcceptState.PROC_UNAVAIL, (Object)RpcAcceptedReply.AcceptState.fromValue((int)3));
        Assert.assertEquals((Object)RpcAcceptedReply.AcceptState.GARBAGE_ARGS, (Object)RpcAcceptedReply.AcceptState.fromValue((int)4));
        Assert.assertEquals((Object)RpcAcceptedReply.AcceptState.SYSTEM_ERR, (Object)RpcAcceptedReply.AcceptState.fromValue((int)5));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testAcceptStateFromInvalidValue() {
        RpcAcceptedReply.AcceptState.fromValue((int)6);
    }

    @Test
    public void testConstructor() {
        VerifierNone verifier = new VerifierNone();
        RpcAcceptedReply reply = new RpcAcceptedReply(0, RpcReply.ReplyState.MSG_ACCEPTED, (Verifier)verifier, RpcAcceptedReply.AcceptState.SUCCESS);
        Assert.assertEquals((long)0L, (long)reply.getXid());
        Assert.assertEquals((Object)RpcMessage.Type.RPC_REPLY, (Object)reply.getMessageType());
        Assert.assertEquals((Object)RpcReply.ReplyState.MSG_ACCEPTED, (Object)reply.getState());
        Assert.assertEquals((Object)verifier, (Object)reply.getVerifier());
        Assert.assertEquals((Object)RpcAcceptedReply.AcceptState.SUCCESS, (Object)reply.getAcceptState());
    }
}

