/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcMessage;
import org.apache.hadoop.oncrpc.security.Credentials;
import org.apache.hadoop.oncrpc.security.CredentialsNone;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.oncrpc.security.VerifierNone;
import org.junit.Assert;
import org.junit.Test;

public class TestRpcCall {
    @Test
    public void testConstructor() {
        CredentialsNone credential = new CredentialsNone();
        VerifierNone verifier = new VerifierNone();
        int rpcVersion = 2;
        int program = 2;
        int version = 3;
        int procedure = 4;
        RpcCall call = new RpcCall(0, RpcMessage.Type.RPC_CALL, rpcVersion, program, version, procedure, (Credentials)credential, (Verifier)verifier);
        Assert.assertEquals((long)0L, (long)call.getXid());
        Assert.assertEquals((Object)RpcMessage.Type.RPC_CALL, (Object)call.getMessageType());
        Assert.assertEquals((long)rpcVersion, (long)call.getRpcVersion());
        Assert.assertEquals((long)program, (long)call.getProgram());
        Assert.assertEquals((long)version, (long)call.getVersion());
        Assert.assertEquals((long)procedure, (long)call.getProcedure());
        Assert.assertEquals((Object)credential, (Object)call.getCredential());
        Assert.assertEquals((Object)verifier, (Object)call.getVerifier());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRpcVersion() {
        int invalidRpcVersion = 3;
        new RpcCall(0, RpcMessage.Type.RPC_CALL, invalidRpcVersion, 2, 3, 4, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidRpcMessageType() {
        RpcMessage.Type invalidMessageType = RpcMessage.Type.RPC_REPLY;
        new RpcCall(0, invalidMessageType, 2, 2, 3, 4, null, null);
    }
}

