/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc.security;

import org.apache.hadoop.oncrpc.XDR;

public abstract class RpcAuthInfo {
    private final AuthFlavor flavor;

    protected RpcAuthInfo(AuthFlavor flavor) {
        this.flavor = flavor;
    }

    public abstract void read(XDR var1);

    public abstract void write(XDR var1);

    public AuthFlavor getFlavor() {
        return this.flavor;
    }

    public String toString() {
        return "(AuthFlavor:" + (Object)((Object)this.flavor) + ")";
    }

    public static enum AuthFlavor {
        AUTH_NONE(0),
        AUTH_SYS(1),
        AUTH_SHORT(2),
        AUTH_DH(3),
        RPCSEC_GSS(6);

        private int value;

        private AuthFlavor(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        static AuthFlavor fromValue(int value) {
            for (AuthFlavor v : AuthFlavor.values()) {
                if (v.value != value) continue;
                return v;
            }
            throw new IllegalArgumentException("Invalid AuthFlavor value " + value);
        }
    }
}

