/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc.security;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Credentials;
import org.apache.hadoop.oncrpc.security.RpcAuthInfo;

public class CredentialsSys
extends Credentials {
    private static final String HOSTNAME;
    protected int mUID;
    protected int mGID;
    protected int[] mAuxGIDs;
    protected String mHostName;
    protected int mStamp;

    public CredentialsSys() {
        super(RpcAuthInfo.AuthFlavor.AUTH_SYS);
        this.mCredentialsLength = 0;
        this.mHostName = HOSTNAME;
    }

    public int getGID() {
        return this.mGID;
    }

    public int getUID() {
        return this.mUID;
    }

    public int[] getAuxGIDs() {
        return this.mAuxGIDs;
    }

    @VisibleForTesting
    int getStamp() {
        return this.mStamp;
    }

    public void setGID(int gid) {
        this.mGID = gid;
    }

    public void setUID(int uid) {
        this.mUID = uid;
    }

    public void setStamp(int stamp) {
        this.mStamp = stamp;
    }

    @VisibleForTesting
    void setHostName(String hostname) {
        this.mHostName = hostname;
    }

    @Override
    public void read(XDR xdr) {
        this.mCredentialsLength = xdr.readInt();
        this.mStamp = xdr.readInt();
        this.mHostName = xdr.readString();
        this.mUID = xdr.readInt();
        this.mGID = xdr.readInt();
        int length = xdr.readInt();
        this.mAuxGIDs = new int[length];
        for (int i = 0; i < length; ++i) {
            this.mAuxGIDs[i] = xdr.readInt();
        }
    }

    @Override
    public void write(XDR xdr) {
        int padding = 0;
        padding = 4 - this.mHostName.getBytes(StandardCharsets.UTF_8).length % 4;
        this.mCredentialsLength = 20 + this.mHostName.getBytes(StandardCharsets.UTF_8).length;
        this.mCredentialsLength += (padding %= 4);
        if (this.mAuxGIDs != null && this.mAuxGIDs.length > 0) {
            this.mCredentialsLength += this.mAuxGIDs.length * 4;
        }
        xdr.writeInt(this.mCredentialsLength);
        xdr.writeInt(this.mStamp);
        xdr.writeString(this.mHostName);
        xdr.writeInt(this.mUID);
        xdr.writeInt(this.mGID);
        if (this.mAuxGIDs == null || this.mAuxGIDs.length == 0) {
            xdr.writeInt(0);
        } else {
            xdr.writeInt(this.mAuxGIDs.length);
            for (int i = 0; i < this.mAuxGIDs.length; ++i) {
                xdr.writeInt(this.mAuxGIDs[i]);
            }
        }
    }

    static {
        try {
            String s;
            HOSTNAME = s = InetAddress.getLocalHost().getHostName();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("HOSTNAME = " + HOSTNAME));
            }
        }
        catch (UnknownHostException e) {
            LOG.error((Object)"Error setting HOSTNAME", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

