/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

public class SimpleTcpServer {
    public static final Log LOG = LogFactory.getLog(SimpleTcpServer.class);
    protected final int port;
    protected int boundPort = -1;
    protected final SimpleChannelUpstreamHandler rpcProgram;
    private ServerBootstrap server;
    private Channel ch;
    protected final int workerCount;

    public SimpleTcpServer(int port, RpcProgram program, int workercount) {
        this.port = port;
        this.rpcProgram = program;
        this.workerCount = workercount;
    }

    public void run() {
        NioServerSocketChannelFactory factory = this.workerCount == 0 ? new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()) : new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool(), this.workerCount);
        this.server = new ServerBootstrap((ChannelFactory)factory);
        this.server.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{RpcUtil.constructRpcFrameDecoder(), RpcUtil.STAGE_RPC_MESSAGE_PARSER, SimpleTcpServer.this.rpcProgram, RpcUtil.STAGE_RPC_TCP_RESPONSE});
            }
        });
        this.server.setOption("child.tcpNoDelay", (Object)true);
        this.server.setOption("child.keepAlive", (Object)true);
        this.server.setOption("child.reuseAddress", (Object)true);
        this.server.setOption("reuseAddress", (Object)true);
        this.ch = this.server.bind((SocketAddress)new InetSocketAddress(this.port));
        InetSocketAddress socketAddr = (InetSocketAddress)this.ch.getLocalAddress();
        this.boundPort = socketAddr.getPort();
        LOG.info((Object)("Started listening to TCP requests at port " + this.boundPort + " for " + this.rpcProgram + " with workerCount " + this.workerCount));
    }

    public int getBoundPort() {
        return this.boundPort;
    }

    public void shutdown() {
        if (this.ch != null) {
            this.ch.close().awaitUninterruptibly();
        }
        if (this.server != null) {
            this.server.releaseExternalResources();
        }
    }
}

