/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.hdds.scm.client.HddsClientUtils;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.OzoneConfigKeys;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadList;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadPartListParts;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.client.protocol.ClientProtocol;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.WithMetadata;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.util.Time;

public class OzoneBucket
extends WithMetadata {
    private final ClientProtocol proxy;
    private final String volumeName;
    private final String name;
    private final ReplicationFactor defaultReplication;
    private final ReplicationType defaultReplicationType;
    private StorageType storageType;
    private Boolean versioning;
    private int listCacheSize;
    private Instant creationTime;
    private Instant modificationTime;
    private String encryptionKeyName;
    private OzoneObj ozoneObj;
    private String sourceVolume;
    private String sourceBucket;

    private OzoneBucket(ConfigurationSource conf, String volumeName, String bucketName, ReplicationFactor defaultReplication, ReplicationType defaultReplicationType, ClientProtocol proxy) {
        Preconditions.checkNotNull((Object)proxy, (Object)"Client proxy is not set.");
        this.volumeName = volumeName;
        this.name = bucketName;
        this.defaultReplication = defaultReplication == null ? ReplicationFactor.valueOf((int)conf.getInt("ozone.replication", OzoneConfigKeys.OZONE_REPLICATION_DEFAULT)) : defaultReplication;
        this.defaultReplicationType = defaultReplicationType == null ? ReplicationType.valueOf((String)conf.get("ozone.replication.type", OzoneConfigKeys.OZONE_REPLICATION_TYPE_DEFAULT)) : defaultReplicationType;
        this.proxy = proxy;
        this.ozoneObj = OzoneObjInfo.Builder.newBuilder().setBucketName(bucketName).setVolumeName(volumeName).setResType(OzoneObj.ResourceType.BUCKET).setStoreType(OzoneObj.StoreType.OZONE).build();
    }

    public OzoneBucket(ConfigurationSource conf, ClientProtocol proxy, String volumeName, String bucketName, StorageType storageType, Boolean versioning, long creationTime, Map<String, String> metadata, String encryptionKeyName, String sourceVolume, String sourceBucket) {
        this(conf, volumeName, bucketName, null, null, proxy);
        this.storageType = storageType;
        this.versioning = versioning;
        this.listCacheSize = HddsClientUtils.getListCacheSize((ConfigurationSource)conf);
        this.creationTime = Instant.ofEpochMilli(creationTime);
        this.metadata = metadata;
        this.encryptionKeyName = encryptionKeyName;
        this.sourceVolume = sourceVolume;
        this.sourceBucket = sourceBucket;
        this.modificationTime = Instant.now();
        if (this.modificationTime.isBefore(this.creationTime)) {
            this.modificationTime = Instant.ofEpochSecond(this.creationTime.getEpochSecond(), this.creationTime.getNano());
        }
    }

    public OzoneBucket(ConfigurationSource conf, ClientProtocol proxy, String volumeName, String bucketName, StorageType storageType, Boolean versioning, long creationTime, long modificationTime, Map<String, String> metadata, String encryptionKeyName, String sourceVolume, String sourceBucket) {
        this(conf, proxy, volumeName, bucketName, storageType, versioning, creationTime, metadata, encryptionKeyName, sourceVolume, sourceBucket);
        this.modificationTime = Instant.ofEpochMilli(modificationTime);
    }

    public OzoneBucket(ConfigurationSource conf, ClientProtocol proxy, String volumeName, String bucketName, StorageType storageType, Boolean versioning, long creationTime, Map<String, String> metadata) {
        this(conf, volumeName, bucketName, null, null, proxy);
        this.storageType = storageType;
        this.versioning = versioning;
        this.listCacheSize = HddsClientUtils.getListCacheSize((ConfigurationSource)conf);
        this.creationTime = Instant.ofEpochMilli(creationTime);
        this.metadata = metadata;
        this.modificationTime = Instant.now();
        if (this.modificationTime.isBefore(this.creationTime)) {
            this.modificationTime = Instant.ofEpochSecond(this.creationTime.getEpochSecond(), this.creationTime.getNano());
        }
    }

    public OzoneBucket(ConfigurationSource conf, ClientProtocol proxy, String volumeName, String bucketName, StorageType storageType, Boolean versioning, long creationTime, long modificationTime, Map<String, String> metadata) {
        this(conf, proxy, volumeName, bucketName, storageType, versioning, creationTime, metadata);
        this.modificationTime = Instant.ofEpochMilli(modificationTime);
    }

    @VisibleForTesting
    OzoneBucket(String volumeName, String name, ReplicationFactor defaultReplication, ReplicationType defaultReplicationType, StorageType storageType, Boolean versioning, long creationTime) {
        this.proxy = null;
        this.volumeName = volumeName;
        this.name = name;
        this.defaultReplication = defaultReplication;
        this.defaultReplicationType = defaultReplicationType;
        this.storageType = storageType;
        this.versioning = versioning;
        this.creationTime = Instant.ofEpochMilli(creationTime);
        this.ozoneObj = OzoneObjInfo.Builder.newBuilder().setBucketName(name).setVolumeName(volumeName).setResType(OzoneObj.ResourceType.BUCKET).setStoreType(OzoneObj.StoreType.OZONE).build();
        long modifiedTime = Time.now();
        this.modificationTime = modifiedTime < creationTime ? Instant.ofEpochMilli(creationTime) : Instant.ofEpochMilli(modifiedTime);
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public List<OzoneAcl> getAcls() throws IOException {
        return this.proxy.getAcl(this.ozoneObj);
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public Boolean getVersioning() {
        return this.versioning;
    }

    public Instant getCreationTime() {
        return this.creationTime;
    }

    public Instant getModificationTime() {
        return this.modificationTime;
    }

    public String getEncryptionKeyName() {
        return this.encryptionKeyName;
    }

    public String getSourceVolume() {
        return this.sourceVolume;
    }

    public String getSourceBucket() {
        return this.sourceBucket;
    }

    public boolean addAcls(OzoneAcl addAcl) throws IOException {
        return this.proxy.addAcl(this.ozoneObj, addAcl);
    }

    public boolean removeAcls(OzoneAcl removeAcl) throws IOException {
        return this.proxy.removeAcl(this.ozoneObj, removeAcl);
    }

    public void setStorageType(StorageType newStorageType) throws IOException {
        this.proxy.setBucketStorageType(this.volumeName, this.name, newStorageType);
        this.storageType = newStorageType;
    }

    public void setVersioning(Boolean newVersioning) throws IOException {
        this.proxy.setBucketVersioning(this.volumeName, this.name, newVersioning);
        this.versioning = newVersioning;
    }

    public OzoneOutputStream createKey(String key, long size) throws IOException {
        return this.createKey(key, size, this.defaultReplicationType, this.defaultReplication, new HashMap<String, String>());
    }

    public OzoneOutputStream createKey(String key, long size, ReplicationType type, ReplicationFactor factor, Map<String, String> keyMetadata) throws IOException {
        return this.proxy.createKey(this.volumeName, this.name, key, size, type, factor, keyMetadata);
    }

    public OzoneInputStream readKey(String key) throws IOException {
        return this.proxy.getKey(this.volumeName, this.name, key);
    }

    public OzoneKeyDetails getKey(String key) throws IOException {
        return this.proxy.getKeyDetails(this.volumeName, this.name, key);
    }

    public Iterator<? extends OzoneKey> listKeys(String keyPrefix) {
        return this.listKeys(keyPrefix, null);
    }

    public Iterator<? extends OzoneKey> listKeys(String keyPrefix, String prevKey) {
        return new KeyIterator(keyPrefix, prevKey);
    }

    public void deleteKey(String key) throws IOException {
        this.proxy.deleteKey(this.volumeName, this.name, key);
    }

    public void deleteKeys(List<String> keyList) throws IOException {
        this.proxy.deleteKeys(this.volumeName, this.name, keyList);
    }

    public void renameKey(String fromKeyName, String toKeyName) throws IOException {
        this.proxy.renameKey(this.volumeName, this.name, fromKeyName, toKeyName);
    }

    public OmMultipartInfo initiateMultipartUpload(String keyName, ReplicationType type, ReplicationFactor factor) throws IOException {
        return this.proxy.initiateMultipartUpload(this.volumeName, this.name, keyName, type, factor);
    }

    public OmMultipartInfo initiateMultipartUpload(String key) throws IOException {
        return this.initiateMultipartUpload(key, this.defaultReplicationType, this.defaultReplication);
    }

    public OzoneOutputStream createMultipartKey(String key, long size, int partNumber, String uploadID) throws IOException {
        return this.proxy.createMultipartKey(this.volumeName, this.name, key, size, partNumber, uploadID);
    }

    public OmMultipartUploadCompleteInfo completeMultipartUpload(String key, String uploadID, Map<Integer, String> partsMap) throws IOException {
        return this.proxy.completeMultipartUpload(this.volumeName, this.name, key, uploadID, partsMap);
    }

    public void abortMultipartUpload(String keyName, String uploadID) throws IOException {
        this.proxy.abortMultipartUpload(this.volumeName, this.name, keyName, uploadID);
    }

    public OzoneMultipartUploadPartListParts listParts(String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        return this.proxy.listParts(this.volumeName, this.name, keyName, uploadID, partNumberMarker, maxParts);
    }

    public OzoneFileStatus getFileStatus(String keyName) throws IOException {
        return this.proxy.getOzoneFileStatus(this.volumeName, this.name, keyName);
    }

    public void createDirectory(String keyName) throws IOException {
        this.proxy.createDirectory(this.volumeName, this.name, keyName);
    }

    public OzoneInputStream readFile(String keyName) throws IOException {
        return this.proxy.readFile(this.volumeName, this.name, keyName);
    }

    public OzoneOutputStream createFile(String keyName, long size, ReplicationType type, ReplicationFactor factor, boolean overWrite, boolean recursive) throws IOException {
        return this.proxy.createFile(this.volumeName, this.name, keyName, size, type, factor, overWrite, recursive);
    }

    public List<OzoneFileStatus> listStatus(String keyName, boolean recursive, String startKey, long numEntries) throws IOException {
        return this.proxy.listStatus(this.volumeName, this.name, keyName, recursive, startKey, numEntries);
    }

    public OzoneMultipartUploadList listMultipartUploads(String prefix) throws IOException {
        return this.proxy.listMultipartUploads(this.volumeName, this.getName(), prefix);
    }

    private class KeyIterator
    implements Iterator<OzoneKey> {
        private String keyPrefix = null;
        private Iterator<OzoneKey> currentIterator;
        private OzoneKey currentValue;

        KeyIterator(String keyPrefix, String prevKey) {
            this.keyPrefix = keyPrefix;
            this.currentValue = null;
            this.currentIterator = this.getNextListOfKeys(prevKey).iterator();
        }

        @Override
        public boolean hasNext() {
            if (!this.currentIterator.hasNext() && this.currentValue != null) {
                this.currentIterator = this.getNextListOfKeys(this.currentValue.getName()).iterator();
            }
            return this.currentIterator.hasNext();
        }

        @Override
        public OzoneKey next() {
            if (this.hasNext()) {
                this.currentValue = this.currentIterator.next();
                return this.currentValue;
            }
            throw new NoSuchElementException();
        }

        private List<OzoneKey> getNextListOfKeys(String prevKey) {
            try {
                return OzoneBucket.this.proxy.listKeys(OzoneBucket.this.volumeName, OzoneBucket.this.name, this.keyPrefix, prevKey, OzoneBucket.this.listCacheSize);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

