/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.io;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.XceiverClientManager;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.ozone.client.io.BlockOutputStreamEntry;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockOutputStreamEntryPool {
    public static final Logger LOG = LoggerFactory.getLogger(BlockOutputStreamEntryPool.class);
    private final List<BlockOutputStreamEntry> streamEntries = new ArrayList<BlockOutputStreamEntry>();
    private int currentStreamIndex;
    private final OzoneManagerProtocol omClient;
    private final OmKeyArgs keyArgs;
    private final XceiverClientManager xceiverClientManager;
    private final int chunkSize;
    private final String requestID;
    private final int streamBufferSize;
    private final long streamBufferFlushSize;
    private final boolean streamBufferFlushDelay;
    private final long streamBufferMaxSize;
    private final long watchTimeout;
    private final long blockSize;
    private final int bytesPerChecksum;
    private final ContainerProtos.ChecksumType checksumType;
    private final BufferPool bufferPool;
    private OmMultipartCommitUploadPartInfo commitUploadPartInfo;
    private final long openID;
    private final ExcludeList excludeList;

    public BlockOutputStreamEntryPool(OzoneManagerProtocol omClient, int chunkSize, String requestId, HddsProtos.ReplicationFactor factor, HddsProtos.ReplicationType type, int bufferSize, long bufferFlushSize, boolean bufferFlushDelay, long bufferMaxSize, long size, long watchTimeout, ContainerProtos.ChecksumType checksumType, int bytesPerChecksum, String uploadID, int partNumber, boolean isMultipart, OmKeyInfo info, XceiverClientManager xceiverClientManager, long openID) {
        this.currentStreamIndex = 0;
        this.omClient = omClient;
        this.keyArgs = new OmKeyArgs.Builder().setVolumeName(info.getVolumeName()).setBucketName(info.getBucketName()).setKeyName(info.getKeyName()).setType(type).setFactor(factor).setDataSize(info.getDataSize()).setIsMultipartKey(isMultipart).setMultipartUploadID(uploadID).setMultipartUploadPartNumber(partNumber).build();
        this.xceiverClientManager = xceiverClientManager;
        this.chunkSize = chunkSize;
        this.requestID = requestId;
        this.streamBufferSize = bufferSize;
        this.streamBufferFlushSize = bufferFlushSize;
        this.streamBufferFlushDelay = bufferFlushDelay;
        this.streamBufferMaxSize = bufferMaxSize;
        this.blockSize = size;
        this.watchTimeout = watchTimeout;
        this.bytesPerChecksum = bytesPerChecksum;
        this.checksumType = checksumType;
        this.openID = openID;
        this.excludeList = new ExcludeList();
        Preconditions.checkState((chunkSize > 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.streamBufferSize > 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.streamBufferFlushSize > 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.streamBufferMaxSize > 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.blockSize > 0L ? 1 : 0) != 0);
        Preconditions.checkState((this.blockSize >= this.streamBufferMaxSize ? 1 : 0) != 0);
        Preconditions.checkState((this.streamBufferMaxSize % this.streamBufferFlushSize == 0L ? 1 : 0) != 0, (String)"expected max. buffer size (%s) to be a multiple of flush size (%s)", (long)this.streamBufferMaxSize, (long)this.streamBufferFlushSize);
        Preconditions.checkState((this.streamBufferFlushSize % (long)this.streamBufferSize == 0L ? 1 : 0) != 0, (String)"expected flush size (%s) to be a multiple of buffer size (%s)", (long)this.streamBufferFlushSize, (int)this.streamBufferSize);
        Preconditions.checkState((chunkSize % this.streamBufferSize == 0 ? 1 : 0) != 0, (String)"expected chunk size (%s) to be a multiple of buffer size (%s)", (int)chunkSize, (int)this.streamBufferSize);
        this.bufferPool = new BufferPool(this.streamBufferSize, (int)(this.streamBufferMaxSize / (long)this.streamBufferSize), xceiverClientManager.byteBufferToByteStringConversion());
    }

    @VisibleForTesting
    BlockOutputStreamEntryPool() {
        this.omClient = null;
        this.keyArgs = null;
        this.xceiverClientManager = null;
        this.chunkSize = 0;
        this.requestID = null;
        this.streamBufferSize = 0;
        this.streamBufferFlushSize = 0L;
        this.streamBufferFlushDelay = false;
        this.streamBufferMaxSize = 0L;
        this.bufferPool = new BufferPool(this.chunkSize, 1);
        this.watchTimeout = 0L;
        this.blockSize = 0L;
        this.checksumType = ContainerProtos.ChecksumType.valueOf((String)"CRC32");
        this.bytesPerChecksum = 0x100000;
        this.currentStreamIndex = 0;
        this.openID = -1L;
        this.excludeList = new ExcludeList();
    }

    public void addPreallocateBlocks(OmKeyLocationInfoGroup version, long openVersion) throws IOException {
        for (OmKeyLocationInfo subKeyInfo : version.getLocationList()) {
            if (subKeyInfo.getCreateVersion() != openVersion) continue;
            this.addKeyLocationInfo(subKeyInfo);
        }
    }

    private void addKeyLocationInfo(OmKeyLocationInfo subKeyInfo) throws IOException {
        Preconditions.checkNotNull((Object)subKeyInfo.getPipeline());
        UserGroupInformation.getCurrentUser().addToken(subKeyInfo.getToken());
        BlockOutputStreamEntry.Builder builder = new BlockOutputStreamEntry.Builder().setBlockID(subKeyInfo.getBlockID()).setKey(this.keyArgs.getKeyName()).setXceiverClientManager(this.xceiverClientManager).setPipeline(subKeyInfo.getPipeline()).setRequestId(this.requestID).setChunkSize(this.chunkSize).setLength(subKeyInfo.getLength()).setStreamBufferSize(this.streamBufferSize).setStreamBufferFlushSize(this.streamBufferFlushSize).setStreamBufferFlushDelay(this.streamBufferFlushDelay).setStreamBufferMaxSize(this.streamBufferMaxSize).setWatchTimeout(this.watchTimeout).setbufferPool(this.bufferPool).setChecksumType(this.checksumType).setBytesPerChecksum(this.bytesPerChecksum).setToken((Token<OzoneBlockTokenIdentifier>)subKeyInfo.getToken());
        this.streamEntries.add(builder.build());
    }

    public List<OmKeyLocationInfo> getLocationInfoList() {
        ArrayList<OmKeyLocationInfo> locationInfoList = new ArrayList<OmKeyLocationInfo>();
        for (BlockOutputStreamEntry streamEntry : this.streamEntries) {
            long length = streamEntry.getCurrentPosition();
            if (length != 0L) {
                OmKeyLocationInfo info = new OmKeyLocationInfo.Builder().setBlockID(streamEntry.getBlockID()).setLength(streamEntry.getCurrentPosition()).setOffset(0L).setToken(streamEntry.getToken()).setPipeline(streamEntry.getPipeline()).build();
                locationInfoList.add(info);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("block written " + streamEntry.getBlockID() + ", length " + length + " bcsID " + streamEntry.getBlockID().getBlockCommitSequenceId());
        }
        return locationInfoList;
    }

    void discardPreallocatedBlocks(long containerID, PipelineID pipelineId) {
        if (this.currentStreamIndex + 1 < this.streamEntries.size()) {
            ListIterator<BlockOutputStreamEntry> streamEntryIterator = this.streamEntries.listIterator(this.currentStreamIndex + 1);
            while (streamEntryIterator.hasNext()) {
                BlockOutputStreamEntry streamEntry = streamEntryIterator.next();
                Preconditions.checkArgument((streamEntry.getCurrentPosition() == 0L ? 1 : 0) != 0);
                if (!streamEntry.getPipeline().getId().equals((Object)pipelineId) && (containerID == -1L || streamEntry.getBlockID().getContainerID() != containerID)) continue;
                streamEntryIterator.remove();
            }
        }
    }

    List<BlockOutputStreamEntry> getStreamEntries() {
        return this.streamEntries;
    }

    XceiverClientManager getXceiverClientManager() {
        return this.xceiverClientManager;
    }

    String getKeyName() {
        return this.keyArgs.getKeyName();
    }

    long getKeyLength() {
        return this.streamEntries.stream().mapToLong(BlockOutputStreamEntry::getCurrentPosition).sum();
    }

    private void allocateNewBlock() throws IOException {
        if (!this.excludeList.isEmpty()) {
            LOG.info("Allocating block with {}", (Object)this.excludeList);
        }
        OmKeyLocationInfo subKeyInfo = this.omClient.allocateBlock(this.keyArgs, this.openID, this.excludeList);
        this.addKeyLocationInfo(subKeyInfo);
    }

    void commitKey(long offset) throws IOException {
        if (this.keyArgs != null) {
            long length = this.getKeyLength();
            Preconditions.checkArgument((offset == length ? 1 : 0) != 0);
            this.keyArgs.setDataSize(length);
            this.keyArgs.setLocationInfoList(this.getLocationInfoList());
            if (this.keyArgs.getIsMultipartKey()) {
                this.commitUploadPartInfo = this.omClient.commitMultipartUploadPart(this.keyArgs, this.openID);
            } else {
                this.omClient.commitKey(this.keyArgs, this.openID);
            }
        } else {
            LOG.warn("Closing KeyOutputStream, but key args is null");
        }
    }

    public BlockOutputStreamEntry getCurrentStreamEntry() {
        if (this.streamEntries.isEmpty() || this.streamEntries.size() <= this.currentStreamIndex) {
            return null;
        }
        return this.streamEntries.get(this.currentStreamIndex);
    }

    BlockOutputStreamEntry allocateBlockIfNeeded() throws IOException {
        BlockOutputStreamEntry streamEntry = this.getCurrentStreamEntry();
        if (streamEntry != null && streamEntry.isClosed()) {
            ++this.currentStreamIndex;
        }
        if (this.streamEntries.size() <= this.currentStreamIndex) {
            Preconditions.checkNotNull((Object)this.omClient);
            this.allocateNewBlock();
        }
        Preconditions.checkArgument((this.currentStreamIndex < this.streamEntries.size() ? 1 : 0) != 0);
        return this.streamEntries.get(this.currentStreamIndex);
    }

    long computeBufferData() {
        return this.bufferPool.computeBufferData();
    }

    void cleanup() {
        if (this.excludeList != null) {
            this.excludeList.clear();
        }
        if (this.bufferPool != null) {
            this.bufferPool.clearBufferPool();
        }
        if (this.streamEntries != null) {
            this.streamEntries.clear();
        }
    }

    public OmMultipartCommitUploadPartInfo getCommitUploadPartInfo() {
        return this.commitUploadPartInfo;
    }

    public ExcludeList getExcludeList() {
        return this.excludeList;
    }

    public long getStreamBufferMaxSize() {
        return this.streamBufferMaxSize;
    }

    boolean isEmpty() {
        return this.streamEntries.isEmpty();
    }
}

