/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.exceptions;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ratis.protocol.NotLeaderException;
import org.apache.ratis.protocol.RaftPeerId;

public class OMNotLeaderException
extends IOException {
    private final String currentPeerId;
    private final String leaderPeerId;
    private static final Pattern CURRENT_PEER_ID_PATTERN = Pattern.compile("OM:(.*) is not the leader[.]+.*", 32);
    private static final Pattern SUGGESTED_LEADER_PATTERN = Pattern.compile(".*Suggested leader is OM:([^.]*).*", 32);

    public OMNotLeaderException(RaftPeerId currentPeerId) {
        super("OM:" + currentPeerId + " is not the leader. Could not determine the leader node.");
        this.currentPeerId = currentPeerId.toString();
        this.leaderPeerId = null;
    }

    public OMNotLeaderException(RaftPeerId currentPeerId, RaftPeerId suggestedLeaderPeerId) {
        super("OM:" + currentPeerId + " is not the leader. Suggested leader is OM:" + suggestedLeaderPeerId + ".");
        this.currentPeerId = currentPeerId.toString();
        this.leaderPeerId = suggestedLeaderPeerId.toString();
    }

    public OMNotLeaderException(String message) {
        super(message);
        Matcher currentLeaderMatcher = CURRENT_PEER_ID_PATTERN.matcher(message);
        if (currentLeaderMatcher.matches()) {
            this.currentPeerId = currentLeaderMatcher.group(1);
            Matcher suggestedLeaderMatcher = SUGGESTED_LEADER_PATTERN.matcher(message);
            this.leaderPeerId = suggestedLeaderMatcher.matches() ? suggestedLeaderMatcher.group(1) : null;
        } else {
            this.currentPeerId = null;
            this.leaderPeerId = null;
        }
    }

    public String getSuggestedLeaderNodeId() {
        return this.leaderPeerId;
    }

    public static OMNotLeaderException convertToOMNotLeaderException(NotLeaderException notLeaderException, RaftPeerId currentPeer) {
        RaftPeerId suggestedLeader = notLeaderException.getSuggestedLeader() != null ? notLeaderException.getSuggestedLeader().getId() : null;
        OMNotLeaderException omNotLeaderException = suggestedLeader != null ? new OMNotLeaderException(currentPeer, suggestedLeader) : new OMNotLeaderException(currentPeer);
        return omNotLeaderException;
    }
}

