/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.security.UserGroupInformation;

public class OmOzoneAclMap {
    private ArrayList<Map<String, BitSet>> accessAclMap;
    private List<OzoneManagerProtocolProtos.OzoneAclInfo> defaultAclList;

    OmOzoneAclMap() {
        this.accessAclMap = new ArrayList();
        this.defaultAclList = new ArrayList<OzoneManagerProtocolProtos.OzoneAclInfo>();
        for (OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType aclType : OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.values()) {
            this.accessAclMap.add(aclType.ordinal(), new HashMap());
        }
    }

    OmOzoneAclMap(List<OzoneManagerProtocolProtos.OzoneAclInfo> defaultAclList, ArrayList<Map<String, BitSet>> accessAclMap) {
        this.defaultAclList = defaultAclList;
        this.accessAclMap = accessAclMap;
    }

    private Map<String, BitSet> getAccessAclMap(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType type) {
        return this.accessAclMap.get(type.ordinal());
    }

    private BitSet getAcl(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType type, String user) {
        return this.getAccessAclMap(type).get(user);
    }

    public List<OzoneAcl> getAcl() {
        ArrayList<OzoneAcl> acls = new ArrayList<OzoneAcl>();
        acls.addAll(this.getAccessAcls());
        acls.addAll(this.defaultAclList.stream().map(a -> OzoneAcl.fromProtobuf(a)).collect(Collectors.toList()));
        return acls;
    }

    private Collection<? extends OzoneAcl> getAccessAcls() {
        ArrayList acls = new ArrayList();
        for (OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType type : OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.values()) {
            this.accessAclMap.get(type.ordinal()).entrySet().stream().forEach(entry -> acls.add(new OzoneAcl(IAccessAuthorizer.ACLIdentityType.valueOf(type.name()), (String)entry.getKey(), (BitSet)entry.getValue(), OzoneAcl.AclScope.ACCESS)));
        }
        return acls;
    }

    public void addAcl(OzoneAcl acl) throws OMException {
        Objects.requireNonNull(acl, "Acl should not be null.");
        if (acl.getAclScope().equals((Object)OzoneAcl.AclScope.DEFAULT)) {
            this.defaultAclList.add(OzoneAcl.toProtobuf(acl));
            return;
        }
        OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType aclType = OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.valueOf((String)acl.getType().name());
        if (!this.getAccessAclMap(aclType).containsKey(acl.getName())) {
            this.getAccessAclMap(aclType).put(acl.getName(), acl.getAclBitSet());
        } else {
            BitSet temp = (BitSet)acl.getAclBitSet().clone();
            BitSet curRights = (BitSet)this.getAccessAclMap(aclType).get(acl.getName()).clone();
            temp.or(curRights);
            if (temp.equals(curRights)) {
                throw new OMException("Acl " + acl + " already exist.", OMException.ResultCodes.INVALID_REQUEST);
            }
            this.getAccessAclMap(aclType).replace(acl.getName(), temp);
        }
    }

    public void setAcls(List<OzoneAcl> acls) throws OMException {
        Objects.requireNonNull(acls, "Acls should not be null.");
        for (OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType type : OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.values()) {
            this.accessAclMap.get(type.ordinal()).clear();
        }
        for (OzoneAcl acl : acls) {
            this.addAcl(acl);
        }
    }

    public void removeAcl(OzoneAcl acl) throws OMException {
        Objects.requireNonNull(acl, "Acl should not be null.");
        if (acl.getAclScope().equals((Object)OzoneAcl.AclScope.DEFAULT)) {
            this.defaultAclList.remove(OzoneAcl.toProtobuf(acl));
            return;
        }
        OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType aclType = OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.valueOf((String)acl.getType().name());
        if (this.getAccessAclMap(aclType).containsKey(acl.getName())) {
            BitSet aclRights = this.getAccessAclMap(aclType).get(acl.getName());
            BitSet bits = (BitSet)acl.getAclBitSet().clone();
            bits.and(aclRights);
            if (bits.equals(OzoneAcl.ZERO_BITSET)) {
                throw new OMException("Acl [" + acl + "] doesn't exist.", OMException.ResultCodes.INVALID_REQUEST);
            }
            acl.getAclBitSet().and(aclRights);
            aclRights.xor(acl.getAclBitSet());
            if (aclRights.equals(OzoneAcl.ZERO_BITSET)) {
                this.getAccessAclMap(aclType).remove(acl.getName());
            }
        } else {
            throw new OMException("Acl [" + acl + "] doesn't exist.", OMException.ResultCodes.INVALID_REQUEST);
        }
    }

    public void addAcl(OzoneManagerProtocolProtos.OzoneAclInfo acl) throws OMException {
        Objects.requireNonNull(acl, "Acl should not be null.");
        if (acl.getAclScope().equals((Object)OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclScope.DEFAULT)) {
            this.defaultAclList.add(acl);
            return;
        }
        if (this.getAccessAclMap(acl.getType()).containsKey(acl.getName())) {
            throw new OMException("Acl " + acl + " already exist.", OMException.ResultCodes.INVALID_REQUEST);
        }
        BitSet acls = BitSet.valueOf(acl.getRights().toByteArray());
        this.getAccessAclMap(acl.getType()).put(acl.getName(), acls);
    }

    public boolean hasAccess(OzoneManagerProtocolProtos.OzoneAclInfo acl) {
        if (acl == null) {
            return false;
        }
        BitSet aclBitSet = this.getAcl(acl.getType(), acl.getName());
        if (aclBitSet == null) {
            return false;
        }
        BitSet result = BitSet.valueOf(acl.getRights().toByteArray());
        result.and(aclBitSet);
        return (!result.equals(OzoneAcl.ZERO_BITSET) || aclBitSet.get(IAccessAuthorizer.ACLType.ALL.ordinal())) && !aclBitSet.get(IAccessAuthorizer.ACLType.NONE.ordinal());
    }

    public boolean hasAccess(IAccessAuthorizer.ACLType acl, UserGroupInformation ugi) {
        if (acl == null) {
            return false;
        }
        if (ugi == null) {
            return false;
        }
        return this.checkAccessForOzoneAclType(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.USER, acl, ugi) || this.checkAccessForOzoneAclType(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.GROUP, acl, ugi) || this.checkAccessForOzoneAclType(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.WORLD, acl, ugi) || this.checkAccessForOzoneAclType(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.ANONYMOUS, acl, ugi);
    }

    private boolean checkAccessForOzoneAclType(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType identityType, IAccessAuthorizer.ACLType acl, UserGroupInformation ugi) {
        switch (identityType) {
            case USER: {
                return OzoneAclUtil.checkIfAclBitIsSet(acl, this.getAcl(identityType, ugi.getUserName()));
            }
            case GROUP: {
                for (String userGroup : ugi.getGroupNames()) {
                    if (!OzoneAclUtil.checkIfAclBitIsSet(acl, this.getAcl(identityType, userGroup))) continue;
                    return true;
                }
                break;
            }
            default: {
                if (!OzoneAclUtil.checkIfAclBitIsSet(acl, this.getAcl(identityType, identityType.name()))) break;
                return true;
            }
        }
        return false;
    }

    public List<OzoneManagerProtocolProtos.OzoneAclInfo> ozoneAclGetProtobuf() {
        LinkedList<OzoneManagerProtocolProtos.OzoneAclInfo> aclList = new LinkedList<OzoneManagerProtocolProtos.OzoneAclInfo>();
        for (OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType type : OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.values()) {
            for (Map.Entry<String, BitSet> entry : this.accessAclMap.get(type.ordinal()).entrySet()) {
                OzoneManagerProtocolProtos.OzoneAclInfo.Builder builder = OzoneManagerProtocolProtos.OzoneAclInfo.newBuilder().setName(entry.getKey()).setType(type).setAclScope(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclScope.ACCESS).setRights(ByteString.copyFrom((byte[])entry.getValue().toByteArray()));
                aclList.add(builder.build());
            }
        }
        aclList.addAll(this.defaultAclList);
        return aclList;
    }

    public static OmOzoneAclMap ozoneAclGetFromProtobuf(List<OzoneManagerProtocolProtos.OzoneAclInfo> aclList) throws OMException {
        OmOzoneAclMap aclMap = new OmOzoneAclMap();
        for (OzoneManagerProtocolProtos.OzoneAclInfo acl : aclList) {
            aclMap.addAcl(acl);
        }
        return aclMap;
    }

    public Collection<? extends OzoneAcl> getAclsByScope(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclScope scope) {
        if (scope.equals((Object)OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclScope.DEFAULT)) {
            return this.defaultAclList.stream().map(a -> OzoneAcl.fromProtobuf(a)).collect(Collectors.toList());
        }
        return this.getAcl();
    }

    public List<OzoneManagerProtocolProtos.OzoneAclInfo> getDefaultAclList() {
        return this.defaultAclList;
    }

    public OmOzoneAclMap copyObject() {
        ArrayList<Map<String, BitSet>> accessMap = new ArrayList<Map<String, BitSet>>();
        for (OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType aclType : OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.values()) {
            accessMap.add(aclType.ordinal(), new HashMap());
        }
        for (OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType aclType : OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.values()) {
            int ordinal = aclType.ordinal();
            this.accessAclMap.get(ordinal).forEach((k, v) -> ((Map)accessMap.get(ordinal)).put(k, (BitSet)v.clone()));
        }
        ArrayList<OzoneManagerProtocolProtos.OzoneAclInfo> defaultList = new ArrayList<OzoneManagerProtocolProtos.OzoneAclInfo>();
        defaultList.addAll(this.defaultAclList);
        return new OmOzoneAclMap(defaultList, accessMap);
    }
}

