/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.OmOzoneAclMap;
import org.apache.hadoop.ozone.om.helpers.WithObjectID;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class OmVolumeArgs
extends WithObjectID
implements Auditable {
    private final String adminName;
    private String ownerName;
    private final String volume;
    private long creationTime;
    private long modificationTime;
    private long quotaInBytes;
    private final OmOzoneAclMap aclMap;

    private OmVolumeArgs(String adminName, String ownerName, String volume, long quotaInBytes, Map<String, String> metadata, OmOzoneAclMap aclMap, long creationTime, long modificationTime, long objectID, long updateID) {
        this.adminName = adminName;
        this.ownerName = ownerName;
        this.volume = volume;
        this.quotaInBytes = quotaInBytes;
        this.metadata = metadata;
        this.aclMap = aclMap;
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
        this.objectID = objectID;
        this.updateID = updateID;
    }

    public void setOwnerName(String newOwner) {
        this.ownerName = newOwner;
    }

    public void setQuotaInBytes(long quotaInBytes) {
        this.quotaInBytes = quotaInBytes;
    }

    public void setCreationTime(long time) {
        this.creationTime = time;
    }

    public void setModificationTime(long time) {
        this.modificationTime = time;
    }

    public void addAcl(OzoneAcl acl) throws OMException {
        this.aclMap.addAcl(acl);
    }

    public void setAcls(List<OzoneAcl> acls) throws OMException {
        this.aclMap.setAcls(acls);
    }

    public void removeAcl(OzoneAcl acl) throws OMException {
        this.aclMap.removeAcl(acl);
    }

    public String getAdminName() {
        return this.adminName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getVolume() {
        return this.volume;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public OmOzoneAclMap getAclMap() {
        return this.aclMap;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("admin", this.adminName);
        auditMap.put("owner", this.ownerName);
        auditMap.put("volume", this.volume);
        auditMap.put("creationTime", String.valueOf(this.creationTime));
        auditMap.put("modificationTime", String.valueOf(this.modificationTime));
        auditMap.put("quotaInBytes", String.valueOf(this.quotaInBytes));
        auditMap.put("objectID", String.valueOf(this.getObjectID()));
        auditMap.put("updateID", String.valueOf(this.getUpdateID()));
        return auditMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OmVolumeArgs that = (OmVolumeArgs)o;
        return Objects.equals(this.objectID, that.objectID);
    }

    public int hashCode() {
        return Objects.hash(this.objectID);
    }

    public OzoneManagerProtocolProtos.VolumeInfo getProtobuf() {
        List<OzoneManagerProtocolProtos.OzoneAclInfo> aclList = this.aclMap.ozoneAclGetProtobuf();
        return OzoneManagerProtocolProtos.VolumeInfo.newBuilder().setAdminName(this.adminName).setOwnerName(this.ownerName).setVolume(this.volume).setQuotaInBytes(this.quotaInBytes).addAllMetadata(KeyValueUtil.toProtobuf(this.metadata)).addAllVolumeAcls(aclList).setCreationTime(this.creationTime == 0L ? System.currentTimeMillis() : this.creationTime).setModificationTime(this.modificationTime).setObjectID(this.objectID).setUpdateID(this.updateID).build();
    }

    public static OmVolumeArgs getFromProtobuf(OzoneManagerProtocolProtos.VolumeInfo volInfo) throws OMException {
        OmOzoneAclMap aclMap = OmOzoneAclMap.ozoneAclGetFromProtobuf(volInfo.getVolumeAclsList());
        return new OmVolumeArgs(volInfo.getAdminName(), volInfo.getOwnerName(), volInfo.getVolume(), volInfo.getQuotaInBytes(), KeyValueUtil.getFromProtobuf(volInfo.getMetadataList()), aclMap, volInfo.getCreationTime(), volInfo.getModificationTime(), volInfo.getObjectID(), volInfo.getUpdateID());
    }

    @Override
    public String getObjectInfo() {
        return "OMVolumeArgs{volume='" + this.volume + '\'' + ", admin='" + this.adminName + '\'' + ", owner='" + this.ownerName + '\'' + ", creationTime='" + this.creationTime + '\'' + ", quota='" + this.quotaInBytes + '\'' + '}';
    }

    public OmVolumeArgs copyObject() {
        HashMap<String, String> cloneMetadata = new HashMap<String, String>();
        if (this.metadata != null) {
            this.metadata.forEach((k, v) -> cloneMetadata.put((String)k, (String)v));
        }
        OmOzoneAclMap cloneAclMap = this.aclMap.copyObject();
        return new OmVolumeArgs(this.adminName, this.ownerName, this.volume, this.quotaInBytes, cloneMetadata, cloneAclMap, this.creationTime, this.modificationTime, this.objectID, this.updateID);
    }

    public static class Builder {
        private String adminName;
        private String ownerName;
        private String volume;
        private long creationTime;
        private long modificationTime;
        private long quotaInBytes;
        private Map<String, String> metadata = new HashMap<String, String>();
        private OmOzoneAclMap aclMap = new OmOzoneAclMap();
        private long objectID;
        private long updateID;

        public Builder setObjectID(long id) {
            this.objectID = id;
            return this;
        }

        public Builder setUpdateID(long id) {
            this.updateID = id;
            return this;
        }

        public Builder setAdminName(String admin) {
            this.adminName = admin;
            return this;
        }

        public Builder setOwnerName(String owner) {
            this.ownerName = owner;
            return this;
        }

        public Builder setVolume(String volumeName) {
            this.volume = volumeName;
            return this;
        }

        public Builder setCreationTime(long createdOn) {
            this.creationTime = createdOn;
            return this;
        }

        public Builder setModificationTime(long modifiedOn) {
            this.modificationTime = modifiedOn;
            return this;
        }

        public Builder setQuotaInBytes(long quota) {
            this.quotaInBytes = quota;
            return this;
        }

        public Builder addMetadata(String key, String value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder addAllMetadata(Map<String, String> additionalMetaData) {
            if (additionalMetaData != null) {
                this.metadata.putAll(additionalMetaData);
            }
            return this;
        }

        public Builder addOzoneAcls(OzoneManagerProtocolProtos.OzoneAclInfo acl) throws IOException {
            this.aclMap.addAcl(acl);
            return this;
        }

        public OmVolumeArgs build() {
            Preconditions.checkNotNull((Object)this.adminName);
            Preconditions.checkNotNull((Object)this.ownerName);
            Preconditions.checkNotNull((Object)this.volume);
            return new OmVolumeArgs(this.adminName, this.ownerName, this.volume, this.quotaInBytes, this.metadata, this.aclMap, this.creationTime, this.modificationTime, this.objectID, this.updateID);
        }
    }
}

