/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.protocolPB;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.FailoverProxyProvider;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.ipc.ProtobufHelper;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.ozone.om.exceptions.OMLeaderNotReadyException;
import org.apache.hadoop.ozone.om.exceptions.OMNotLeaderException;
import org.apache.hadoop.ozone.om.ha.OMFailoverProxyProvider;
import org.apache.hadoop.ozone.om.protocolPB.OmTransport;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hadoop3OmTransport
implements OmTransport {
    private static final RpcController NULL_RPC_CONTROLLER = null;
    private static final Logger LOG = LoggerFactory.getLogger(Hadoop3OmTransport.class);
    private final OMFailoverProxyProvider omFailoverProxyProvider;
    private final OzoneManagerProtocolPB rpcProxy;
    private List<String> retryExceptions = new ArrayList<String>();

    public Hadoop3OmTransport(ConfigurationSource conf, UserGroupInformation ugi, String omServiceId) throws IOException {
        RPC.setProtocolEngine((Configuration)OzoneConfiguration.of((ConfigurationSource)conf), OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        this.omFailoverProxyProvider = new OMFailoverProxyProvider(conf, ugi, omServiceId);
        int maxFailovers = conf.getInt("ozone.client.failover.max.attempts", 15);
        this.rpcProxy = this.createRetryProxy(this.omFailoverProxyProvider, maxFailovers);
    }

    @Override
    public OzoneManagerProtocolProtos.OMResponse submitRequest(OzoneManagerProtocolProtos.OMRequest payload) throws IOException {
        try {
            OzoneManagerProtocolProtos.OMResponse omResponse = this.rpcProxy.submitRequest(NULL_RPC_CONTROLLER, payload);
            if (omResponse.hasLeaderOMNodeId() && this.omFailoverProxyProvider != null) {
                String leaderOmId = omResponse.getLeaderOMNodeId();
                this.omFailoverProxyProvider.performFailoverIfRequired(leaderOmId);
            }
            return omResponse;
        }
        catch (ServiceException e) {
            OMNotLeaderException notLeaderException = this.getNotLeaderException((Exception)((Object)e));
            if (notLeaderException == null) {
                throw ProtobufHelper.getRemoteException((ServiceException)e);
            }
            throw new IOException("Could not determine or connect to OM Leader.");
        }
    }

    @Override
    public Text getDelegationTokenService() {
        return this.omFailoverProxyProvider.getCurrentProxyDelegationToken();
    }

    private OzoneManagerProtocolPB createRetryProxy(OMFailoverProxyProvider failoverProxyProvider, final int maxFailovers) {
        RetryPolicy retryPolicy = new RetryPolicy(){

            public RetryPolicy.RetryAction shouldRetry(Exception exception, int retries, int failovers, boolean isIdempotentOrAtMostOnce) throws Exception {
                if (Hadoop3OmTransport.this.isAccessControlException(exception)) {
                    return RetryPolicy.RetryAction.FAIL;
                }
                if (exception instanceof ServiceException) {
                    OMNotLeaderException notLeaderException = Hadoop3OmTransport.this.getNotLeaderException(exception);
                    if (notLeaderException != null) {
                        Hadoop3OmTransport.this.retryExceptions.add(Hadoop3OmTransport.this.getExceptionMsg(notLeaderException, failovers));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("RetryProxy: {}", (Object)notLeaderException.getMessage());
                        }
                        Hadoop3OmTransport.this.omFailoverProxyProvider.performFailoverToNextProxy();
                        return this.getRetryAction(RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY, failovers);
                    }
                    OMLeaderNotReadyException leaderNotReadyException = Hadoop3OmTransport.this.getLeaderNotReadyException(exception);
                    if (leaderNotReadyException != null) {
                        Hadoop3OmTransport.this.retryExceptions.add(Hadoop3OmTransport.this.getExceptionMsg(leaderNotReadyException, failovers));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("RetryProxy: {}", (Object)leaderNotReadyException.getMessage());
                        }
                        Hadoop3OmTransport.this.omFailoverProxyProvider.performFailoverIfRequired(Hadoop3OmTransport.this.omFailoverProxyProvider.getCurrentProxyOMNodeId());
                        return this.getRetryAction(RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY, failovers);
                    }
                }
                Hadoop3OmTransport.this.retryExceptions.add(Hadoop3OmTransport.this.getExceptionMsg(exception, failovers));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RetryProxy: {}", (Object)(exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage()));
                }
                Hadoop3OmTransport.this.omFailoverProxyProvider.performFailoverToNextProxy();
                return this.getRetryAction(RetryPolicy.RetryAction.RetryDecision.FAILOVER_AND_RETRY, failovers);
            }

            private RetryPolicy.RetryAction getRetryAction(RetryPolicy.RetryAction.RetryDecision fallbackAction, int failovers) {
                if (failovers < maxFailovers) {
                    return new RetryPolicy.RetryAction(fallbackAction, Hadoop3OmTransport.this.omFailoverProxyProvider.getWaitTime());
                }
                StringBuilder allRetryExceptions = new StringBuilder();
                allRetryExceptions.append("\n");
                Hadoop3OmTransport.this.retryExceptions.stream().forEach(e -> allRetryExceptions.append((String)e));
                LOG.error("Failed to connect to OMs: {}. Attempted {} failovers. Got following exceptions during retries: {}", new Object[]{Hadoop3OmTransport.this.omFailoverProxyProvider.getOMProxyInfos(), maxFailovers, allRetryExceptions.toString()});
                Hadoop3OmTransport.this.retryExceptions.clear();
                return RetryPolicy.RetryAction.FAIL;
            }
        };
        OzoneManagerProtocolPB proxy = (OzoneManagerProtocolPB)RetryProxy.create(OzoneManagerProtocolPB.class, (FailoverProxyProvider)failoverProxyProvider, (RetryPolicy)retryPolicy);
        return proxy;
    }

    private String getExceptionMsg(Exception e, int retryAttempt) {
        StringBuilder exceptionMsg = new StringBuilder().append("Retry Attempt ").append(retryAttempt).append(" Exception - ");
        if (e.getCause() == null) {
            exceptionMsg.append(e.getClass().getCanonicalName()).append(": ").append(e.getMessage());
        } else {
            exceptionMsg.append(e.getCause().getClass().getCanonicalName()).append(": ").append(e.getCause().getMessage());
        }
        return exceptionMsg.toString();
    }

    private OMLeaderNotReadyException getLeaderNotReadyException(Exception exception) {
        IOException ioException;
        Throwable cause = exception.getCause();
        if (cause instanceof RemoteException && (ioException = ((RemoteException)cause).unwrapRemoteException()) instanceof OMLeaderNotReadyException) {
            return (OMLeaderNotReadyException)ioException;
        }
        return null;
    }

    private boolean isAccessControlException(Exception ex) {
        if (ex instanceof ServiceException) {
            Throwable t = ex.getCause();
            if (t instanceof RemoteException) {
                t = ((RemoteException)t).unwrapRemoteException();
            }
            while (t != null) {
                if (t instanceof AccessControlException || t instanceof SecretManager.InvalidToken) {
                    return true;
                }
                t = t.getCause();
            }
        }
        return false;
    }

    private OMNotLeaderException getNotLeaderException(Exception exception) {
        IOException ioException;
        Throwable cause = exception.getCause();
        if (cause instanceof RemoteException && (ioException = ((RemoteException)cause).unwrapRemoteException()) instanceof OMNotLeaderException) {
            return (OMNotLeaderException)ioException;
        }
        return null;
    }

    @VisibleForTesting
    public OMFailoverProxyProvider getOmFailoverProxyProvider() {
        return this.omFailoverProxyProvider;
    }

    @Override
    public void close() throws IOException {
        this.omFailoverProxyProvider.close();
    }
}

