/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class OzoneTokenIdentifier
extends AbstractDelegationTokenIdentifier {
    public static final Text KIND_NAME = new Text("OzoneToken");
    private String omCertSerialId;
    private OzoneManagerProtocolProtos.OMTokenProto.Type tokenType = OzoneManagerProtocolProtos.OMTokenProto.Type.DELEGATION_TOKEN;
    private String awsAccessId;
    private String signature;
    private String strToSign;
    private String omServiceId;

    public OzoneTokenIdentifier() {
    }

    public OzoneTokenIdentifier(Text owner, Text renewer, Text realUser) {
        super(owner, renewer, realUser);
    }

    public Text getKind() {
        return KIND_NAME;
    }

    public byte[] toUniqueSerializedKey() {
        DataOutputBuffer buf = new DataOutputBuffer();
        try {
            super.write((DataOutput)buf);
            WritableUtils.writeVInt((DataOutput)buf, (int)this.getTokenType().getNumber());
            if (this.getTokenType().equals((Object)OzoneManagerProtocolProtos.OMTokenProto.Type.S3AUTHINFO)) {
                WritableUtils.writeString((DataOutput)buf, (String)this.getAwsAccessId());
                WritableUtils.writeString((DataOutput)buf, (String)this.getSignature());
                WritableUtils.writeString((DataOutput)buf, (String)this.getStrToSign());
            } else {
                WritableUtils.writeString((DataOutput)buf, (String)this.getOmCertSerialId());
                WritableUtils.writeString((DataOutput)buf, (String)this.getOmServiceId());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't encode the the raw data ", e);
        }
        return buf.getData();
    }

    public OzoneTokenIdentifier fromUniqueSerializedKey(byte[] rawData) throws IOException {
        DataInputBuffer in = new DataInputBuffer();
        in.reset(rawData, rawData.length);
        super.readFields((DataInput)in);
        int type = WritableUtils.readVInt((DataInput)in);
        if (type == OzoneManagerProtocolProtos.OMTokenProto.Type.S3AUTHINFO.getNumber()) {
            this.tokenType = OzoneManagerProtocolProtos.OMTokenProto.Type.S3AUTHINFO;
            this.setAwsAccessId(WritableUtils.readString((DataInput)in));
            this.setSignature(WritableUtils.readString((DataInput)in));
            this.setStrToSign(WritableUtils.readString((DataInput)in));
        } else {
            this.tokenType = OzoneManagerProtocolProtos.OMTokenProto.Type.DELEGATION_TOKEN;
            this.setOmCertSerialId(WritableUtils.readString((DataInput)in));
            this.setOmServiceId(WritableUtils.readString((DataInput)in));
        }
        return this;
    }

    public void write(DataOutput out) throws IOException {
        OzoneManagerProtocolProtos.OMTokenProto.Builder builder = OzoneManagerProtocolProtos.OMTokenProto.newBuilder().setMaxDate(this.getMaxDate()).setType(this.getTokenType()).setOwner(this.getOwner().toString()).setRealUser(this.getRealUser().toString()).setRenewer(this.getRenewer().toString()).setIssueDate(this.getIssueDate()).setSequenceNumber(this.getSequenceNumber()).setMasterKeyId(this.getMasterKeyId());
        if (this.getTokenType().equals((Object)OzoneManagerProtocolProtos.OMTokenProto.Type.S3AUTHINFO)) {
            builder.setAccessKeyId(this.getAwsAccessId()).setSignature(this.getSignature()).setStrToSign(this.getStrToSign());
        } else {
            builder.setOmCertSerialId(this.getOmCertSerialId());
            if (this.getOmServiceId() != null) {
                builder.setOmServiceId(this.getOmServiceId());
            }
        }
        OzoneManagerProtocolProtos.OMTokenProto token = builder.build();
        out.write(token.toByteArray());
    }

    public void readFields(DataInput in) throws IOException {
        OzoneManagerProtocolProtos.OMTokenProto token = OzoneManagerProtocolProtos.OMTokenProto.parseFrom((InputStream)((DataInputStream)in));
        this.setTokenType(token.getType());
        this.setMaxDate(token.getMaxDate());
        this.setOwner(new Text(token.getOwner()));
        this.setRealUser(new Text(token.getRealUser()));
        this.setRenewer(new Text(token.getRenewer()));
        this.setIssueDate(token.getIssueDate());
        this.setMaxDate(token.getMaxDate());
        this.setSequenceNumber(token.getSequenceNumber());
        this.setMasterKeyId(token.getMasterKeyId());
        this.setOmCertSerialId(token.getOmCertSerialId());
        if (this.getTokenType().equals((Object)OzoneManagerProtocolProtos.OMTokenProto.Type.S3AUTHINFO)) {
            this.setAwsAccessId(token.getAccessKeyId());
            this.setSignature(token.getSignature());
            this.setStrToSign(token.getStrToSign());
        }
        if (token.hasOmServiceId()) {
            this.setOmServiceId(token.getOmServiceId());
        }
    }

    public static OzoneTokenIdentifier readProtoBuf(DataInput in) throws IOException {
        OzoneManagerProtocolProtos.OMTokenProto token = OzoneManagerProtocolProtos.OMTokenProto.parseFrom((InputStream)((DataInputStream)in));
        OzoneTokenIdentifier identifier = new OzoneTokenIdentifier();
        identifier.setTokenType(token.getType());
        identifier.setMaxDate(token.getMaxDate());
        if (token.getType().equals((Object)OzoneManagerProtocolProtos.OMTokenProto.Type.S3AUTHINFO)) {
            identifier.setSignature(token.getSignature());
            identifier.setStrToSign(token.getStrToSign());
            identifier.setAwsAccessId(token.getAccessKeyId());
        } else {
            identifier.setRenewer(new Text(token.getRenewer()));
            identifier.setOwner(new Text(token.getOwner()));
            identifier.setRealUser(new Text(token.getRealUser()));
            identifier.setIssueDate(token.getIssueDate());
            identifier.setSequenceNumber(token.getSequenceNumber());
            identifier.setMasterKeyId(token.getMasterKeyId());
        }
        identifier.setOmCertSerialId(token.getOmCertSerialId());
        identifier.setOmServiceId(token.getOmServiceId());
        return identifier;
    }

    public static OzoneTokenIdentifier readProtoBuf(byte[] identifier) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(identifier));
        return OzoneTokenIdentifier.readProtoBuf(in);
    }

    public static OzoneTokenIdentifier newInstance() {
        return new OzoneTokenIdentifier();
    }

    public static OzoneTokenIdentifier newInstance(Text owner, Text renewer, Text realUser) {
        return new OzoneTokenIdentifier(owner, renewer, realUser);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OzoneTokenIdentifier)) {
            return false;
        }
        OzoneTokenIdentifier that = (OzoneTokenIdentifier)((Object)obj);
        return new EqualsBuilder().append((Object)this.getOmCertSerialId(), (Object)that.getOmCertSerialId()).append(this.getMaxDate(), that.getMaxDate()).append(this.getIssueDate(), that.getIssueDate()).append(this.getMasterKeyId(), that.getMasterKeyId()).append((Object)this.getOwner(), (Object)that.getOwner()).append((Object)this.getRealUser(), (Object)that.getRealUser()).append((Object)this.getRenewer(), (Object)that.getRenewer()).append((Object)this.getKind(), (Object)that.getKind()).append(this.getSequenceNumber(), that.getSequenceNumber()).append((Object)this.getOmServiceId(), (Object)that.getOmServiceId()).build();
    }

    public String getOmCertSerialId() {
        return this.omCertSerialId;
    }

    public void setOmCertSerialId(String omCertSerialId) {
        this.omCertSerialId = omCertSerialId;
    }

    public String getOmServiceId() {
        return this.omServiceId;
    }

    public void setOmServiceId(String omServiceId) {
        this.omServiceId = omServiceId;
    }

    public OzoneManagerProtocolProtos.OMTokenProto.Type getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(OzoneManagerProtocolProtos.OMTokenProto.Type tokenType) {
        this.tokenType = tokenType;
    }

    public String getAwsAccessId() {
        return this.awsAccessId;
    }

    public void setAwsAccessId(String awsAccessId) {
        this.awsAccessId = awsAccessId;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getStrToSign() {
        return this.strToSign;
    }

    public void setStrToSign(String strToSign) {
        this.strToSign = strToSign;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getKind()).append(" owner=").append(this.getOwner()).append(", renewer=").append(this.getRenewer()).append(", realUser=").append(this.getRealUser()).append(", issueDate=").append(this.getIssueDate()).append(", maxDate=").append(this.getMaxDate()).append(", sequenceNumber=").append(this.getSequenceNumber()).append(", masterKeyId=").append(this.getMasterKeyId()).append(", strToSign=").append(this.getStrToSign()).append(", signature=").append(this.getSignature()).append(", awsAccessKeyId=").append(this.getAwsAccessId()).append(", omServiceId=").append(this.getOmServiceId());
        return buffer.toString();
    }

    @InterfaceStability.Evolving
    public static class TokenInfo {
        private long renewDate;
        private byte[] password;
        private String trackingId;

        public TokenInfo(long renewDate, byte[] password) {
            this(renewDate, password, null);
        }

        public TokenInfo(long renewDate, byte[] password, String trackingId) {
            this.renewDate = renewDate;
            this.password = Arrays.copyOf(password, password.length);
            this.trackingId = trackingId;
        }

        public long getRenewDate() {
            return this.renewDate;
        }

        byte[] getPassword() {
            return this.password;
        }

        public String getTrackingId() {
            return this.trackingId;
        }
    }
}

