/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OmKeyLocationInfoGroup {
    private final long version;
    private final Map<Long, List<OmKeyLocationInfo>> locationVersionMap;
    private boolean isMultipartKey;

    public OmKeyLocationInfoGroup(long version, List<OmKeyLocationInfo> locations) {
        this(version, locations, false);
    }

    public OmKeyLocationInfoGroup(long version, List<OmKeyLocationInfo> locations, boolean isMultipartKey) {
        this.version = version;
        this.locationVersionMap = new HashMap<Long, List<OmKeyLocationInfo>>();
        for (OmKeyLocationInfo info : locations) {
            this.locationVersionMap.computeIfAbsent(info.getCreateVersion(), v -> new ArrayList()).add(info);
        }
        this.locationVersionMap.putIfAbsent(version, new ArrayList());
        this.isMultipartKey = isMultipartKey;
    }

    public OmKeyLocationInfoGroup(long version, Map<Long, List<OmKeyLocationInfo>> locations) {
        this(version, locations, false);
    }

    public OmKeyLocationInfoGroup(long version, Map<Long, List<OmKeyLocationInfo>> locations, boolean isMultipartKey) {
        this.version = version;
        this.locationVersionMap = locations;
        this.locationVersionMap.putIfAbsent(version, new ArrayList());
        this.isMultipartKey = isMultipartKey;
    }

    public void setMultipartKey(boolean isMpu) {
        this.isMultipartKey = isMpu;
    }

    public boolean isMultipartKey() {
        return this.isMultipartKey;
    }

    public List<OmKeyLocationInfo> getBlocksLatestVersionOnly() {
        return new ArrayList<OmKeyLocationInfo>((Collection)this.locationVersionMap.get(this.version));
    }

    public long getVersion() {
        return this.version;
    }

    public List<OmKeyLocationInfo> getLocationList() {
        return this.locationVersionMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public long getLocationListCount() {
        return this.locationVersionMap.values().stream().mapToLong(List::size).sum();
    }

    public List<OmKeyLocationInfo> getLocationList(Long versionToFetch) {
        return new ArrayList<OmKeyLocationInfo>((Collection)this.locationVersionMap.get(versionToFetch));
    }

    public OzoneManagerProtocolProtos.KeyLocationList getProtobuf(boolean ignorePipeline, int clientVersion) {
        OzoneManagerProtocolProtos.KeyLocationList.Builder builder = OzoneManagerProtocolProtos.KeyLocationList.newBuilder().setVersion(this.version).setIsMultipartKey(this.isMultipartKey);
        ArrayList<OzoneManagerProtocolProtos.KeyLocation> keyLocationList = new ArrayList<OzoneManagerProtocolProtos.KeyLocation>();
        for (List<OmKeyLocationInfo> locationList : this.locationVersionMap.values()) {
            for (OmKeyLocationInfo keyInfo : locationList) {
                keyLocationList.add(keyInfo.getProtobuf(ignorePipeline, clientVersion));
            }
        }
        return builder.addAllKeyLocations(keyLocationList).build();
    }

    public static OmKeyLocationInfoGroup getFromProtobuf(OzoneManagerProtocolProtos.KeyLocationList keyLocationList) {
        return new OmKeyLocationInfoGroup(keyLocationList.getVersion(), keyLocationList.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.groupingBy(OmKeyLocationInfo::getCreateVersion)), keyLocationList.getIsMultipartKey());
    }

    OmKeyLocationInfoGroup generateNextVersion(List<OmKeyLocationInfo> newLocationList) {
        HashMap<Long, List<OmKeyLocationInfo>> newMap = new HashMap<Long, List<OmKeyLocationInfo>>(this.locationVersionMap);
        newMap.put(this.version + 1L, new ArrayList<OmKeyLocationInfo>(newLocationList));
        return new OmKeyLocationInfoGroup(this.version + 1L, newMap);
    }

    void appendNewBlocks(List<OmKeyLocationInfo> newLocationList) {
        List<OmKeyLocationInfo> locationList = this.locationVersionMap.get(this.version);
        for (OmKeyLocationInfo info : newLocationList) {
            info.setCreateVersion(this.version);
            locationList.add(info);
        }
    }

    void removeBlocks(long versionToRemove) {
        this.locationVersionMap.remove(versionToRemove);
    }

    void addAll(long versionToAdd, List<OmKeyLocationInfo> locationInfoList) {
        this.locationVersionMap.putIfAbsent(versionToAdd, new ArrayList());
        List<OmKeyLocationInfo> list = this.locationVersionMap.get(versionToAdd);
        list.addAll(locationInfoList);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("version:").append(this.version).append(" ");
        sb.append("isMultipartKey:").append(this.isMultipartKey);
        for (List<OmKeyLocationInfo> kliList : this.locationVersionMap.values()) {
            for (OmKeyLocationInfo kli : kliList) {
                sb.append(kli.getLocalID()).append(" || ");
            }
        }
        return sb.toString();
    }
}

