/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import java.util.Objects;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public class OzoneFileStatus {
    private static final long serialVersionUID = 1L;
    private OmKeyInfo keyInfo;
    private boolean isDirectory;
    private long blockSize;

    public OzoneFileStatus() {
        this.isDirectory = true;
    }

    public OzoneFileStatus(OmKeyInfo keyInfo, long blockSize, boolean isDirectory) {
        this.keyInfo = keyInfo;
        this.isDirectory = isDirectory;
        this.blockSize = blockSize;
    }

    public OmKeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public String getTrimmedName() {
        String keyName = this.keyInfo.getKeyName();
        if (keyName.endsWith("/")) {
            return keyName.substring(0, keyName.length() - 1);
        }
        return keyName;
    }

    public String getPath() {
        if (this.keyInfo == null) {
            return "/";
        }
        String path = "/" + this.keyInfo.getKeyName();
        if (path.endsWith("/")) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public boolean isDirectory() {
        if (this.keyInfo == null) {
            return true;
        }
        return this.isDirectory;
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public OzoneManagerProtocolProtos.OzoneFileStatusProto getProtobuf(int clientVersion) {
        OzoneManagerProtocolProtos.OzoneFileStatusProto.Builder builder = OzoneManagerProtocolProtos.OzoneFileStatusProto.newBuilder().setBlockSize(this.blockSize).setIsDirectory(this.isDirectory);
        if (this.keyInfo != null) {
            builder.setKeyInfo(this.keyInfo.getProtobuf(clientVersion));
        }
        return builder.build();
    }

    public static OzoneFileStatus getFromProtobuf(OzoneManagerProtocolProtos.OzoneFileStatusProto status) {
        return new OzoneFileStatus(OmKeyInfo.getFromProtobuf(status.getKeyInfo()), status.getBlockSize(), status.getIsDirectory());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OzoneFileStatus)) {
            return false;
        }
        OzoneFileStatus that = (OzoneFileStatus)o;
        return this.isDirectory == that.isDirectory && this.blockSize == that.blockSize && this.getTrimmedName().equals(that.getTrimmedName());
    }

    public int hashCode() {
        return Objects.hash(this.getTrimmedName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{");
        if (this.keyInfo == null) {
            sb.append("<root>");
        } else {
            sb.append(this.getTrimmedName());
            if (this.isDirectory) {
                sb.append(" (dir)");
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

