/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerWithPipeline;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.om.KeyDeletingService;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.ScmClient;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmPartInfo;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.OzoneBlockTokenSecretManager;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.BackgroundService;
import org.apache.hadoop.utils.db.BatchOperation;
import org.apache.hadoop.utils.db.DBStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyManagerImpl
implements KeyManager {
    private static final Logger LOG = LoggerFactory.getLogger(KeyManagerImpl.class);
    private final ScmClient scmClient;
    private final OMMetadataManager metadataManager;
    private final long scmBlockSize;
    private final boolean useRatis;
    private final int preallocateBlocksMax;
    private final String omId;
    private final OzoneBlockTokenSecretManager secretManager;
    private final boolean grpcBlockTokenEnabled;
    private BackgroundService keyDeletingService;
    private final KeyProviderCryptoExtension kmsProvider;

    public KeyManagerImpl(ScmBlockLocationProtocol scmBlockClient, OMMetadataManager metadataManager, OzoneConfiguration conf, String omId, OzoneBlockTokenSecretManager secretManager) {
        this(new ScmClient(scmBlockClient, null), metadataManager, conf, omId, secretManager, null);
    }

    public KeyManagerImpl(ScmClient scmClient, OMMetadataManager metadataManager, OzoneConfiguration conf, String omId, OzoneBlockTokenSecretManager secretManager, KeyProviderCryptoExtension kmsProvider) {
        this.scmClient = scmClient;
        this.metadataManager = metadataManager;
        this.scmBlockSize = (long)conf.getStorageSize("ozone.scm.block.size", "256MB", StorageUnit.BYTES);
        this.useRatis = conf.getBoolean("dfs.container.ratis.enabled", false);
        this.preallocateBlocksMax = conf.getInt("ozone.key.preallocation.max.blocks", 64);
        this.omId = omId;
        this.start(conf);
        this.secretManager = secretManager;
        this.grpcBlockTokenEnabled = conf.getBoolean("hdds.block.token.enabled", false);
        this.kmsProvider = kmsProvider;
    }

    @Override
    public void start(OzoneConfiguration configuration) {
        if (this.keyDeletingService == null) {
            long blockDeleteInterval = configuration.getTimeDuration("ozone.block.deleting.service.interval", "60s", TimeUnit.MILLISECONDS);
            long serviceTimeout = configuration.getTimeDuration("ozone.block.deleting.service.timeout", "300s", TimeUnit.MILLISECONDS);
            this.keyDeletingService = new KeyDeletingService(this.scmClient.getBlockClient(), this, blockDeleteInterval, serviceTimeout, (Configuration)configuration);
            this.keyDeletingService.start();
        }
    }

    KeyProviderCryptoExtension getKMSProvider() {
        return this.kmsProvider;
    }

    @Override
    public void stop() throws IOException {
        if (this.keyDeletingService != null) {
            this.keyDeletingService.shutdown();
            this.keyDeletingService = null;
        }
    }

    private OmBucketInfo getBucketInfo(String volumeName, String bucketName) throws IOException {
        String bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
        return (OmBucketInfo)this.metadataManager.getBucketTable().get((Object)bucketKey);
    }

    private void validateBucket(String volumeName, String bucketName) throws IOException {
        String volumeKey = this.metadataManager.getVolumeKey(volumeName);
        String bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
        if (this.metadataManager.getVolumeTable().get((Object)volumeKey) == null) {
            LOG.error("volume not found: {}", (Object)volumeName);
            throw new OMException("Volume not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        if (this.metadataManager.getBucketTable().get((Object)bucketKey) == null) {
            LOG.error("bucket not found: {}/{} ", (Object)volumeName, (Object)bucketName);
            throw new OMException("Bucket not found", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
    }

    private void validateS3Bucket(String volumeName, String bucketName) throws IOException {
        String bucketKey = this.metadataManager.getBucketKey(volumeName, bucketName);
        if (this.metadataManager.getBucketTable().get((Object)bucketKey) == null) {
            LOG.error("bucket not found: {}/{} ", (Object)volumeName, (Object)bucketName);
            throw new OMException("Bucket not found", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
    }

    @Override
    public OmKeyLocationInfo allocateBlock(OmKeyArgs args, long clientID, ExcludeList excludeList) throws IOException {
        Preconditions.checkNotNull((Object)args);
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        this.validateBucket(volumeName, bucketName);
        String openKey = this.metadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
        OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)openKey);
        if (keyInfo == null) {
            LOG.error("Allocate block for a key not in open status in meta store /{}/{}/{} with ID {}", new Object[]{volumeName, bucketName, keyName, clientID});
            throw new OMException("Open Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
        }
        List<OmKeyLocationInfo> locationInfos = this.allocateBlock(keyInfo, excludeList, this.scmBlockSize);
        keyInfo.appendNewBlocks(locationInfos);
        keyInfo.updateModifcationTime();
        this.metadataManager.getOpenKeyTable().put((Object)openKey, (Object)keyInfo);
        return locationInfos.get(0);
    }

    private List<OmKeyLocationInfo> allocateBlock(OmKeyInfo keyInfo, ExcludeList excludeList, long requestedSize) throws IOException {
        List allocatedBlocks;
        int numBlocks = Math.min((int)((requestedSize - 1L) / this.scmBlockSize + 1L), this.preallocateBlocksMax);
        ArrayList<OmKeyLocationInfo> locationInfos = new ArrayList<OmKeyLocationInfo>(numBlocks);
        String remoteUser = KeyManagerImpl.getRemoteUser().getShortUserName();
        try {
            allocatedBlocks = this.scmClient.getBlockClient().allocateBlock(this.scmBlockSize, numBlocks, keyInfo.getType(), keyInfo.getFactor(), this.omId, excludeList);
        }
        catch (SCMException ex) {
            if (ex.getResult().equals((Object)SCMException.ResultCodes.CHILL_MODE_EXCEPTION)) {
                throw new OMException(ex.getMessage(), OMException.ResultCodes.SCM_IN_CHILL_MODE);
            }
            throw ex;
        }
        for (AllocatedBlock allocatedBlock : allocatedBlocks) {
            OmKeyLocationInfo.Builder builder = new OmKeyLocationInfo.Builder().setBlockID(new BlockID(allocatedBlock.getBlockID())).setLength(this.scmBlockSize).setOffset(0L).setPipeline(allocatedBlock.getPipeline());
            if (this.grpcBlockTokenEnabled) {
                builder.setToken(this.secretManager.generateToken(remoteUser, allocatedBlock.getBlockID().toString(), this.getAclForUser(remoteUser), this.scmBlockSize));
            }
            locationInfos.add(builder.build());
        }
        return locationInfos;
    }

    public static UserGroupInformation getRemoteUser() throws IOException {
        UserGroupInformation ugi = Server.getRemoteUser();
        return ugi != null ? ugi : UserGroupInformation.getCurrentUser();
    }

    private EnumSet<HddsProtos.BlockTokenSecretProto.AccessModeProto> getAclForUser(String user) {
        return EnumSet.allOf(HddsProtos.BlockTokenSecretProto.AccessModeProto.class);
    }

    private KeyProviderCryptoExtension.EncryptedKeyVersion generateEDEK(final String ezKeyName) throws IOException {
        if (ezKeyName == null) {
            return null;
        }
        long generateEDEKStartTime = Time.monotonicNow();
        KeyProviderCryptoExtension.EncryptedKeyVersion edek = (KeyProviderCryptoExtension.EncryptedKeyVersion)SecurityUtil.doAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProviderCryptoExtension.EncryptedKeyVersion>(){

            @Override
            public KeyProviderCryptoExtension.EncryptedKeyVersion run() throws IOException {
                try {
                    return KeyManagerImpl.this.getKMSProvider().generateEncryptedKey(ezKeyName);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
        });
        long generateEDEKTime = Time.monotonicNow() - generateEDEKStartTime;
        LOG.debug("generateEDEK takes {} ms", (Object)generateEDEKTime);
        Preconditions.checkNotNull((Object)edek);
        return edek;
    }

    @Override
    public OpenKeySession openKey(OmKeyArgs args) throws IOException {
        String openKey;
        long openVersion;
        OmKeyInfo keyInfo;
        Preconditions.checkNotNull((Object)args);
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        this.validateBucket(volumeName, bucketName);
        this.metadataManager.getLock().acquireBucketLock(volumeName, bucketName);
        String keyName = args.getKeyName();
        HddsProtos.ReplicationFactor factor = args.getFactor();
        HddsProtos.ReplicationType type = args.getType();
        long currentTime = Time.monotonicNowNanos();
        FileEncryptionInfo encInfo = null;
        OmBucketInfo bucketInfo = this.getBucketInfo(volumeName, bucketName);
        BucketEncryptionKeyInfo ezInfo = bucketInfo.getEncryptionKeyInfo();
        if (ezInfo != null) {
            if (this.getKMSProvider() == null) {
                throw new OMException("Invalid KMS provider, check configuration hadoop.security.key.provider.path", OMException.ResultCodes.INVALID_KMS_PROVIDER);
            }
            String ezKeyName = ezInfo.getKeyName();
            KeyProviderCryptoExtension.EncryptedKeyVersion edek = this.generateEDEK(ezKeyName);
            encInfo = new FileEncryptionInfo(ezInfo.getSuite(), ezInfo.getVersion(), edek.getEncryptedKeyVersion().getMaterial(), edek.getEncryptedKeyIv(), ezKeyName, edek.getEncryptionKeyVersionName());
        }
        try {
            long size;
            if (args.getIsMultipartKey()) {
                Preconditions.checkArgument((args.getMultipartUploadPartNumber() > 0 ? 1 : 0) != 0, (Object)"PartNumber Should be greater than zero");
                String uploadID = args.getMultipartUploadID();
                Preconditions.checkNotNull((Object)uploadID);
                String multipartKey = this.metadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
                OmKeyInfo partKeyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)multipartKey);
                if (partKeyInfo == null) {
                    throw new OMException("No such Multipart upload is with specified uploadId " + uploadID, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
                }
                factor = partKeyInfo.getFactor();
                type = partKeyInfo.getType();
            } else {
                if (factor == null) {
                    HddsProtos.ReplicationFactor replicationFactor = factor = this.useRatis ? HddsProtos.ReplicationFactor.THREE : HddsProtos.ReplicationFactor.ONE;
                }
                if (type == null) {
                    type = this.useRatis ? HddsProtos.ReplicationType.RATIS : HddsProtos.ReplicationType.STAND_ALONE;
                }
            }
            ArrayList<OmKeyLocationInfo> locations = new ArrayList<OmKeyLocationInfo>();
            String objectKey = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
            long l = size = args.getDataSize() >= 0L ? args.getDataSize() : this.scmBlockSize;
            if (args.getIsMultipartKey()) {
                keyInfo = this.createKeyInfo(args, locations, factor, type, size, encInfo);
                openVersion = 0L;
            } else {
                keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)objectKey);
                if (keyInfo != null) {
                    openVersion = keyInfo.addNewVersion(locations);
                    keyInfo.setDataSize(size + keyInfo.getDataSize());
                } else {
                    keyInfo = this.createKeyInfo(args, locations, factor, type, size, encInfo);
                    openVersion = 0L;
                }
            }
            openKey = this.metadataManager.getOpenKey(volumeName, bucketName, keyName, currentTime);
            if (this.metadataManager.getOpenKeyTable().get((Object)openKey) != null) {
                LOG.warn("Cannot allocate key. The generated open key id is alreadyused for the same key which is currently being written.");
                throw new OMException("Cannot allocate key. Not able to get a validopen key id.", OMException.ResultCodes.KEY_ALLOCATION_ERROR);
            }
            LOG.debug("Key {} allocated in volume {} bucket {}", new Object[]{keyName, volumeName, bucketName});
        }
        catch (OMException e) {
            throw e;
        }
        catch (IOException ex) {
            LOG.error("Key open failed for volume:{} bucket:{} key:{}", new Object[]{volumeName, bucketName, keyName, ex});
            throw new OMException(ex.getMessage(), OMException.ResultCodes.KEY_ALLOCATION_ERROR);
        }
        finally {
            this.metadataManager.getLock().releaseBucketLock(volumeName, bucketName);
        }
        if (args.getDataSize() > 0L) {
            List<OmKeyLocationInfo> locationInfos = this.allocateBlock(keyInfo, new ExcludeList(), args.getDataSize());
            keyInfo.appendNewBlocks(locationInfos);
        }
        this.metadataManager.getOpenKeyTable().put((Object)openKey, (Object)keyInfo);
        return new OpenKeySession(currentTime, keyInfo, openVersion);
    }

    private OmKeyInfo createKeyInfo(OmKeyArgs keyArgs, List<OmKeyLocationInfo> locations, HddsProtos.ReplicationFactor factor, HddsProtos.ReplicationType type, long size, FileEncryptionInfo encInfo) {
        return new OmKeyInfo.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, locations))).setCreationTime(Time.now()).setModificationTime(Time.now()).setDataSize(size).setReplicationType(type).setReplicationFactor(factor).setFileEncryptionInfo(encInfo).build();
    }

    @Override
    public void commitKey(OmKeyArgs args, long clientID) throws IOException {
        Preconditions.checkNotNull((Object)args);
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        this.metadataManager.getLock().acquireBucketLock(volumeName, bucketName);
        try {
            this.validateBucket(volumeName, bucketName);
            String openKey = this.metadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
            String objectKey = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
            OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)openKey);
            if (keyInfo == null) {
                throw new OMException("Commit a key without corresponding entry " + objectKey, OMException.ResultCodes.KEY_NOT_FOUND);
            }
            keyInfo.setDataSize(args.getDataSize());
            keyInfo.setModificationTime(Time.now());
            List locationInfoList = args.getLocationInfoList();
            Preconditions.checkNotNull((Object)locationInfoList);
            keyInfo.updateLocationInfoList(locationInfoList);
            this.metadataManager.getStore().move((Object)openKey, (Object)objectKey, (Object)keyInfo, this.metadataManager.getOpenKeyTable(), this.metadataManager.getKeyTable());
        }
        catch (OMException e) {
            throw e;
        }
        catch (IOException ex) {
            LOG.error("Key commit failed for volume:{} bucket:{} key:{}", new Object[]{volumeName, bucketName, keyName, ex});
            throw new OMException(ex.getMessage(), OMException.ResultCodes.KEY_ALLOCATION_ERROR);
        }
        finally {
            this.metadataManager.getLock().releaseBucketLock(volumeName, bucketName);
        }
    }

    @Override
    public OmKeyInfo lookupKey(OmKeyArgs args) throws IOException {
        Preconditions.checkNotNull((Object)args);
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        this.metadataManager.getLock().acquireBucketLock(volumeName, bucketName);
        try {
            String keyBytes = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
            OmKeyInfo value = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)keyBytes);
            if (value == null) {
                LOG.debug("volume:{} bucket:{} Key:{} not found", new Object[]{volumeName, bucketName, keyName});
                throw new OMException("Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            if (this.grpcBlockTokenEnabled) {
                String remoteUser = KeyManagerImpl.getRemoteUser().getShortUserName();
                for (OmKeyLocationInfoGroup key : value.getKeyLocationVersions()) {
                    key.getLocationList().forEach(k -> k.setToken(this.secretManager.generateToken(remoteUser, k.getBlockID().getContainerBlockID().toString(), this.getAclForUser(remoteUser), k.getLength())));
                }
            }
            if (args.getRefreshPipeline()) {
                for (OmKeyLocationInfoGroup key : value.getKeyLocationVersions()) {
                    key.getLocationList().forEach(k -> {
                        if (this.scmClient.getContainerClient() != null) {
                            try {
                                ContainerWithPipeline cp = this.scmClient.getContainerClient().getContainerWithPipeline(k.getContainerID());
                                if (!cp.getPipeline().equals((Object)k.getPipeline())) {
                                    k.setPipeline(cp.getPipeline());
                                }
                            }
                            catch (IOException e) {
                                LOG.debug("Unable to update pipeline for container");
                            }
                        }
                    });
                }
            }
            OmKeyInfo omKeyInfo = value;
            return omKeyInfo;
        }
        catch (IOException ex) {
            LOG.debug("Get key failed for volume:{} bucket:{} key:{}", new Object[]{volumeName, bucketName, keyName, ex});
            throw new OMException(ex.getMessage(), OMException.ResultCodes.KEY_NOT_FOUND);
        }
        finally {
            this.metadataManager.getLock().releaseBucketLock(volumeName, bucketName);
        }
    }

    @Override
    public void renameKey(OmKeyArgs args, String toKeyName) throws IOException {
        Preconditions.checkNotNull((Object)args);
        Preconditions.checkNotNull((Object)toKeyName);
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String fromKeyName = args.getKeyName();
        if (toKeyName.length() == 0 || fromKeyName.length() == 0) {
            LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}", new Object[]{volumeName, bucketName, fromKeyName, toKeyName});
            throw new OMException("Key name is empty", OMException.ResultCodes.INVALID_KEY_NAME);
        }
        this.metadataManager.getLock().acquireBucketLock(volumeName, bucketName);
        try {
            String fromKey = this.metadataManager.getOzoneKey(volumeName, bucketName, fromKeyName);
            OmKeyInfo fromKeyValue = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)fromKey);
            if (fromKeyValue == null) {
                LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}. Key: {} not found.", new Object[]{volumeName, bucketName, fromKeyName, toKeyName, fromKeyName});
                throw new OMException("Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            if (fromKeyName.equals(toKeyName)) {
                return;
            }
            String toKey = this.metadataManager.getOzoneKey(volumeName, bucketName, toKeyName);
            OmKeyInfo toKeyValue = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)toKey);
            if (toKeyValue != null) {
                LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}. Key: {} already exists.", new Object[]{volumeName, bucketName, fromKeyName, toKeyName, toKeyName});
                throw new OMException("Key already exists", OMException.ResultCodes.KEY_ALREADY_EXISTS);
            }
            fromKeyValue.setKeyName(toKeyName);
            fromKeyValue.updateModifcationTime();
            DBStore store = this.metadataManager.getStore();
            try (BatchOperation batch = store.initBatchOperation();){
                this.metadataManager.getKeyTable().deleteWithBatch(batch, (Object)fromKey);
                this.metadataManager.getKeyTable().putWithBatch(batch, (Object)toKey, (Object)fromKeyValue);
                store.commitBatchOperation(batch);
            }
        }
        catch (IOException ex) {
            if (ex instanceof OMException) {
                throw ex;
            }
            LOG.error("Rename key failed for volume:{} bucket:{} fromKey:{} toKey:{}", new Object[]{volumeName, bucketName, fromKeyName, toKeyName, ex});
            throw new OMException(ex.getMessage(), OMException.ResultCodes.KEY_RENAME_ERROR);
        }
        finally {
            this.metadataManager.getLock().releaseBucketLock(volumeName, bucketName);
        }
    }

    @Override
    public void deleteKey(OmKeyArgs args) throws IOException {
        Preconditions.checkNotNull((Object)args);
        String volumeName = args.getVolumeName();
        String bucketName = args.getBucketName();
        String keyName = args.getKeyName();
        this.metadataManager.getLock().acquireBucketLock(volumeName, bucketName);
        try {
            String objectKey = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
            OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)objectKey);
            if (keyInfo == null) {
                throw new OMException("Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            if (this.isKeyEmpty(keyInfo)) {
                this.metadataManager.getKeyTable().delete((Object)objectKey);
                LOG.debug("Key {} deleted from OM DB", (Object)keyName);
                return;
            }
            this.metadataManager.getStore().move((Object)objectKey, this.metadataManager.getKeyTable(), this.metadataManager.getDeletedTable());
        }
        catch (OMException ex) {
            throw ex;
        }
        catch (IOException ex) {
            LOG.error(String.format("Delete key failed for volume:%s bucket:%s key:%s", volumeName, bucketName, keyName), (Throwable)ex);
            throw new OMException(ex.getMessage(), (Throwable)ex, OMException.ResultCodes.KEY_DELETION_ERROR);
        }
        finally {
            this.metadataManager.getLock().releaseBucketLock(volumeName, bucketName);
        }
    }

    private boolean isKeyEmpty(OmKeyInfo keyInfo) {
        for (OmKeyLocationInfoGroup keyLocationList : keyInfo.getKeyLocationVersions()) {
            if (keyLocationList.getLocationList().size() == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<OmKeyInfo> listKeys(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        return this.metadataManager.listKeys(volumeName, bucketName, startKey, keyPrefix, maxKeys);
    }

    @Override
    public List<BlockGroup> getPendingDeletionKeys(int count) throws IOException {
        return this.metadataManager.getPendingDeletionKeys(count);
    }

    @Override
    public List<BlockGroup> getExpiredOpenKeys() throws IOException {
        return this.metadataManager.getExpiredOpenKeys();
    }

    @Override
    public void deleteExpiredOpenKey(String objectKeyName) throws IOException {
        Preconditions.checkNotNull((Object)objectKeyName);
    }

    @Override
    public OMMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    @Override
    public BackgroundService getDeletingService() {
        return this.keyDeletingService;
    }

    /*
     * Exception decompiling
     */
    @Override
    public OmMultipartInfo initiateMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public OmMultipartCommitUploadPartInfo commitMultipartUploadPart(OmKeyArgs omKeyArgs, long clientID) throws IOException {
        String partName;
        block31: {
            Preconditions.checkNotNull((Object)omKeyArgs);
            String volumeName = omKeyArgs.getVolumeName();
            String bucketName = omKeyArgs.getBucketName();
            String keyName = omKeyArgs.getKeyName();
            String uploadID = omKeyArgs.getMultipartUploadID();
            int partNumber = omKeyArgs.getMultipartUploadPartNumber();
            this.metadataManager.getLock().acquireBucketLock(volumeName, bucketName);
            this.validateS3Bucket(volumeName, bucketName);
            try {
                String multipartKey = this.metadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
                OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)this.metadataManager.getMultipartInfoTable().get((Object)multipartKey);
                String openKey = this.metadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
                OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)openKey);
                keyInfo.setDataSize(omKeyArgs.getDataSize());
                keyInfo.updateLocationInfoList(omKeyArgs.getLocationInfoList());
                partName = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName) + clientID;
                if (multipartKeyInfo == null) {
                    this.metadataManager.getDeletedTable().put((Object)partName, (Object)keyInfo);
                    throw new OMException("No such Multipart upload is with specified uploadId " + uploadID, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
                }
                OzoneManagerProtocolProtos.PartKeyInfo oldPartKeyInfo = multipartKeyInfo.getPartKeyInfo(partNumber);
                OzoneManagerProtocolProtos.PartKeyInfo.Builder partKeyInfo = OzoneManagerProtocolProtos.PartKeyInfo.newBuilder();
                partKeyInfo.setPartName(partName);
                partKeyInfo.setPartNumber(partNumber);
                partKeyInfo.setPartKeyInfo(keyInfo.getProtobuf());
                multipartKeyInfo.addPartKeyInfo(partNumber, partKeyInfo.build());
                if (oldPartKeyInfo == null) {
                    DBStore store = this.metadataManager.getStore();
                    try (BatchOperation batch = store.initBatchOperation();){
                        this.metadataManager.getOpenKeyTable().deleteWithBatch(batch, (Object)openKey);
                        this.metadataManager.getMultipartInfoTable().putWithBatch(batch, (Object)multipartKey, (Object)multipartKeyInfo);
                        store.commitBatchOperation(batch);
                        break block31;
                    }
                }
                DBStore store = this.metadataManager.getStore();
                try (BatchOperation batch = store.initBatchOperation();){
                    this.metadataManager.getDeletedTable().putWithBatch(batch, (Object)oldPartKeyInfo.getPartName(), (Object)OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)oldPartKeyInfo.getPartKeyInfo()));
                    this.metadataManager.getOpenKeyTable().deleteWithBatch(batch, (Object)openKey);
                    this.metadataManager.getMultipartInfoTable().putWithBatch(batch, (Object)multipartKey, (Object)multipartKeyInfo);
                    store.commitBatchOperation(batch);
                }
            }
            catch (IOException ex) {
                LOG.error("Upload part Failed: volume:{} bucket:{} key:{} PartNumber: {}", new Object[]{volumeName, bucketName, keyName, partNumber, ex});
                throw new OMException(ex.getMessage(), OMException.ResultCodes.MULTIPART_UPLOAD_PARTFILE_ERROR);
            }
            finally {
                this.metadataManager.getLock().releaseBucketLock(volumeName, bucketName);
            }
        }
        return new OmMultipartCommitUploadPartInfo(partName);
    }

    @Override
    public OmMultipartUploadCompleteInfo completeMultipartUpload(OmKeyArgs omKeyArgs, OmMultipartUploadList multipartUploadList) throws IOException {
        Preconditions.checkNotNull((Object)omKeyArgs);
        Preconditions.checkNotNull((Object)multipartUploadList);
        String volumeName = omKeyArgs.getVolumeName();
        String bucketName = omKeyArgs.getBucketName();
        String keyName = omKeyArgs.getKeyName();
        String uploadID = omKeyArgs.getMultipartUploadID();
        this.metadataManager.getLock().acquireBucketLock(volumeName, bucketName);
        this.validateS3Bucket(volumeName, bucketName);
        try {
            String multipartKey = this.metadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
            String ozoneKey = this.metadataManager.getOzoneKey(volumeName, bucketName, keyName);
            OmKeyInfo keyInfo = (OmKeyInfo)this.metadataManager.getKeyTable().get((Object)ozoneKey);
            OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)this.metadataManager.getMultipartInfoTable().get((Object)multipartKey);
            if (multipartKeyInfo == null) {
                throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            TreeMap partKeyInfoMap = multipartKeyInfo.getPartKeyInfoMap();
            TreeMap multipartMap = multipartUploadList.getMultipartMap();
            Map.Entry multipartMapLastEntry = multipartMap.lastEntry();
            Map.Entry partKeyInfoLastEntry = partKeyInfoMap.lastEntry();
            if (partKeyInfoMap.size() != multipartMap.size()) {
                throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.MISMATCH_MULTIPART_LIST);
            }
            if (((Integer)multipartMapLastEntry.getKey()).intValue() != partKeyInfoMap.size() || ((Integer)partKeyInfoLastEntry.getKey()).intValue() != partKeyInfoMap.size()) {
                throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.MISSING_UPLOAD_PARTS);
            }
            HddsProtos.ReplicationType type = ((OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoLastEntry.getValue()).getPartKeyInfo().getType();
            HddsProtos.ReplicationFactor factor = ((OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoLastEntry.getValue()).getPartKeyInfo().getFactor();
            ArrayList locations = new ArrayList();
            long size = 0L;
            int partsCount = 1;
            int partsMapSize = partKeyInfoMap.size();
            for (Map.Entry partKeyInfoEntry : partKeyInfoMap.entrySet()) {
                int partNumber = (Integer)partKeyInfoEntry.getKey();
                OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo = (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoEntry.getValue();
                String providedPartName = (String)multipartMap.get(partNumber);
                String actualPartName = partKeyInfo.getPartName();
                if (partNumber == partsCount) {
                    if (!actualPartName.equals(providedPartName)) {
                        throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.MISMATCH_MULTIPART_LIST);
                    }
                    OmKeyInfo currentPartKeyInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)partKeyInfo.getPartKeyInfo());
                    if (partsCount != partsMapSize && currentPartKeyInfo.getDataSize() < 0x500000L) {
                        LOG.error("MultipartUpload: " + ozoneKey + "Part number: " + partKeyInfo.getPartNumber() + "size " + currentPartKeyInfo.getDataSize() + " is less than minimum part size " + 0x500000);
                        throw new OMException("Complete Multipart Upload Failed: Entity too small: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.ENTITY_TOO_SMALL);
                    }
                    OmKeyLocationInfoGroup currentKeyInfoGroup = (OmKeyLocationInfoGroup)currentPartKeyInfo.getKeyLocationVersions().get(0);
                    locations.addAll(currentKeyInfoGroup.getLocationList());
                    size += currentPartKeyInfo.getDataSize();
                } else {
                    throw new OMException("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.MISSING_UPLOAD_PARTS);
                }
                ++partsCount;
            }
            if (keyInfo == null) {
                OmKeyLocationInfoGroup keyLocationInfoGroup = new OmKeyLocationInfoGroup(0L, locations);
                keyInfo = new OmKeyInfo.Builder().setVolumeName(omKeyArgs.getVolumeName()).setBucketName(omKeyArgs.getBucketName()).setKeyName(omKeyArgs.getKeyName()).setReplicationFactor(factor).setReplicationType(type).setCreationTime(Time.now()).setModificationTime(Time.now()).setDataSize(size).setOmKeyLocationInfos(Collections.singletonList(keyLocationInfoGroup)).build();
            } else {
                keyInfo.updateLocationInfoList(locations);
            }
            DBStore store = this.metadataManager.getStore();
            try (BatchOperation batch = store.initBatchOperation();){
                this.metadataManager.getMultipartInfoTable().deleteWithBatch(batch, (Object)multipartKey);
                this.metadataManager.getKeyTable().putWithBatch(batch, (Object)ozoneKey, (Object)keyInfo);
                store.commitBatchOperation(batch);
            }
            OmMultipartUploadCompleteInfo omMultipartUploadCompleteInfo = new OmMultipartUploadCompleteInfo(omKeyArgs.getVolumeName(), omKeyArgs.getBucketName(), omKeyArgs.getKeyName(), DigestUtils.sha256Hex((String)keyName));
            return omMultipartUploadCompleteInfo;
        }
        catch (OMException ex) {
            throw ex;
        }
        catch (IOException ex) {
            LOG.error("Complete Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, (Throwable)ex);
            throw new OMException(ex.getMessage(), OMException.ResultCodes.COMPLETE_MULTIPART_UPLOAD_ERROR);
        }
        finally {
            this.metadataManager.getLock().releaseBucketLock(volumeName, bucketName);
        }
    }

    @Override
    public void abortMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        Preconditions.checkNotNull((Object)omKeyArgs);
        String volumeName = omKeyArgs.getVolumeName();
        String bucketName = omKeyArgs.getBucketName();
        String keyName = omKeyArgs.getKeyName();
        String uploadID = omKeyArgs.getMultipartUploadID();
        Preconditions.checkNotNull((Object)uploadID, (Object)"uploadID cannot be null");
        this.validateS3Bucket(volumeName, bucketName);
        this.metadataManager.getLock().acquireBucketLock(volumeName, bucketName);
        try {
            String multipartKey = this.metadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
            OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)this.metadataManager.getMultipartInfoTable().get((Object)multipartKey);
            OmKeyInfo openKeyInfo = (OmKeyInfo)this.metadataManager.getOpenKeyTable().get((Object)multipartKey);
            if (openKeyInfo == null) {
                LOG.error("Abort Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName + "with error no such uploadID:" + uploadID);
                throw new OMException("Abort Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            TreeMap partKeyInfoMap = multipartKeyInfo.getPartKeyInfoMap();
            DBStore store = this.metadataManager.getStore();
            try (BatchOperation batch = store.initBatchOperation();){
                for (Map.Entry partKeyInfoEntry : partKeyInfoMap.entrySet()) {
                    OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo = (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoEntry.getValue();
                    OmKeyInfo currentKeyPartInfo = OmKeyInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyInfo)partKeyInfo.getPartKeyInfo());
                    this.metadataManager.getDeletedTable().putWithBatch(batch, (Object)partKeyInfo.getPartName(), (Object)currentKeyPartInfo);
                }
                this.metadataManager.getMultipartInfoTable().deleteWithBatch(batch, (Object)multipartKey);
                this.metadataManager.getOpenKeyTable().deleteWithBatch(batch, (Object)multipartKey);
                store.commitBatchOperation(batch);
            }
        }
        catch (OMException ex) {
            throw ex;
        }
        catch (IOException ex) {
            LOG.error("Abort Multipart Upload Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, (Throwable)ex);
            throw new OMException(ex.getMessage(), OMException.ResultCodes.ABORT_MULTIPART_UPLOAD_FAILED);
        }
        finally {
            this.metadataManager.getLock().releaseBucketLock(volumeName, bucketName);
        }
    }

    @Override
    public OmMultipartUploadListParts listParts(String volumeName, String bucketName, String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        Preconditions.checkNotNull((Object)volumeName);
        Preconditions.checkNotNull((Object)bucketName);
        Preconditions.checkNotNull((Object)keyName);
        Preconditions.checkNotNull((Object)uploadID);
        boolean isTruncated = false;
        int nextPartNumberMarker = 0;
        this.metadataManager.getLock().acquireBucketLock(volumeName, bucketName);
        try {
            Map.Entry partKeyInfoEntry;
            String multipartKey = this.metadataManager.getMultipartKey(volumeName, bucketName, keyName, uploadID);
            OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)this.metadataManager.getMultipartInfoTable().get((Object)multipartKey);
            if (multipartKeyInfo == null) {
                throw new OMException("No Such Multipart upload exists for this key.", OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            TreeMap partKeyInfoMap = multipartKeyInfo.getPartKeyInfoMap();
            Iterator partKeyInfoMapIterator = partKeyInfoMap.entrySet().iterator();
            HddsProtos.ReplicationType replicationType = ((OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoMap.firstEntry().getValue()).getPartKeyInfo().getType();
            int count = 0;
            ArrayList<OmPartInfo> omPartInfoList = new ArrayList<OmPartInfo>();
            while (count < maxParts && partKeyInfoMapIterator.hasNext()) {
                partKeyInfoEntry = partKeyInfoMapIterator.next();
                nextPartNumberMarker = (Integer)partKeyInfoEntry.getKey();
                if ((Integer)partKeyInfoEntry.getKey() <= partNumberMarker) continue;
                OzoneManagerProtocolProtos.PartKeyInfo partKeyInfo = (OzoneManagerProtocolProtos.PartKeyInfo)partKeyInfoEntry.getValue();
                OmPartInfo omPartInfo = new OmPartInfo(partKeyInfo.getPartNumber(), partKeyInfo.getPartName(), partKeyInfo.getPartKeyInfo().getModificationTime(), partKeyInfo.getPartKeyInfo().getDataSize());
                omPartInfoList.add(omPartInfo);
                replicationType = partKeyInfo.getPartKeyInfo().getType();
                ++count;
            }
            if (partKeyInfoMapIterator.hasNext()) {
                partKeyInfoEntry = partKeyInfoMapIterator.next();
                isTruncated = true;
            } else {
                isTruncated = false;
                nextPartNumberMarker = 0;
            }
            OmMultipartUploadListParts omMultipartUploadListParts = new OmMultipartUploadListParts(replicationType, nextPartNumberMarker, isTruncated);
            omMultipartUploadListParts.addPartList(omPartInfoList);
            OmMultipartUploadListParts omMultipartUploadListParts2 = omMultipartUploadListParts;
            return omMultipartUploadListParts2;
        }
        catch (OMException ex) {
            throw ex;
        }
        catch (IOException ex) {
            LOG.error("List Multipart Upload Parts Failed: volume: " + volumeName + "bucket: " + bucketName + "key: " + keyName, (Throwable)ex);
            throw new OMException(ex.getMessage(), OMException.ResultCodes.LIST_MULTIPART_UPLOAD_PARTS_FAILED);
        }
        finally {
            this.metadataManager.getLock().releaseBucketLock(volumeName, bucketName);
        }
    }
}

