/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.utils.db.DBCheckpoint;
import org.apache.hadoop.utils.db.DBStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDBCheckpointServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(OMDBCheckpointServlet.class);
    private static final long serialVersionUID = 1L;
    private transient DBStore omDbStore;
    private transient DataTransferThrottler throttler = null;

    public void init() throws ServletException {
        OzoneManager om = (OzoneManager)this.getServletContext().getAttribute("ozone.om");
        if (om == null) {
            LOG.error("Unable to initialize OMDBCheckpointServlet. OM is null");
            return;
        }
        this.omDbStore = om.getMetadataManager().getStore();
        OzoneConfiguration configuration = om.getConfiguration();
        long transferBandwidth = configuration.getLongBytes("ozone.manager.db.checkpoint.transfer.bandwidthPerSec", 0L);
        if (transferBandwidth > 0L) {
            this.throttler = new DataTransferThrottler(transferBandwidth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        File checkPointTarFile;
        FileInputStream checkpointFileInputStream;
        block12: {
            block13: {
                block10: {
                    block11: {
                        LOG.info("Received request to obtain OM DB checkpoint snapshot");
                        if (this.omDbStore == null) {
                            LOG.error("Unable to process metadata snapshot request. DB Store is null");
                            response.setStatus(500);
                            return;
                        }
                        checkpointFileInputStream = null;
                        checkPointTarFile = null;
                        try {
                            DBCheckpoint checkpoint;
                            boolean flush = false;
                            String flushParam = request.getParameter("flushBeforeCheckpoint");
                            if (StringUtils.isNotEmpty((CharSequence)flushParam)) {
                                flush = Boolean.valueOf(flushParam);
                            }
                            if ((checkpoint = this.omDbStore.getCheckpoint(flush)) == null) {
                                LOG.error("Unable to process metadata snapshot request. Checkpoint request returned null.");
                                response.setStatus(500);
                                if (checkPointTarFile == null) break block10;
                                break block11;
                            }
                            checkPointTarFile = OmUtils.createTarFile((Path)checkpoint.getCheckpointLocation());
                            LOG.info("Tar location = " + checkPointTarFile.getAbsolutePath());
                            response.setContentType("application/x-tgz");
                            response.setHeader("Content-Disposition", "attachment; filename=\"" + checkPointTarFile.getName() + "\"");
                            checkpointFileInputStream = new FileInputStream(checkPointTarFile);
                            TransferFsImage.copyFileToStream((OutputStream)response.getOutputStream(), (File)checkPointTarFile, (FileInputStream)checkpointFileInputStream, (DataTransferThrottler)this.throttler);
                            checkpoint.cleanupCheckpoint();
                            if (checkPointTarFile == null) break block12;
                            break block13;
                        }
                        catch (IOException e) {
                            LOG.error("Unable to process metadata snapshot request. ", (Throwable)e);
                            response.setStatus(500);
                            return;
                        }
                    }
                    FileUtils.deleteQuietly((File)checkPointTarFile);
                }
                IOUtils.closeStream(checkpointFileInputStream);
                return;
            }
            FileUtils.deleteQuietly((File)checkPointTarFile);
        }
        IOUtils.closeStream((Closeable)checkpointFileInputStream);
        return;
        finally {
            if (checkPointTarFile != null) {
                FileUtils.deleteQuietly(checkPointTarFile);
            }
            IOUtils.closeStream(checkpointFileInputStream);
        }
    }
}

