/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OzoneManagerLock;
import org.apache.hadoop.ozone.om.codec.OmBucketInfoCodec;
import org.apache.hadoop.ozone.om.codec.OmKeyInfoCodec;
import org.apache.hadoop.ozone.om.codec.OmMultipartKeyInfoCodec;
import org.apache.hadoop.ozone.om.codec.OmVolumeArgsCodec;
import org.apache.hadoop.ozone.om.codec.TokenIdentifierCodec;
import org.apache.hadoop.ozone.om.codec.VolumeListCodec;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.utils.db.Codec;
import org.apache.hadoop.utils.db.DBStore;
import org.apache.hadoop.utils.db.DBStoreBuilder;
import org.apache.hadoop.utils.db.Table;
import org.apache.hadoop.utils.db.TableIterator;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmMetadataManagerImpl
implements OMMetadataManager {
    private static final Logger LOG = LoggerFactory.getLogger(OmMetadataManagerImpl.class);
    private static final String USER_TABLE = "userTable";
    private static final String VOLUME_TABLE = "volumeTable";
    private static final String BUCKET_TABLE = "bucketTable";
    private static final String KEY_TABLE = "keyTable";
    private static final String DELETED_TABLE = "deletedTable";
    private static final String OPEN_KEY_TABLE = "openKeyTable";
    private static final String S3_TABLE = "s3Table";
    private static final String MULTIPARTINFO_TABLE = "multipartInfoTable";
    private static final String S3_SECRET_TABLE = "s3SecretTable";
    private static final String DELEGATION_TOKEN_TABLE = "dTokenTable";
    private DBStore store;
    private final OzoneManagerLock lock;
    private final long openKeyExpireThresholdMS;
    private Table userTable;
    private Table volumeTable;
    private Table bucketTable;
    private Table keyTable;
    private Table deletedTable;
    private Table openKeyTable;
    private Table s3Table;
    private Table<String, OmMultipartKeyInfo> multipartInfoTable;
    private Table s3SecretTable;
    private Table dTokenTable;

    public OmMetadataManagerImpl(OzoneConfiguration conf) throws IOException {
        this.lock = new OzoneManagerLock((Configuration)conf);
        this.openKeyExpireThresholdMS = 1000L * (long)conf.getInt("ozone.open.key.expire.threshold", 86400);
        this.start(conf);
    }

    public Table<String, OzoneManagerProtocolProtos.VolumeList> getUserTable() {
        return this.userTable;
    }

    public Table<OzoneTokenIdentifier, Long> getDelegationTokenTable() {
        return this.dTokenTable;
    }

    public Table<String, OmVolumeArgs> getVolumeTable() {
        return this.volumeTable;
    }

    public Table<String, OmBucketInfo> getBucketTable() {
        return this.bucketTable;
    }

    public Table<String, OmKeyInfo> getKeyTable() {
        return this.keyTable;
    }

    public Table<String, OmKeyInfo> getDeletedTable() {
        return this.deletedTable;
    }

    public Table<String, OmKeyInfo> getOpenKeyTable() {
        return this.openKeyTable;
    }

    public Table<byte[], byte[]> getS3Table() {
        return this.s3Table;
    }

    public Table<String, OmMultipartKeyInfo> getMultipartInfoTable() {
        return this.multipartInfoTable;
    }

    private void checkTableStatus(Table table, String name) throws IOException {
        String logMessage = "Unable to get a reference to %s table. Cannot continue.";
        String errMsg = "Inconsistent DB state, Table - %s. Please check the logsfor more info.";
        if (table == null) {
            LOG.error(String.format(logMessage, name));
            throw new IOException(String.format(errMsg, name));
        }
    }

    public void start(OzoneConfiguration configuration) throws IOException {
        if (this.store == null) {
            File metaDir = OmUtils.getOmDbDir((Configuration)configuration);
            this.store = DBStoreBuilder.newBuilder((Configuration)configuration).setName("om.db").setPath(Paths.get(metaDir.getPath(), new String[0])).addTable(USER_TABLE).addTable(VOLUME_TABLE).addTable(BUCKET_TABLE).addTable(KEY_TABLE).addTable(DELETED_TABLE).addTable(OPEN_KEY_TABLE).addTable(S3_TABLE).addTable(MULTIPARTINFO_TABLE).addTable(S3_SECRET_TABLE).addTable(DELEGATION_TOKEN_TABLE).addCodec(OzoneTokenIdentifier.class, (Codec)new TokenIdentifierCodec()).addCodec(OmKeyInfo.class, (Codec)new OmKeyInfoCodec()).addCodec(OmBucketInfo.class, (Codec)new OmBucketInfoCodec()).addCodec(OmVolumeArgs.class, (Codec)new OmVolumeArgsCodec()).addCodec(OzoneManagerProtocolProtos.VolumeList.class, (Codec)new VolumeListCodec()).addCodec(OmMultipartKeyInfo.class, (Codec)new OmMultipartKeyInfoCodec()).build();
            this.userTable = this.store.getTable(USER_TABLE, String.class, OzoneManagerProtocolProtos.VolumeList.class);
            this.checkTableStatus(this.userTable, USER_TABLE);
            this.store.getTable(VOLUME_TABLE, String.class, String.class);
            this.volumeTable = this.store.getTable(VOLUME_TABLE, String.class, OmVolumeArgs.class);
            this.checkTableStatus(this.volumeTable, VOLUME_TABLE);
            this.bucketTable = this.store.getTable(BUCKET_TABLE, String.class, OmBucketInfo.class);
            this.checkTableStatus(this.bucketTable, BUCKET_TABLE);
            this.keyTable = this.store.getTable(KEY_TABLE, String.class, OmKeyInfo.class);
            this.checkTableStatus(this.keyTable, KEY_TABLE);
            this.deletedTable = this.store.getTable(DELETED_TABLE, String.class, OmKeyInfo.class);
            this.checkTableStatus(this.deletedTable, DELETED_TABLE);
            this.openKeyTable = this.store.getTable(OPEN_KEY_TABLE, String.class, OmKeyInfo.class);
            this.checkTableStatus(this.openKeyTable, OPEN_KEY_TABLE);
            this.s3Table = this.store.getTable(S3_TABLE);
            this.checkTableStatus(this.s3Table, S3_TABLE);
            this.dTokenTable = this.store.getTable(DELEGATION_TOKEN_TABLE, OzoneTokenIdentifier.class, Long.class);
            this.checkTableStatus(this.dTokenTable, DELEGATION_TOKEN_TABLE);
            this.multipartInfoTable = this.store.getTable(MULTIPARTINFO_TABLE, String.class, OmMultipartKeyInfo.class);
            this.checkTableStatus(this.multipartInfoTable, MULTIPARTINFO_TABLE);
            this.s3SecretTable = this.store.getTable(S3_SECRET_TABLE);
            this.checkTableStatus(this.s3SecretTable, S3_SECRET_TABLE);
        }
    }

    public void stop() throws Exception {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    @VisibleForTesting
    public DBStore getStore() {
        return this.store;
    }

    public String getVolumeKey(String volume) {
        return "/" + volume;
    }

    public String getUserKey(String user) {
        return user;
    }

    public String getBucketKey(String volume, String bucket) {
        StringBuilder builder = new StringBuilder().append("/").append(volume);
        if (StringUtils.isNotBlank((CharSequence)bucket)) {
            builder.append("/").append(bucket);
        }
        return builder.toString();
    }

    public String getOzoneKey(String volume, String bucket, String key) {
        StringBuilder builder = new StringBuilder().append("/").append(volume);
        builder.append("/").append(bucket);
        if (StringUtil.isNotBlank((String)key)) {
            builder.append("/").append(key);
        }
        return builder.toString();
    }

    public String getOpenKey(String volume, String bucket, String key, long id) {
        String openKey = "/" + volume + "/" + bucket + "/" + key + "/" + id;
        return openKey;
    }

    public String getMultipartKey(String volume, String bucket, String key, String uploadId) {
        String multipartKey = "/" + volume + "/" + bucket + "/" + key + "/" + uploadId;
        return multipartKey;
    }

    public OzoneManagerLock getLock() {
        return this.lock;
    }

    private boolean startsWith(byte[] firstArray, byte[] secondArray) {
        if (firstArray == null) {
            return secondArray == null;
        }
        if (secondArray != null) {
            if (secondArray.length > firstArray.length) {
                return false;
            }
            for (int ndx = 0; ndx < secondArray.length; ++ndx) {
                if (firstArray[ndx] == secondArray[ndx]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isVolumeEmpty(String volume) throws IOException {
        String volumePrefix = this.getVolumeKey(volume + "/");
        try (TableIterator bucketIter = this.bucketTable.iterator();){
            Table.KeyValue kv = (Table.KeyValue)bucketIter.seek((Object)volumePrefix);
            if (kv != null && ((String)kv.getKey()).startsWith(volumePrefix)) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public boolean isBucketEmpty(String volume, String bucket) throws IOException {
        String keyPrefix = this.getBucketKey(volume, bucket);
        try (TableIterator keyIter = this.keyTable.iterator();){
            Table.KeyValue kv = (Table.KeyValue)keyIter.seek((Object)keyPrefix);
            if (kv != null && ((String)kv.getKey()).startsWith(keyPrefix)) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public List<OmBucketInfo> listBuckets(String volumeName, String startBucket, String bucketPrefix, int maxNumOfBuckets) throws IOException {
        String startKey;
        ArrayList<OmBucketInfo> result = new ArrayList<OmBucketInfo>();
        if (Strings.isNullOrEmpty((String)volumeName)) {
            throw new OMException("Volume name is required.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        String volumeNameBytes = this.getVolumeKey(volumeName);
        if (this.volumeTable.get((Object)volumeNameBytes) == null) {
            throw new OMException("Volume " + volumeName + " not found.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        boolean skipStartKey = false;
        if (StringUtil.isNotBlank((String)startBucket)) {
            startKey = this.getBucketKey(volumeName, startBucket);
            skipStartKey = true;
        } else {
            startKey = this.getBucketKey(volumeName, bucketPrefix);
        }
        String seekPrefix = StringUtil.isNotBlank((String)bucketPrefix) ? this.getBucketKey(volumeName, bucketPrefix) : this.getVolumeKey(volumeName + "/");
        int currentCount = 0;
        try (TableIterator bucketIter = this.bucketTable.iterator();){
            Table.KeyValue kv = (Table.KeyValue)bucketIter.seek((Object)startKey);
            while (currentCount < maxNumOfBuckets && bucketIter.hasNext()) {
                kv = (Table.KeyValue)bucketIter.next();
                if (kv != null && skipStartKey && ((String)kv.getKey()).equals(startKey)) continue;
                if (kv != null && ((String)kv.getKey()).startsWith(seekPrefix)) {
                    result.add((OmBucketInfo)kv.getValue());
                    ++currentCount;
                    continue;
                }
                break;
            }
        }
        return result;
    }

    public List<OmKeyInfo> listKeys(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        String seekKey;
        ArrayList<OmKeyInfo> result = new ArrayList<OmKeyInfo>();
        if (Strings.isNullOrEmpty((String)volumeName)) {
            throw new OMException("Volume name is required.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)bucketName)) {
            throw new OMException("Bucket name is required.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        String bucketNameBytes = this.getBucketKey(volumeName, bucketName);
        if (this.getBucketTable().get((Object)bucketNameBytes) == null) {
            throw new OMException("Bucket " + bucketName + " not found.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        boolean skipStartKey = false;
        if (StringUtil.isNotBlank((String)startKey)) {
            seekKey = this.getOzoneKey(volumeName, bucketName, startKey);
            skipStartKey = true;
        } else {
            seekKey = this.getOzoneKey(volumeName, bucketName, keyPrefix);
        }
        String seekPrefix = StringUtil.isNotBlank((String)keyPrefix) ? this.getOzoneKey(volumeName, bucketName, keyPrefix) : this.getBucketKey(volumeName, bucketName + "/");
        int currentCount = 0;
        try (TableIterator keyIter = this.getKeyTable().iterator();){
            Table.KeyValue kv = (Table.KeyValue)keyIter.seek((Object)seekKey);
            while (currentCount < maxKeys && keyIter.hasNext()) {
                kv = (Table.KeyValue)keyIter.next();
                if (kv != null && skipStartKey && ((String)kv.getKey()).equals(seekKey)) continue;
                if (kv != null && ((String)kv.getKey()).startsWith(seekPrefix)) {
                    result.add((OmKeyInfo)kv.getValue());
                    ++currentCount;
                    continue;
                }
                break;
            }
        }
        return result;
    }

    public List<OmVolumeArgs> listVolumes(String userName, String prefix, String startKey, int maxKeys) throws IOException {
        ArrayList result = Lists.newArrayList();
        if (StringUtil.isBlank((String)userName)) {
            throw new OMException("User name is required to list Volumes.", OMException.ResultCodes.USER_NOT_FOUND);
        }
        OzoneManagerProtocolProtos.VolumeList volumes = this.getVolumesByUser(userName);
        if (volumes == null || volumes.getVolumeNamesCount() == 0) {
            return result;
        }
        boolean startKeyFound = Strings.isNullOrEmpty((String)startKey);
        for (String volumeName : volumes.getVolumeNamesList()) {
            if (!Strings.isNullOrEmpty((String)prefix) && !volumeName.startsWith(prefix)) continue;
            if (!startKeyFound && volumeName.equals(startKey)) {
                startKeyFound = true;
                continue;
            }
            if (!startKeyFound || result.size() >= maxKeys) continue;
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.getVolumeTable().get((Object)this.getVolumeKey(volumeName));
            if (volumeArgs == null) {
                throw new OMException("Volume info not found for " + volumeName, OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            result.add(volumeArgs);
        }
        return result;
    }

    private OzoneManagerProtocolProtos.VolumeList getVolumesByUser(String userNameKey) throws OMException {
        try {
            OzoneManagerProtocolProtos.VolumeList volumeList = (OzoneManagerProtocolProtos.VolumeList)this.getUserTable().get((Object)userNameKey);
            if (volumeList == null) {
                return OzoneManagerProtocolProtos.VolumeList.newBuilder().build();
            }
            return volumeList;
        }
        catch (IOException e) {
            throw new OMException("Unable to get volumes info by the given user, metadata might be corrupted", (Throwable)e, OMException.ResultCodes.METADATA_ERROR);
        }
    }

    public List<BlockGroup> getPendingDeletionKeys(int keyCount) throws IOException {
        ArrayList keyBlocksList = Lists.newArrayList();
        try (TableIterator keyIter = this.getDeletedTable().iterator();){
            int currentCount = 0;
            while (keyIter.hasNext() && currentCount < keyCount) {
                Table.KeyValue kv = (Table.KeyValue)keyIter.next();
                if (kv == null) continue;
                OmKeyInfo info = (OmKeyInfo)kv.getValue();
                OmKeyLocationInfoGroup latest = info.getLatestVersionLocations();
                List item = latest.getLocationList().stream().map(b -> new BlockID(b.getContainerID(), b.getLocalID())).collect(Collectors.toList());
                BlockGroup keyBlocks = BlockGroup.newBuilder().setKeyName((String)kv.getKey()).addAllBlockIDs(item).build();
                keyBlocksList.add(keyBlocks);
                ++currentCount;
            }
        }
        return keyBlocksList;
    }

    public List<BlockGroup> getExpiredOpenKeys() throws IOException {
        ArrayList keyBlocksList = Lists.newArrayList();
        return keyBlocksList;
    }

    public <KEY, VALUE> long countRowsInTable(Table<KEY, VALUE> table) throws IOException {
        long count = 0L;
        if (table != null) {
            try (TableIterator keyValueTableIterator = table.iterator();){
                while (keyValueTableIterator.hasNext()) {
                    keyValueTableIterator.next();
                    ++count;
                }
            }
        }
        return count;
    }

    public Table<byte[], byte[]> getS3SecretTable() {
        return this.s3SecretTable;
    }
}

