/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.BlockingService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import javax.net.SocketFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolPB;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolPB;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.client.OMCertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.hdds.security.x509.certificates.utils.CertificateSignRequest;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.server.ServiceRuntimeInfoImpl;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.OzoneIllegalArgumentException;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditLoggerType;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.audit.Auditor;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.common.Storage;
import org.apache.hadoop.ozone.om.BucketManager;
import org.apache.hadoop.ozone.om.BucketManagerImpl;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.KeyManagerImpl;
import org.apache.hadoop.ozone.om.OMMXBean;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OMNodeDetails;
import org.apache.hadoop.ozone.om.OMPolicyProvider;
import org.apache.hadoop.ozone.om.OMStorage;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OmMetricsInfo;
import org.apache.hadoop.ozone.om.OzoneManagerHttpServer;
import org.apache.hadoop.ozone.om.S3BucketManager;
import org.apache.hadoop.ozone.om.S3BucketManagerImpl;
import org.apache.hadoop.ozone.om.S3SecretManager;
import org.apache.hadoop.ozone.om.S3SecretManagerImpl;
import org.apache.hadoop.ozone.om.ScmClient;
import org.apache.hadoop.ozone.om.VolumeManager;
import org.apache.hadoop.ozone.om.VolumeManagerImpl;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.ha.OMFailoverProxyProvider;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisClient;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisServer;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerProtocolServerSideTranslatorPB;
import org.apache.hadoop.ozone.security.OzoneBlockTokenSecretManager;
import org.apache.hadoop.ozone.security.OzoneDelegationTokenSecretManager;
import org.apache.hadoop.ozone.security.OzoneSecurityException;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.IOzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneAclException;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.security.acl.RequestContext;
import org.apache.hadoop.ozone.util.OzoneVersionInfo;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.KMSUtil;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.utils.RetriableTask;
import org.apache.ratis.util.LifeCycle;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "CBLOCK", "OZONE", "HBASE"})
public final class OzoneManager
extends ServiceRuntimeInfoImpl
implements OzoneManagerProtocol,
OMMXBean,
Auditor {
    public static final Logger LOG = LoggerFactory.getLogger(OzoneManager.class);
    private static final AuditLogger AUDIT = new AuditLogger(AuditLoggerType.OMLOGGER);
    private static final String USAGE = "Usage: \n ozone om [genericOptions] [ " + StartupOption.INIT.getName() + " ]\n ozone om [ " + StartupOption.HELP.getName() + " ]\n";
    private static final String OM_DAEMON = "om";
    private static boolean securityEnabled = false;
    private OzoneDelegationTokenSecretManager delegationTokenMgr;
    private OzoneBlockTokenSecretManager blockTokenMgr;
    private CertificateClient certClient;
    private static boolean testSecureOmFlag = false;
    private final Text omRpcAddressTxt;
    private final OzoneConfiguration configuration;
    private RPC.Server omRpcServer;
    private InetSocketAddress omRpcAddress;
    private String omId;
    private OMNodeDetails omNodeDetails;
    private List<OMNodeDetails> peerNodes;
    private boolean isRatisEnabled;
    private OzoneManagerRatisServer omRatisServer;
    private OzoneManagerRatisClient omRatisClient;
    private final OMMetadataManager metadataManager;
    private final VolumeManager volumeManager;
    private final BucketManager bucketManager;
    private final KeyManager keyManager;
    private final OMMetrics metrics;
    private OzoneManagerHttpServer httpServer;
    private final OMStorage omStorage;
    private final ScmBlockLocationProtocol scmBlockClient;
    private final StorageContainerLocationProtocol scmContainerClient;
    private ObjectName omInfoBeanName;
    private final S3BucketManager s3BucketManager;
    private Timer metricsTimer;
    private ScheduleOMMetricsWriteTask scheduleOMMetricsWriteTask;
    private static final ObjectWriter WRITER = new ObjectMapper().writerWithDefaultPrettyPrinter();
    private static final ObjectReader READER = new ObjectMapper().readerFor(OmMetricsInfo.class);
    private static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private final Runnable shutdownHook;
    private final File omMetaDir;
    private final boolean isAclEnabled;
    private final IAccessAuthorizer accessAuthorizer;
    private JvmPauseMonitor jvmPauseMonitor;
    private final SecurityConfig secConfig;
    private S3SecretManager s3SecretManager;
    private volatile boolean isOmRpcServerRunning = false;
    private String omComponent;
    private KeyProviderCryptoExtension kmsProvider = null;
    private static String keyProviderUriKeyName = "hadoop.security.key.provider.path";

    private OzoneManager(OzoneConfiguration conf) throws IOException, AuthenticationException {
        super(OzoneVersionInfo.OZONE_VERSION_INFO);
        ScmInfo scmInfo;
        Preconditions.checkNotNull((Object)conf);
        this.configuration = conf;
        this.omStorage = new OMStorage(conf);
        this.omId = this.omStorage.getOmId();
        if (this.omStorage.getState() != Storage.StorageState.INITIALIZED) {
            throw new OMException("OM not initialized.", OMException.ResultCodes.OM_NOT_INITIALIZED);
        }
        this.loadOMHAConfigs((Configuration)this.configuration);
        this.scmContainerClient = OzoneManager.getScmContainerClient(this.configuration);
        this.scmBlockClient = OzoneManager.getScmBlockClient(this.configuration);
        if (!(testSecureOmFlag || (scmInfo = this.scmBlockClient.getScmInfo()).getClusterId().equals(this.omStorage.getClusterID()) && scmInfo.getScmId().equals(this.omStorage.getScmId()))) {
            throw new OMException("SCM version info mismatch.", OMException.ResultCodes.SCM_VERSION_MISMATCH_ERROR);
        }
        RPC.setProtocolEngine((Configuration)this.configuration, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        this.startRatisServer();
        this.startRatisClient();
        InetSocketAddress omNodeRpcAddr = this.omNodeDetails.getRpcAddress();
        this.omRpcAddressTxt = new Text(this.omNodeDetails.getRpcAddressString());
        this.secConfig = new SecurityConfig((Configuration)this.configuration);
        this.metadataManager = new OmMetadataManagerImpl(this.configuration);
        this.volumeManager = new VolumeManagerImpl(this.metadataManager, this.configuration);
        try {
            this.kmsProvider = this.createKeyProviderExt(this.configuration);
        }
        catch (IOException ioe) {
            this.kmsProvider = null;
            LOG.error("Fail to create Key Provider");
        }
        this.bucketManager = new BucketManagerImpl(this.metadataManager, this.getKmsProvider());
        this.metrics = OMMetrics.create();
        this.s3BucketManager = new S3BucketManagerImpl(this.configuration, this.metadataManager, this.volumeManager, this.bucketManager);
        if (this.secConfig.isSecurityEnabled()) {
            this.omComponent = "om-" + this.omId;
            if (this.omStorage.getOmCertSerialId() == null) {
                throw new RuntimeException("OzoneManager started in secure mode but doesn't have SCM signed certificate.");
            }
            this.certClient = new OMCertificateClient(new SecurityConfig((Configuration)conf), this.omStorage.getOmCertSerialId());
            this.s3SecretManager = new S3SecretManagerImpl(this.configuration, this.metadataManager);
            this.delegationTokenMgr = this.createDelegationTokenSecretManager(this.configuration);
        }
        if (this.secConfig.isBlockTokenEnabled()) {
            this.blockTokenMgr = this.createBlockTokenSecretManager(this.configuration);
        }
        this.omRpcServer = this.getRpcServer(conf);
        this.omRpcAddress = ServerUtils.updateRPCListenAddress((OzoneConfiguration)this.configuration, (String)"ozone.om.address", (InetSocketAddress)omNodeRpcAddr, (RPC.Server)this.omRpcServer);
        this.keyManager = new KeyManagerImpl(new ScmClient(this.scmBlockClient, this.scmContainerClient), this.metadataManager, this.configuration, this.omStorage.getOmId(), this.blockTokenMgr, this.getKmsProvider());
        this.shutdownHook = () -> this.saveOmMetrics();
        ShutdownHookManager.get().addShutdownHook(this.shutdownHook, 30);
        this.isAclEnabled = conf.getBoolean("ozone.acl.enabled", false);
        this.accessAuthorizer = this.isAclEnabled ? this.getACLAuthorizerInstance(conf) : null;
        this.omMetaDir = OmUtils.getOmDbDir((Configuration)this.configuration);
    }

    private void loadOMHAConfigs(Configuration conf) {
        InetSocketAddress localRpcAddress = null;
        String localOMServiceId = null;
        String localOMNodeId = null;
        int localRatisPort = 0;
        Collection omServiceIds = conf.getTrimmedStringCollection("ozone.om.service.ids");
        String knownOMNodeId = conf.get("ozone.om.node.id");
        int found = 0;
        boolean isOMAddressSet = false;
        for (String serviceId : OmUtils.emptyAsSingletonNull((Collection)omServiceIds)) {
            Collection omNodeIds = OmUtils.getOMNodeIds((Configuration)conf, (String)serviceId);
            ArrayList<OMNodeDetails> peerNodesList = new ArrayList<OMNodeDetails>();
            boolean isPeer = false;
            for (String nodeId : OmUtils.emptyAsSingletonNull((Collection)omNodeIds)) {
                isPeer = knownOMNodeId != null && !knownOMNodeId.equals(nodeId);
                String rpcAddrKey = OmUtils.addKeySuffixes((String)"ozone.om.address", (String[])new String[]{serviceId, nodeId});
                String rpcAddrStr = OmUtils.getOmRpcAddress((Configuration)conf, (String)rpcAddrKey);
                if (rpcAddrStr == null) continue;
                isOMAddressSet = true;
                String ratisPortKey = OmUtils.addKeySuffixes((String)"ozone.om.ratis.port", (String[])new String[]{serviceId, nodeId});
                int ratisPort = conf.getInt(ratisPortKey, 9872);
                InetSocketAddress addr = null;
                try {
                    addr = NetUtils.createSocketAddr((String)rpcAddrStr);
                }
                catch (Exception e) {
                    LOG.warn("Exception in creating socket address " + addr, (Throwable)e);
                    continue;
                }
                if (addr.isUnresolved()) continue;
                if (!isPeer && OmUtils.isAddressLocal((InetSocketAddress)addr)) {
                    localRpcAddress = addr;
                    localOMServiceId = serviceId;
                    localOMNodeId = nodeId;
                    localRatisPort = ratisPort;
                    ++found;
                    continue;
                }
                OMNodeDetails peerNodeInfo = new OMNodeDetails.Builder().setOMServiceId(serviceId).setOMNodeId(nodeId).setRpcAddress(addr).setRatisPort(ratisPort).build();
                peerNodesList.add(peerNodeInfo);
            }
            if (found == 1) {
                LOG.debug("Found one matching OM address with service ID: {} and node ID: {}", localOMServiceId, localOMNodeId);
                this.setOMNodeDetails(localOMServiceId, localOMNodeId, localRpcAddress, localRatisPort);
                this.peerNodes = peerNodesList;
                LOG.info("Found matching OM address with OMServiceId: {}, OMNodeId: {}, RPC Address: {} and Ratis port: {}", new Object[]{localOMServiceId, localOMNodeId, NetUtils.getHostPortString(localRpcAddress), localRatisPort});
                return;
            }
            if (found <= true) continue;
            String msg = "Configuration has multiple ozone.om.address addresses that match local node's address. Please configure the system with ozone.om.service.ids and ozone.om.address";
            throw new OzoneIllegalArgumentException(msg);
        }
        if (isOMAddressSet) {
            String msg = "Configuration has no ozone.om.address address that matches local node's address. Please configure the system with ozone.om.address";
            LOG.info(msg);
            throw new OzoneIllegalArgumentException(msg);
        }
        InetSocketAddress omAddress = OmUtils.getOmAddress((Configuration)conf);
        int ratisPort = conf.getInt("ozone.om.ratis.port", 9872);
        LOG.info("Configuration either no {} set. Falling back to the default OM address {}", (Object)"ozone.om.address", (Object)omAddress);
        this.setOMNodeDetails(null, null, omAddress, ratisPort);
    }

    private void setOMNodeDetails(String serviceId, String nodeId, InetSocketAddress rpcAddress, int ratisPort) {
        if (serviceId == null) {
            serviceId = "omServiceIdDefault";
            LOG.info("OM Service ID is not set. Setting it to the default ID: {}", (Object)serviceId);
        }
        if (nodeId == null) {
            nodeId = this.omId;
            LOG.info("OM Node ID is not set. Setting it to the OmStorage's OmID: {}", (Object)nodeId);
        }
        this.omNodeDetails = new OMNodeDetails.Builder().setOMServiceId(serviceId).setOMNodeId(nodeId).setRpcAddress(rpcAddress).setRatisPort(ratisPort).build();
        this.configuration.set("ozone.om.address", NetUtils.getHostPortString((InetSocketAddress)rpcAddress));
    }

    private KeyProviderCryptoExtension createKeyProviderExt(OzoneConfiguration conf) throws IOException {
        KeyProvider keyProvider = KMSUtil.createKeyProvider((Configuration)conf, (String)keyProviderUriKeyName);
        if (keyProvider == null) {
            return null;
        }
        KeyProviderCryptoExtension cryptoProvider = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)keyProvider);
        return cryptoProvider;
    }

    private IAccessAuthorizer getACLAuthorizerInstance(OzoneConfiguration conf) {
        Class clazz = conf.getClass("ozone.acl.authorizer.class", OzoneAccessAuthorizer.class, IAccessAuthorizer.class);
        return (IAccessAuthorizer)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
    }

    public void close() throws IOException {
        this.stop();
    }

    private void saveOmMetrics() {
        try {
            boolean success;
            Files.createDirectories(this.getTempMetricsStorageFile().getParentFile().toPath(), new FileAttribute[0]);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getTempMetricsStorageFile()), "UTF-8"));){
                OmMetricsInfo metricsInfo = new OmMetricsInfo();
                metricsInfo.setNumKeys(this.metrics.getNumKeys());
                WRITER.writeValue((Writer)writer, (Object)metricsInfo);
                success = true;
            }
            if (success) {
                Files.move(this.getTempMetricsStorageFile().toPath(), this.getMetricsStorageFile().toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ex) {
            LOG.error("Unable to write the om Metrics file", (Throwable)ex);
        }
    }

    private File getTempMetricsStorageFile() {
        return new File(this.omMetaDir, "omMetrics.tmp");
    }

    private File getMetricsStorageFile() {
        return new File(this.omMetaDir, "omMetrics");
    }

    private OzoneDelegationTokenSecretManager createDelegationTokenSecretManager(OzoneConfiguration conf) throws IOException {
        long tokenRemoverScanInterval = conf.getTimeDuration("ozone.manager.delegation.remover.scan.interval", 3600000L, TimeUnit.MILLISECONDS);
        long tokenMaxLifetime = conf.getTimeDuration("ozone.manager.delegation.token.max-lifetime", 604800000L, TimeUnit.MILLISECONDS);
        long tokenRenewInterval = conf.getTimeDuration("ozone.manager.delegation.token.renew-interval", 86400000L, TimeUnit.MILLISECONDS);
        return new OzoneDelegationTokenSecretManager(conf, tokenMaxLifetime, tokenRenewInterval, tokenRemoverScanInterval, this.omRpcAddressTxt, this.s3SecretManager);
    }

    private OzoneBlockTokenSecretManager createBlockTokenSecretManager(OzoneConfiguration conf) {
        long expiryTime = conf.getTimeDuration("hdds.block.token.expiry.time", "1d", TimeUnit.MILLISECONDS);
        if (testSecureOmFlag) {
            return new OzoneBlockTokenSecretManager(this.secConfig, expiryTime, "1");
        }
        Objects.requireNonNull(this.certClient);
        return new OzoneBlockTokenSecretManager(this.secConfig, expiryTime, this.certClient.getCertificate().getSerialNumber().toString());
    }

    private void stopSecretManager() {
        if (this.blockTokenMgr != null) {
            LOG.info("Stopping OM block token manager.");
            try {
                this.blockTokenMgr.stop();
            }
            catch (IOException e) {
                LOG.error("Failed to stop block token manager", (Throwable)e);
            }
        }
        if (this.delegationTokenMgr != null) {
            LOG.info("Stopping OM delegation token secret manager.");
            try {
                this.delegationTokenMgr.stop();
            }
            catch (IOException e) {
                LOG.error("Failed to stop delegation token manager", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    public void startSecretManager() {
        try {
            this.readKeyPair();
        }
        catch (OzoneSecurityException e) {
            LOG.error("Unable to read key pair for OM.", (Throwable)e);
            throw new RuntimeException(e);
        }
        if (this.secConfig.isBlockTokenEnabled() && this.blockTokenMgr != null) {
            try {
                LOG.info("Starting OM block token secret manager");
                this.blockTokenMgr.start(this.certClient);
            }
            catch (IOException e) {
                LOG.error("Error starting block token secret manager.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (this.delegationTokenMgr != null) {
            try {
                LOG.info("Starting OM delegation token secret manager");
                this.delegationTokenMgr.start(this.certClient);
            }
            catch (IOException e) {
                LOG.error("Error starting delegation token secret manager.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public void setCertClient(CertificateClient certClient) {
        this.certClient = certClient;
    }

    private void readKeyPair() throws OzoneSecurityException {
        try {
            LOG.info("Reading keypair and certificate from file system.");
            PublicKey pubKey = this.certClient.getPublicKey();
            PrivateKey pvtKey = this.certClient.getPrivateKey();
            Objects.requireNonNull(pubKey);
            Objects.requireNonNull(pvtKey);
            Objects.requireNonNull(this.certClient.getCertificate());
        }
        catch (Exception e) {
            throw new OzoneSecurityException("Error reading keypair & certificate OzoneManager.", (Throwable)e, OzoneSecurityException.ResultCodes.OM_PUBLIC_PRIVATE_KEY_FILE_NOT_EXIST);
        }
    }

    private static void loginOMUser(OzoneConfiguration conf) throws IOException, AuthenticationException {
        if (!SecurityUtil.getAuthenticationMethod((Configuration)conf).equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
            throw new AuthenticationException(SecurityUtil.getAuthenticationMethod((Configuration)conf) + " authentication method not supported. OM user login failed.");
        }
        LOG.debug("Ozone security is enabled. Attempting login for OM user. Principal: {},keytab: {}", (Object)conf.get("ozone.om.kerberos.principal"), (Object)conf.get("ozone.om.kerberos.keytab.file"));
        UserGroupInformation.setConfiguration((Configuration)conf);
        InetSocketAddress socAddr = OmUtils.getOmAddress((Configuration)conf);
        SecurityUtil.login((Configuration)conf, (String)"ozone.om.kerberos.keytab.file", (String)"ozone.om.kerberos.principal", (String)socAddr.getHostName());
        LOG.info("Ozone Manager login successful.");
    }

    private static ScmBlockLocationProtocol getScmBlockClient(OzoneConfiguration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ScmBlockLocationProtocolPB.class, ProtobufRpcEngine.class);
        long scmVersion = RPC.getProtocolVersion(ScmBlockLocationProtocolPB.class);
        InetSocketAddress scmBlockAddress = HddsUtils.getScmAddressForBlockClients((Configuration)conf);
        ScmBlockLocationProtocolClientSideTranslatorPB scmBlockLocationClient = new ScmBlockLocationProtocolClientSideTranslatorPB((ScmBlockLocationProtocolPB)RPC.getProxy(ScmBlockLocationProtocolPB.class, (long)scmVersion, (InetSocketAddress)scmBlockAddress, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf)));
        return (ScmBlockLocationProtocol)TracingUtil.createProxy((Object)scmBlockLocationClient, ScmBlockLocationProtocol.class);
    }

    private static SCMSecurityProtocol getScmSecurityClient(OzoneConfiguration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, SCMSecurityProtocolPB.class, ProtobufRpcEngine.class);
        long scmVersion = RPC.getProtocolVersion(ScmBlockLocationProtocolPB.class);
        InetSocketAddress scmSecurityProtoAdd = HddsUtils.getScmAddressForSecurityProtocol((Configuration)conf);
        SCMSecurityProtocolClientSideTranslatorPB scmSecurityClient = new SCMSecurityProtocolClientSideTranslatorPB((SCMSecurityProtocolPB)RPC.getProxy(SCMSecurityProtocolPB.class, (long)scmVersion, (InetSocketAddress)scmSecurityProtoAdd, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf)));
        return scmSecurityClient;
    }

    private static StorageContainerLocationProtocol getScmContainerClient(OzoneConfiguration conf) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, StorageContainerLocationProtocolPB.class, ProtobufRpcEngine.class);
        long scmVersion = RPC.getProtocolVersion(StorageContainerLocationProtocolPB.class);
        InetSocketAddress scmAddr = HddsUtils.getScmAddressForClients((Configuration)conf);
        StorageContainerLocationProtocol scmContainerClient = (StorageContainerLocationProtocol)TracingUtil.createProxy((Object)new StorageContainerLocationProtocolClientSideTranslatorPB((StorageContainerLocationProtocolPB)RPC.getProxy(StorageContainerLocationProtocolPB.class, (long)scmVersion, (InetSocketAddress)scmAddr, (UserGroupInformation)UserGroupInformation.getCurrentUser(), (Configuration)conf, (SocketFactory)NetUtils.getDefaultSocketFactory((Configuration)conf), (int)Client.getRpcTimeout((Configuration)conf))), StorageContainerLocationProtocol.class);
        return scmContainerClient;
    }

    private RPC.Server startRpcServer(OzoneConfiguration conf, InetSocketAddress addr, Class<?> protocol, BlockingService instance, int handlerCount) throws IOException {
        RPC.Server rpcServer = new RPC.Builder((Configuration)conf).setProtocol(protocol).setInstance((Object)instance).setBindAddress(addr.getHostString()).setPort(addr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager((SecretManager)this.delegationTokenMgr).build();
        DFSUtil.addPBProtocol((Configuration)conf, protocol, (BlockingService)instance, (RPC.Server)rpcServer);
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            rpcServer.refreshServiceAcl((Configuration)conf, (PolicyProvider)OMPolicyProvider.getInstance());
        }
        return rpcServer;
    }

    public static void main(String[] argv) throws IOException {
        if (DFSUtil.parseHelpArgument((String[])argv, (String)USAGE, (PrintStream)System.out, (boolean)true)) {
            System.exit(0);
        }
        try {
            OzoneManager om;
            TracingUtil.initTracing((String)"OzoneManager");
            OzoneConfiguration conf = new OzoneConfiguration();
            GenericOptionsParser hParser = new GenericOptionsParser((Configuration)conf, argv);
            if (!hParser.isParseSuccessful()) {
                System.err.println("USAGE: " + USAGE + " \n");
                GenericOptionsParser.printGenericCommandUsage((PrintStream)System.err);
                System.exit(1);
            }
            if ((om = OzoneManager.createOm(hParser.getRemainingArgs(), conf, true)) != null) {
                om.start();
                om.join();
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to start the OzoneManager.", t);
            ExitUtil.terminate((int)1, (Throwable)t);
        }
    }

    private static void printUsage(PrintStream out) {
        out.println(USAGE + "\n");
    }

    private static boolean isOzoneSecurityEnabled() {
        return securityEnabled;
    }

    @VisibleForTesting
    public static OzoneManager createOm(String[] argv, OzoneConfiguration conf) throws IOException, AuthenticationException {
        return OzoneManager.createOm(argv, conf, false);
    }

    private static OzoneManager createOm(String[] argv, OzoneConfiguration conf, boolean printBanner) throws IOException, AuthenticationException {
        StartupOption startOpt = OzoneManager.parseArguments(argv);
        if (startOpt == null) {
            OzoneManager.printUsage(System.err);
            ExitUtil.terminate((int)1);
            return null;
        }
        securityEnabled = OzoneSecurityUtil.isSecurityEnabled((Configuration)conf);
        if (securityEnabled) {
            OzoneManager.loginOMUser(conf);
        }
        switch (startOpt) {
            case INIT: {
                if (printBanner) {
                    StringUtils.startupShutdownMessage(OzoneManager.class, (String[])argv, (Logger)LOG);
                }
                ExitUtil.terminate((int)(OzoneManager.omInit(conf) ? 0 : 1));
                return null;
            }
            case HELP: {
                OzoneManager.printUsage(System.err);
                ExitUtil.terminate((int)0);
                return null;
            }
        }
        if (argv == null) {
            argv = new String[]{};
        }
        if (printBanner) {
            StringUtils.startupShutdownMessage(OzoneManager.class, (String[])argv, (Logger)LOG);
        }
        return new OzoneManager(conf);
    }

    @VisibleForTesting
    public static boolean omInit(OzoneConfiguration conf) throws IOException {
        OMStorage omStorage = new OMStorage(conf);
        Storage.StorageState state = omStorage.getState();
        if (state != Storage.StorageState.INITIALIZED) {
            try {
                ScmInfo scmInfo = OzoneManager.getScmInfo(conf);
                String clusterId = scmInfo.getClusterId();
                String scmId = scmInfo.getScmId();
                if (clusterId == null || clusterId.isEmpty()) {
                    throw new IOException("Invalid Cluster ID");
                }
                if (scmId == null || scmId.isEmpty()) {
                    throw new IOException("Invalid SCM ID");
                }
                omStorage.setClusterId(clusterId);
                omStorage.setScmId(scmId);
                if (OzoneSecurityUtil.isSecurityEnabled((Configuration)conf)) {
                    OzoneManager.initializeSecurity(conf, omStorage);
                }
                omStorage.initialize();
                System.out.println("OM initialization succeeded.Current cluster id for sd=" + omStorage.getStorageDir() + ";cid=" + omStorage.getClusterID());
                return true;
            }
            catch (IOException ioe) {
                LOG.error("Could not initialize OM version file", (Throwable)ioe);
                return false;
            }
        }
        if (OzoneSecurityUtil.isSecurityEnabled((Configuration)conf) && omStorage.getOmCertSerialId() == null) {
            LOG.info("OM storage is already initialized. Initializing security");
            OzoneManager.initializeSecurity(conf, omStorage);
            omStorage.persistCurrentState();
        }
        System.out.println("OM already initialized.Reusing existing cluster id for sd=" + omStorage.getStorageDir() + ";cid=" + omStorage.getClusterID());
        return true;
    }

    @VisibleForTesting
    public static void initializeSecurity(OzoneConfiguration conf, OMStorage omStore) throws IOException {
        LOG.info("Initializing secure OzoneManager.");
        OMCertificateClient certClient = new OMCertificateClient(new SecurityConfig((Configuration)conf), omStore.getOmCertSerialId());
        CertificateClient.InitResponse response = certClient.init();
        LOG.info("Init response: {}", (Object)response);
        switch (response) {
            case SUCCESS: {
                LOG.info("Initialization successful.");
                break;
            }
            case GETCERT: {
                OzoneManager.getSCMSignedCert((CertificateClient)certClient, conf, omStore);
                LOG.info("Successfully stored SCM signed certificate.");
                break;
            }
            case FAILURE: {
                LOG.error("OM security initialization failed.");
                throw new RuntimeException("OM security initialization failed.");
            }
            case RECOVER: {
                LOG.error("OM security initialization failed. OM certificate is missing.");
                throw new RuntimeException("OM security initialization failed.");
            }
            default: {
                LOG.error("OM security initialization failed. Init response: {}", (Object)response);
                throw new RuntimeException("OM security initialization failed.");
            }
        }
    }

    private static ScmInfo getScmInfo(OzoneConfiguration conf) throws IOException {
        try {
            RetryPolicy retryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)10, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            RetriableTask retriable = new RetriableTask(retryPolicy, "OM#getScmInfo", () -> OzoneManager.getScmBlockClient(conf).getScmInfo());
            return (ScmInfo)retriable.call();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to get SCM info", e);
        }
    }

    private static StartupOption parseArguments(String[] args) {
        if (args == null || args.length == 0) {
            return StartupOption.REGULAR;
        }
        if (args.length == 1) {
            return StartupOption.parse(args[0]);
        }
        return null;
    }

    private static String buildRpcServerStartMessage(String description, InetSocketAddress addr) {
        return addr != null ? String.format("%s is listening at %s", description, addr.toString()) : String.format("%s not started", description);
    }

    @VisibleForTesting
    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    @VisibleForTesting
    public ScmInfo getScmInfo() throws IOException {
        return this.scmBlockClient.getScmInfo();
    }

    @VisibleForTesting
    public OMStorage getOmStorage() {
        return this.omStorage;
    }

    @VisibleForTesting
    public OzoneManagerRatisServer getOmRatisServer() {
        return this.omRatisServer;
    }

    @VisibleForTesting
    public InetSocketAddress getOmRpcServerAddr() {
        return this.omRpcAddress;
    }

    @VisibleForTesting
    public LifeCycle.State getOmRatisServerState() {
        if (this.omRatisServer == null) {
            return null;
        }
        return this.omRatisServer.getServerState();
    }

    @VisibleForTesting
    public KeyProviderCryptoExtension getKmsProvider() {
        return this.kmsProvider;
    }

    public OMMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    public OMMetrics getMetrics() {
        return this.metrics;
    }

    public void start() throws IOException {
        LOG.info(OzoneManager.buildRpcServerStartMessage("OzoneManager RPC server", this.omRpcAddress));
        DefaultMetricsSystem.initialize((String)"OzoneManager");
        this.metadataManager.start(this.configuration);
        this.startSecretManagerIfNecessary();
        this.metrics.setNumVolumes(this.metadataManager.countRowsInTable(this.metadataManager.getVolumeTable()));
        this.metrics.setNumBuckets(this.metadataManager.countRowsInTable(this.metadataManager.getBucketTable()));
        if (this.getMetricsStorageFile().exists()) {
            OmMetricsInfo metricsInfo = (OmMetricsInfo)READER.readValue(this.getMetricsStorageFile());
            this.metrics.setNumKeys(metricsInfo.getNumKeys());
        }
        long period = this.configuration.getTimeDuration("ozone.om.save.metrics.interval", "5m", TimeUnit.MILLISECONDS);
        this.scheduleOMMetricsWriteTask = new ScheduleOMMetricsWriteTask();
        this.metricsTimer = new Timer();
        this.metricsTimer.schedule((TimerTask)this.scheduleOMMetricsWriteTask, 0L, period);
        this.keyManager.start(this.configuration);
        this.omRpcServer.start();
        this.isOmRpcServerRunning = true;
        try {
            this.httpServer = new OzoneManagerHttpServer((Configuration)this.configuration, this);
            this.httpServer.start();
        }
        catch (Exception ex) {
            LOG.error("OM HttpServer failed to start.", (Throwable)ex);
        }
        this.registerMXBean();
        this.setStartTime();
    }

    public void restart() throws IOException {
        LOG.info(OzoneManager.buildRpcServerStartMessage("OzoneManager RPC server", this.omRpcAddress));
        DefaultMetricsSystem.initialize((String)"OzoneManager");
        this.metadataManager.start(this.configuration);
        this.startSecretManagerIfNecessary();
        this.metrics.setNumVolumes(this.metadataManager.countRowsInTable(this.metadataManager.getVolumeTable()));
        this.metrics.setNumBuckets(this.metadataManager.countRowsInTable(this.metadataManager.getBucketTable()));
        if (this.getMetricsStorageFile().exists()) {
            OmMetricsInfo metricsInfo = (OmMetricsInfo)READER.readValue(this.getMetricsStorageFile());
            this.metrics.setNumKeys(metricsInfo.getNumKeys());
        }
        long period = this.configuration.getTimeDuration("ozone.om.save.metrics.interval", "5m", TimeUnit.MILLISECONDS);
        this.scheduleOMMetricsWriteTask = new ScheduleOMMetricsWriteTask();
        this.metricsTimer = new Timer();
        this.metricsTimer.schedule((TimerTask)this.scheduleOMMetricsWriteTask, 0L, period);
        this.keyManager.start(this.configuration);
        this.omRpcServer = this.getRpcServer(this.configuration);
        this.omRpcServer.start();
        this.isOmRpcServerRunning = true;
        this.startRatisServer();
        this.startRatisClient();
        try {
            this.httpServer = new OzoneManagerHttpServer((Configuration)this.configuration, this);
            this.httpServer.start();
        }
        catch (Exception ex) {
            LOG.error("OM HttpServer failed to start.", (Throwable)ex);
        }
        this.registerMXBean();
        this.jvmPauseMonitor = new JvmPauseMonitor();
        this.jvmPauseMonitor.init((Configuration)this.configuration);
        this.jvmPauseMonitor.start();
        this.setStartTime();
    }

    private RPC.Server getRpcServer(OzoneConfiguration conf) throws IOException {
        if (this.isOmRpcServerRunning) {
            return this.omRpcServer;
        }
        InetSocketAddress omNodeRpcAddr = OmUtils.getOmAddress((Configuration)this.configuration);
        int handlerCount = conf.getInt("ozone.om.handler.count.key", 20);
        RPC.setProtocolEngine((Configuration)this.configuration, OzoneManagerProtocolPB.class, ProtobufRpcEngine.class);
        BlockingService omService = OzoneManagerProtocolProtos.OzoneManagerService.newReflectiveBlockingService((OzoneManagerProtocolProtos.OzoneManagerService.BlockingInterface)new OzoneManagerProtocolServerSideTranslatorPB(this, this.omRatisClient, this.isRatisEnabled));
        return this.startRpcServer(this.configuration, omNodeRpcAddr, OzoneManagerProtocolPB.class, omService, handlerCount);
    }

    private void startRatisServer() throws IOException {
        this.isRatisEnabled = this.configuration.getBoolean("ozone.om.ratis.enable", false);
        if (this.isRatisEnabled) {
            if (this.omRatisServer == null) {
                this.omRatisServer = OzoneManagerRatisServer.newOMRatisServer((Configuration)this.configuration, this, this.omNodeDetails, this.peerNodes);
            }
            this.omRatisServer.start();
            LOG.info("OzoneManager Ratis server started at port {}", (Object)this.omRatisServer.getServerPort());
        } else {
            this.omRatisServer = null;
        }
    }

    private void startRatisClient() throws IOException {
        this.isRatisEnabled = this.configuration.getBoolean("ozone.om.ratis.enable", false);
        if (this.isRatisEnabled) {
            if (this.omRatisClient == null) {
                this.omRatisClient = OzoneManagerRatisClient.newOzoneManagerRatisClient(this.omNodeDetails.getOMNodeId(), this.omRatisServer.getRaftGroup(), (Configuration)this.configuration);
            }
            this.omRatisClient.connect();
        } else {
            this.omRatisClient = null;
        }
    }

    public void stop() {
        try {
            if (this.metricsTimer != null) {
                this.metricsTimer.cancel();
                this.metricsTimer = null;
                this.scheduleOMMetricsWriteTask = null;
            }
            this.omRpcServer.stop();
            if (this.omRatisServer != null) {
                this.omRatisServer.stop();
            }
            if (this.omRatisClient != null) {
                this.omRatisClient.close();
            }
            this.isOmRpcServerRunning = false;
            this.keyManager.stop();
            this.stopSecretManager();
            if (this.httpServer != null) {
                this.httpServer.stop();
            }
            this.metadataManager.stop();
            this.metrics.unRegister();
            this.unregisterMXBean();
            if (this.jvmPauseMonitor != null) {
                this.jvmPauseMonitor.stop();
            }
        }
        catch (Exception e) {
            LOG.error("OzoneManager stop failed.", (Throwable)e);
        }
    }

    public void join() {
        try {
            this.omRpcServer.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.info("Interrupted during OzoneManager join.", (Throwable)e);
        }
    }

    private void startSecretManagerIfNecessary() {
        boolean shouldRun = OzoneManager.isOzoneSecurityEnabled();
        if (shouldRun) {
            boolean running;
            boolean bl = running = this.delegationTokenMgr.isRunning() && this.blockTokenMgr.isRunning();
            if (!running) {
                this.startSecretManager();
            }
        }
    }

    private static void getSCMSignedCert(CertificateClient client, OzoneConfiguration config, OMStorage omStore) throws IOException {
        CertificateSignRequest.Builder builder = client.getCSRBuilder();
        KeyPair keyPair = new KeyPair(client.getPublicKey(), client.getPrivateKey());
        InetSocketAddress omRpcAdd = OmUtils.getOmAddress((Configuration)config);
        if (omRpcAdd == null || omRpcAdd.getAddress() == null) {
            LOG.error("Incorrect om rpc address. omRpcAdd:{}", (Object)omRpcAdd);
            throw new RuntimeException("Can't get SCM signed certificate. omRpcAdd: " + omRpcAdd);
        }
        String hostname = omRpcAdd.getAddress().getHostName();
        String ip = omRpcAdd.getAddress().getHostAddress();
        String subject = UserGroupInformation.getCurrentUser().getShortUserName() + "@" + hostname;
        builder.setCA(Boolean.valueOf(false)).setKey(keyPair).setConfiguration((Configuration)config).setScmID(omStore.getScmId()).setClusterID(omStore.getClusterID()).setSubject(subject).addIpAddress(ip);
        LOG.info("Creating csr for OM->dns:{},ip:{},scmId:{},clusterId:{},subject:{}", new Object[]{hostname, ip, omStore.getScmId(), omStore.getClusterID(), subject});
        HddsProtos.OzoneManagerDetailsProto.Builder omDetailsProtoBuilder = HddsProtos.OzoneManagerDetailsProto.newBuilder().setHostName(omRpcAdd.getHostName()).setIpAddress(ip).setUuid(omStore.getOmId()).addPorts(HddsProtos.Port.newBuilder().setName("RPC").setValue(omRpcAdd.getPort()).build());
        PKCS10CertificationRequest csr = builder.build();
        HddsProtos.OzoneManagerDetailsProto omDetailsProto = omDetailsProtoBuilder.build();
        LOG.info("OzoneManager ports added:{}", (Object)omDetailsProto.getPortsList());
        SCMSecurityProtocol secureScmClient = OzoneManager.getScmSecurityClient(config);
        String pemEncodedCert = secureScmClient.getOMCertificate(omDetailsProto, CertificateSignRequest.getEncodedString((PKCS10CertificationRequest)csr));
        try {
            client.storeCertificate(pemEncodedCert, true);
            omStore.setOmCertSerialId(CertificateCodec.getX509Certificate((String)pemEncodedCert).getSerialNumber().toString());
        }
        catch (IOException | CertificateException e) {
            LOG.error("Error while storing SCM signed certificate.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        UserGroupInformation.AuthenticationMethod authMethod = this.getConnectionAuthenticationMethod();
        return !UserGroupInformation.isSecurityEnabled() || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS || authMethod == UserGroupInformation.AuthenticationMethod.KERBEROS_SSL || authMethod == UserGroupInformation.AuthenticationMethod.CERTIFICATE;
    }

    private UserGroupInformation.AuthenticationMethod getConnectionAuthenticationMethod() throws IOException {
        UserGroupInformation ugi = OzoneManager.getRemoteUser();
        UserGroupInformation.AuthenticationMethod authMethod = ugi.getAuthenticationMethod();
        if (authMethod == UserGroupInformation.AuthenticationMethod.PROXY) {
            authMethod = ugi.getRealUser().getAuthenticationMethod();
        }
        return authMethod;
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        UserGroupInformation ugi = Server.getRemoteUser();
        return ugi != null ? ugi : UserGroupInformation.getCurrentUser();
    }

    public Token<OzoneTokenIdentifier> getDelegationToken(Text renewer) throws OMException {
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new OMException("Delegation Token can be issued only with kerberos or web authentication", OMException.ResultCodes.INVALID_AUTH_METHOD);
            }
            if (this.delegationTokenMgr == null || !this.delegationTokenMgr.isRunning()) {
                LOG.warn("trying to get DT with no secret manager running in OM.");
                return null;
            }
            UserGroupInformation ugi = OzoneManager.getRemoteUser();
            String user = ugi.getUserName();
            Text owner = new Text(user);
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            return this.delegationTokenMgr.createToken(owner, renewer, realUser);
        }
        catch (OMException oex) {
            throw oex;
        }
        catch (IOException ex) {
            LOG.error("Get Delegation token failed, cause: {}", (Object)ex.getMessage());
            throw new OMException("Get Delegation token failed.", (Throwable)ex, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    public long renewDelegationToken(Token<OzoneTokenIdentifier> token) throws OMException {
        long expiryTime;
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new OMException("Delegation Token can be renewed only with kerberos or web authentication", OMException.ResultCodes.INVALID_AUTH_METHOD);
            }
            String renewer = OzoneManager.getRemoteUser().getShortUserName();
            expiryTime = this.delegationTokenMgr.renewToken(token, renewer);
        }
        catch (OMException oex) {
            throw oex;
        }
        catch (IOException ex) {
            OzoneTokenIdentifier id = null;
            try {
                id = OzoneTokenIdentifier.readProtoBuf((byte[])token.getIdentifier());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOG.error("Delegation token renewal failed for dt id: {}, cause: {}", (Object)id, (Object)ex.getMessage());
            throw new OMException("Delegation token renewal failed for dt: " + token, (Throwable)ex, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
        return expiryTime;
    }

    public void cancelDelegationToken(Token<OzoneTokenIdentifier> token) throws OMException {
        OzoneTokenIdentifier id = null;
        try {
            String canceller = OzoneManager.getRemoteUser().getUserName();
            id = this.delegationTokenMgr.cancelToken(token, canceller);
            LOG.trace("Delegation token cancelled for dt: {}", (Object)id);
        }
        catch (OMException oex) {
            throw oex;
        }
        catch (IOException ex) {
            LOG.error("Delegation token cancellation failed for dt id: {}, cause: {}", id, (Object)ex.getMessage());
            throw new OMException("Delegation token renewal failed for dt: " + token, (Throwable)ex, OMException.ResultCodes.TOKEN_ERROR_OTHER);
        }
    }

    public void createVolume(OmVolumeArgs args) throws IOException {
        try {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.CREATE, args.getVolume(), null, null);
            }
            this.metrics.incNumVolumeCreates();
            this.volumeManager.createVolume(args);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CREATE_VOLUME, args == null ? null : args.toAuditMap()));
            this.metrics.incNumVolumes();
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeCreateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.CREATE_VOLUME, args == null ? null : args.toAuditMap(), ex));
            throw ex;
        }
    }

    private void checkAcls(OzoneObj.ResourceType resType, OzoneObj.StoreType store, IAccessAuthorizer.ACLType acl, String vol, String bucket, String key) throws OzoneAclException {
        if (!this.isAclEnabled) {
            return;
        }
        OzoneObjInfo obj = OzoneObjInfo.Builder.newBuilder().setResType(resType).setStoreType(store).setVolumeName(vol).setBucketName(bucket).setKeyName(key).build();
        UserGroupInformation user = ProtobufRpcEngine.Server.getRemoteUser();
        RequestContext context = RequestContext.newBuilder().setClientUgi(user).setIp(ProtobufRpcEngine.Server.getRemoteIp()).setAclType(IAccessAuthorizer.ACLIdentityType.USER).setAclRights(acl).build();
        if (!this.accessAuthorizer.checkAccess((IOzoneObj)obj, context)) {
            LOG.warn("User {} doesn't have {} permission to access {}", new Object[]{user.getUserName(), acl, resType});
            throw new OzoneAclException("User " + user.getUserName() + " doesn't have " + acl + " permission to access " + resType, OzoneAclException.ErrorCode.PERMISSION_DENIED);
        }
    }

    public void setOwner(String volume, String owner) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE_ACL, volume, null, null);
        }
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("owner", owner);
        try {
            this.metrics.incNumVolumeUpdates();
            this.volumeManager.setOwner(volume, owner);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.SET_OWNER, auditMap));
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeUpdateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.SET_OWNER, auditMap, ex));
            throw ex;
        }
    }

    public void setQuota(String volume, long quota) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volume, null, null);
        }
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("quota", String.valueOf(quota));
        try {
            this.metrics.incNumVolumeUpdates();
            this.volumeManager.setQuota(volume, quota);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.SET_QUOTA, auditMap));
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeUpdateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.SET_QUOTA, auditMap, ex));
            throw ex;
        }
    }

    public boolean checkVolumeAccess(String volume, OzoneManagerProtocolProtos.OzoneAclInfo userAcl) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, volume, null, null);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("userAcl", userAcl == null ? null : userAcl.getName());
        try {
            this.metrics.incNumVolumeCheckAccesses();
            boolean bl = this.volumeManager.checkVolumeAccess(volume, userAcl);
            return bl;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeCheckAccessFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.CHECK_VOLUME_ACCESS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CHECK_VOLUME_ACCESS, auditMap));
            }
        }
    }

    public OmVolumeArgs getVolumeInfo(String volume) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, volume, null, null);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volume);
        try {
            this.metrics.incNumVolumeInfos();
            OmVolumeArgs omVolumeArgs = this.volumeManager.getVolumeInfo(volume);
            return omVolumeArgs;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeInfoFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.READ_VOLUME, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.READ_VOLUME, auditMap));
            }
        }
    }

    public void deleteVolume(String volume) throws IOException {
        try {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.DELETE, volume, null, null);
            }
            this.metrics.incNumVolumeDeletes();
            this.volumeManager.deleteVolume(volume);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.DELETE_VOLUME, this.buildAuditMap(volume)));
            this.metrics.decNumVolumes();
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeDeleteFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.DELETE_VOLUME, this.buildAuditMap(volume), ex));
            throw ex;
        }
    }

    public List<OmVolumeArgs> listVolumeByUser(String userName, String prefix, String prevKey, int maxKeys) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, prefix, null, null);
        }
        boolean auditSuccess = true;
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("prevKey", prevKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        auditMap.put("username", userName);
        try {
            this.metrics.incNumVolumeLists();
            List<OmVolumeArgs> list = this.volumeManager.listVolumes(userName, prefix, prevKey, maxKeys);
            return list;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_VOLUMES, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_VOLUMES, auditMap));
            }
        }
    }

    public List<OmVolumeArgs> listAllVolumes(String prefix, String prevKey, int maxKeys) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, prefix, null, null);
        }
        boolean auditSuccess = true;
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("prevKey", prevKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        auditMap.put("username", null);
        try {
            this.metrics.incNumVolumeLists();
            List<OmVolumeArgs> list = this.volumeManager.listVolumes(null, prefix, prevKey, maxKeys);
            return list;
        }
        catch (Exception ex) {
            this.metrics.incNumVolumeListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_VOLUMES, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_VOLUMES, auditMap));
            }
        }
    }

    public void createBucket(OmBucketInfo bucketInfo) throws IOException {
        try {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.CREATE, bucketInfo.getVolumeName(), bucketInfo.getBucketName(), null);
            }
            this.metrics.incNumBucketCreates();
            this.bucketManager.createBucket(bucketInfo);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.CREATE_BUCKET, bucketInfo == null ? null : bucketInfo.toAuditMap()));
            this.metrics.incNumBuckets();
        }
        catch (Exception ex) {
            this.metrics.incNumBucketCreateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.CREATE_BUCKET, bucketInfo == null ? null : bucketInfo.toAuditMap(), ex));
            throw ex;
        }
    }

    public List<OmBucketInfo> listBuckets(String volumeName, String startKey, String prefix, int maxNumOfBuckets) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, volumeName, null, null);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volumeName);
        auditMap.put("startKey", startKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxNumOfBuckets", String.valueOf(maxNumOfBuckets));
        try {
            this.metrics.incNumBucketLists();
            List<OmBucketInfo> list = this.bucketManager.listBuckets(volumeName, startKey, prefix, maxNumOfBuckets);
            return list;
        }
        catch (IOException ex) {
            this.metrics.incNumBucketListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_BUCKETS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_BUCKETS, auditMap));
            }
        }
    }

    public OmBucketInfo getBucketInfo(String volume, String bucket) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, volume, bucket, null);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("bucket", bucket);
        try {
            this.metrics.incNumBucketInfos();
            OmBucketInfo omBucketInfo = this.bucketManager.getBucketInfo(volume, bucket);
            return omBucketInfo;
        }
        catch (Exception ex) {
            this.metrics.incNumBucketInfoFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.READ_BUCKET, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.READ_BUCKET, auditMap));
            }
        }
    }

    public OpenKeySession openKey(OmKeyArgs args) throws IOException {
        OpenKeySession openKeySession;
        block6: {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, args.getVolumeName(), args.getBucketName(), args.getKeyName());
            }
            boolean auditSuccess = true;
            try {
                this.metrics.incNumKeyAllocates();
                openKeySession = this.keyManager.openKey(args);
                if (!auditSuccess) break block6;
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.ALLOCATE_KEY, args == null ? null : args.toAuditMap()));
            }
            catch (Exception ex) {
                try {
                    this.metrics.incNumKeyAllocateFails();
                    auditSuccess = false;
                    AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.ALLOCATE_KEY, args == null ? null : args.toAuditMap(), ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (auditSuccess) {
                        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.ALLOCATE_KEY, args == null ? null : args.toAuditMap()));
                    }
                    throw throwable;
                }
            }
        }
        return openKeySession;
    }

    public void commitKey(OmKeyArgs args, long clientID) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, args.getVolumeName(), args.getBucketName(), args.getKeyName());
        }
        Map<String, String> auditMap = args == null ? new LinkedHashMap() : args.toAuditMap();
        auditMap.put("clientID", String.valueOf(clientID));
        try {
            this.metrics.incNumKeyCommits();
            this.keyManager.commitKey(args, clientID);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.COMMIT_KEY, auditMap));
            if (args != null && args.getLocationInfoList() != null && args.getLocationInfoList().size() > 0 && args.getLocationInfoList().get(0) != null && ((OmKeyLocationInfo)args.getLocationInfoList().get(0)).getCreateVersion() == 0L) {
                this.metrics.incNumKeys();
            }
        }
        catch (Exception ex) {
            this.metrics.incNumKeyCommitFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.COMMIT_KEY, auditMap, ex));
            throw ex;
        }
    }

    public OmKeyLocationInfo allocateBlock(OmKeyArgs args, long clientID, ExcludeList excludeList) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, args.getVolumeName(), args.getBucketName(), args.getKeyName());
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = args == null ? new LinkedHashMap() : args.toAuditMap();
        auditMap.put("clientID", String.valueOf(clientID));
        try {
            this.metrics.incNumBlockAllocateCalls();
            OmKeyLocationInfo omKeyLocationInfo = this.keyManager.allocateBlock(args, clientID, excludeList);
            return omKeyLocationInfo;
        }
        catch (Exception ex) {
            this.metrics.incNumBlockAllocateCallFails();
            auditSuccess = false;
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.ALLOCATE_BLOCK, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.ALLOCATE_BLOCK, auditMap));
            }
        }
    }

    public OmKeyInfo lookupKey(OmKeyArgs args) throws IOException {
        OmKeyInfo omKeyInfo;
        block6: {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.READ, args.getVolumeName(), args.getBucketName(), args.getKeyName());
            }
            boolean auditSuccess = true;
            try {
                this.metrics.incNumKeyLookups();
                omKeyInfo = this.keyManager.lookupKey(args);
                if (!auditSuccess) break block6;
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.READ_KEY, args == null ? null : args.toAuditMap()));
            }
            catch (Exception ex) {
                try {
                    this.metrics.incNumKeyLookupFails();
                    auditSuccess = false;
                    AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.READ_KEY, args == null ? null : args.toAuditMap(), ex));
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (auditSuccess) {
                        AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.READ_KEY, args == null ? null : args.toAuditMap()));
                    }
                    throw throwable;
                }
            }
        }
        return omKeyInfo;
    }

    public void renameKey(OmKeyArgs args, String toKeyName) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, args.getVolumeName(), args.getBucketName(), args.getKeyName());
        }
        Map<String, String> auditMap = args == null ? new LinkedHashMap() : args.toAuditMap();
        auditMap.put("toKeyName", toKeyName);
        try {
            this.metrics.incNumKeyRenames();
            this.keyManager.renameKey(args, toKeyName);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.RENAME_KEY, auditMap));
        }
        catch (IOException e) {
            this.metrics.incNumKeyRenameFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.RENAME_KEY, auditMap, e));
            throw e;
        }
    }

    public void deleteKey(OmKeyArgs args) throws IOException {
        try {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.DELETE, args.getVolumeName(), args.getBucketName(), args.getKeyName());
            }
            this.metrics.incNumKeyDeletes();
            this.keyManager.deleteKey(args);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.DELETE_KEY, args == null ? null : args.toAuditMap()));
            this.metrics.decNumKeys();
        }
        catch (Exception ex) {
            this.metrics.incNumKeyDeleteFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.DELETE_KEY, args == null ? null : args.toAuditMap(), ex));
            throw ex;
        }
    }

    public List<OmKeyInfo> listKeys(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.LIST, volumeName, bucketName, keyPrefix);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(volumeName);
        auditMap.put("bucket", bucketName);
        auditMap.put("startKey", startKey);
        auditMap.put("maxKeys", String.valueOf(maxKeys));
        auditMap.put("keyPrefix", keyPrefix);
        try {
            this.metrics.incNumKeyLists();
            List<OmKeyInfo> list = this.keyManager.listKeys(volumeName, bucketName, startKey, keyPrefix, maxKeys);
            return list;
        }
        catch (IOException ex) {
            this.metrics.incNumKeyListFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_KEYS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_KEYS, auditMap));
            }
        }
    }

    public void setBucketProperty(OmBucketArgs args) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, args.getVolumeName(), args.getBucketName(), null);
        }
        try {
            this.metrics.incNumBucketUpdates();
            this.bucketManager.setBucketProperty(args);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.UPDATE_BUCKET, args == null ? null : args.toAuditMap()));
        }
        catch (Exception ex) {
            this.metrics.incNumBucketUpdateFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.UPDATE_BUCKET, args == null ? null : args.toAuditMap(), ex));
            throw ex;
        }
    }

    public void deleteBucket(String volume, String bucket) throws IOException {
        this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volume, bucket, null);
        Map<String, String> auditMap = this.buildAuditMap(volume);
        auditMap.put("bucket", bucket);
        try {
            this.metrics.incNumBucketDeletes();
            this.bucketManager.deleteBucket(volume, bucket);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.DELETE_BUCKET, auditMap));
            this.metrics.decNumBuckets();
        }
        catch (Exception ex) {
            this.metrics.incNumBucketDeleteFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.DELETE_BUCKET, auditMap, ex));
            throw ex;
        }
    }

    private Map<String, String> buildAuditMap(String volume) {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", volume);
        return auditMap;
    }

    public AuditMessage buildAuditMessageForSuccess(AuditAction op, Map<String, String> auditMap) {
        return new AuditMessage.Builder().setUser(Server.getRemoteUser() == null ? null : Server.getRemoteUser().getUserName()).atIp(Server.getRemoteIp() == null ? null : Server.getRemoteIp().getHostAddress()).forOperation(op.getAction()).withParams(auditMap).withResult(AuditEventStatus.SUCCESS.toString()).withException(null).build();
    }

    public AuditMessage buildAuditMessageForFailure(AuditAction op, Map<String, String> auditMap, Throwable throwable) {
        return new AuditMessage.Builder().setUser(Server.getRemoteUser() == null ? null : Server.getRemoteUser().getUserName()).atIp(Server.getRemoteIp() == null ? null : Server.getRemoteIp().getHostAddress()).forOperation(op.getAction()).withParams(auditMap).withResult(AuditEventStatus.FAILURE.toString()).withException(throwable).build();
    }

    private void registerMXBean() {
        HashMap<String, String> jmxProperties = new HashMap<String, String>();
        jmxProperties.put("component", "ServerRuntime");
        this.omInfoBeanName = HddsUtils.registerWithJmxProperties((String)"OzoneManager", (String)"OzoneManagerInfo", jmxProperties, (Object)this);
    }

    private void unregisterMXBean() {
        if (this.omInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.omInfoBeanName);
            this.omInfoBeanName = null;
        }
    }

    @Override
    public String getRpcPort() {
        return "" + this.omRpcAddress.getPort();
    }

    @VisibleForTesting
    public OzoneManagerHttpServer getHttpServer() {
        return this.httpServer;
    }

    public List<ServiceInfo> getServiceList() throws IOException {
        ArrayList<ServiceInfo> services = new ArrayList<ServiceInfo>();
        ServiceInfo.Builder omServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.OM).setHostname(this.omRpcAddress.getHostName()).addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RPC).setValue(this.omRpcAddress.getPort()).build());
        if (this.httpServer.getHttpAddress() != null) {
            omServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.HTTP).setValue(this.httpServer.getHttpAddress().getPort()).build());
        }
        if (this.httpServer.getHttpsAddress() != null) {
            omServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.HTTPS).setValue(this.httpServer.getHttpsAddress().getPort()).build());
        }
        services.add(omServiceInfoBuilder.build());
        InetSocketAddress scmAddr = HddsUtils.getScmAddressForClients((Configuration)this.configuration);
        ServiceInfo.Builder scmServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.SCM).setHostname(scmAddr.getHostName()).addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.RPC).setValue(scmAddr.getPort()).build());
        services.add(scmServiceInfoBuilder.build());
        List nodes = this.scmContainerClient.queryNode(HddsProtos.NodeState.HEALTHY, HddsProtos.QueryScope.CLUSTER, "");
        for (HddsProtos.Node node : nodes) {
            HddsProtos.DatanodeDetailsProto datanode = node.getNodeID();
            ServiceInfo.Builder dnServiceInfoBuilder = ServiceInfo.newBuilder().setNodeType(HddsProtos.NodeType.DATANODE).setHostname(datanode.getHostName());
            if (DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)datanode).getPort(DatanodeDetails.Port.Name.REST) != null) {
                dnServiceInfoBuilder.addServicePort(OzoneManagerProtocolProtos.ServicePort.newBuilder().setType(OzoneManagerProtocolProtos.ServicePort.Type.HTTP).setValue(DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)datanode).getPort(DatanodeDetails.Port.Name.REST).getValue().intValue()).build());
            }
            services.add(dnServiceInfoBuilder.build());
        }
        this.metrics.incNumGetServiceLists();
        return services;
    }

    public void createS3Bucket(String userName, String s3BucketName) throws IOException {
        try {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.S3, IAccessAuthorizer.ACLType.CREATE, null, s3BucketName, null);
            }
            this.metrics.incNumBucketCreates();
            try {
                boolean newVolumeCreate = this.s3BucketManager.createOzoneVolumeIfNeeded(userName);
                if (newVolumeCreate) {
                    this.metrics.incNumVolumeCreates();
                    this.metrics.incNumVolumes();
                }
            }
            catch (IOException ex) {
                this.metrics.incNumVolumeCreates();
                this.metrics.incNumVolumeCreateFails();
                throw ex;
            }
            this.s3BucketManager.createS3Bucket(userName, s3BucketName);
            this.metrics.incNumBuckets();
        }
        catch (IOException ex) {
            this.metrics.incNumBucketCreateFails();
            throw ex;
        }
    }

    public void deleteS3Bucket(String s3BucketName) throws IOException {
        try {
            if (this.isAclEnabled) {
                this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.S3, IAccessAuthorizer.ACLType.DELETE, null, s3BucketName, null);
            }
            this.metrics.incNumBucketDeletes();
            this.s3BucketManager.deleteS3Bucket(s3BucketName);
            this.metrics.decNumBuckets();
        }
        catch (IOException ex) {
            this.metrics.incNumBucketDeleteFails();
        }
    }

    public S3SecretValue getS3Secret(String kerberosID) throws IOException {
        return this.s3SecretManager.getS3Secret(kerberosID);
    }

    public String getOzoneBucketMapping(String s3BucketName) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.S3, IAccessAuthorizer.ACLType.READ, null, s3BucketName, null);
        }
        return this.s3BucketManager.getOzoneBucketMapping(s3BucketName);
    }

    public List<OmBucketInfo> listS3Buckets(String userName, String startKey, String prefix, int maxNumOfBuckets) throws IOException {
        if (this.isAclEnabled) {
            this.checkAcls(OzoneObj.ResourceType.VOLUME, OzoneObj.StoreType.S3, IAccessAuthorizer.ACLType.LIST, this.s3BucketManager.getOzoneVolumeNameForUser(userName), null, null);
        }
        boolean auditSuccess = true;
        Map<String, String> auditMap = this.buildAuditMap(userName);
        auditMap.put("startKey", startKey);
        auditMap.put("prefix", prefix);
        auditMap.put("maxNumOfBuckets", String.valueOf(maxNumOfBuckets));
        try {
            this.metrics.incNumListS3Buckets();
            String volumeName = this.s3BucketManager.getOzoneVolumeNameForUser(userName);
            List<OmBucketInfo> list = this.bucketManager.listBuckets(volumeName, startKey, prefix, maxNumOfBuckets);
            return list;
        }
        catch (IOException ex) {
            this.metrics.incNumListS3BucketsFails();
            auditSuccess = false;
            AUDIT.logReadFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_S3BUCKETS, auditMap, ex));
            throw ex;
        }
        finally {
            if (auditSuccess) {
                AUDIT.logReadSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_S3BUCKETS, auditMap));
            }
        }
    }

    public OmMultipartInfo initiateMultipartUpload(OmKeyArgs keyArgs) throws IOException {
        OmMultipartInfo multipartInfo;
        this.metrics.incNumInitiateMultipartUploads();
        try {
            multipartInfo = this.keyManager.initiateMultipartUpload(keyArgs);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.INITIATE_MULTIPART_UPLOAD, keyArgs == null ? null : keyArgs.toAuditMap()));
        }
        catch (IOException ex) {
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.INITIATE_MULTIPART_UPLOAD, keyArgs == null ? null : keyArgs.toAuditMap(), ex));
            this.metrics.incNumInitiateMultipartUploadFails();
            throw ex;
        }
        return multipartInfo;
    }

    public OmMultipartCommitUploadPartInfo commitMultipartUploadPart(OmKeyArgs keyArgs, long clientID) throws IOException {
        OmMultipartCommitUploadPartInfo commitUploadPartInfo;
        block5: {
            boolean auditSuccess = false;
            this.metrics.incNumCommitMultipartUploadParts();
            try {
                commitUploadPartInfo = this.keyManager.commitMultipartUploadPart(keyArgs, clientID);
                auditSuccess = true;
                if (!auditSuccess) break block5;
                AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.COMMIT_MULTIPART_UPLOAD_PARTKEY, keyArgs == null ? null : keyArgs.toAuditMap()));
            }
            catch (IOException ex) {
                try {
                    AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.INITIATE_MULTIPART_UPLOAD, keyArgs == null ? null : keyArgs.toAuditMap(), ex));
                    this.metrics.incNumCommitMultipartUploadPartFails();
                    throw ex;
                }
                catch (Throwable throwable) {
                    if (auditSuccess) {
                        AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.COMMIT_MULTIPART_UPLOAD_PARTKEY, keyArgs == null ? null : keyArgs.toAuditMap()));
                    }
                    throw throwable;
                }
            }
        }
        return commitUploadPartInfo;
    }

    public OmMultipartUploadCompleteInfo completeMultipartUpload(OmKeyArgs omKeyArgs, OmMultipartUploadList multipartUploadList) throws IOException {
        this.metrics.incNumCompleteMultipartUploads();
        Map<String, String> auditMap = omKeyArgs == null ? new LinkedHashMap() : omKeyArgs.toAuditMap();
        auditMap.put("multipartList", multipartUploadList.getMultipartMap().toString());
        try {
            OmMultipartUploadCompleteInfo omMultipartUploadCompleteInfo = this.keyManager.completeMultipartUpload(omKeyArgs, multipartUploadList);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.COMPLETE_MULTIPART_UPLOAD, auditMap));
            return omMultipartUploadCompleteInfo;
        }
        catch (IOException ex) {
            this.metrics.incNumCompleteMultipartUploadFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.COMPLETE_MULTIPART_UPLOAD, auditMap, ex));
            throw ex;
        }
    }

    public void abortMultipartUpload(OmKeyArgs omKeyArgs) throws IOException {
        LinkedHashMap<String, String> auditMap = omKeyArgs == null ? new LinkedHashMap() : omKeyArgs.toAuditMap();
        this.metrics.incNumAbortMultipartUploads();
        try {
            this.keyManager.abortMultipartUpload(omKeyArgs);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.COMPLETE_MULTIPART_UPLOAD, auditMap));
        }
        catch (IOException ex) {
            this.metrics.incNumAbortMultipartUploadFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.COMPLETE_MULTIPART_UPLOAD, auditMap, ex));
            throw ex;
        }
    }

    public OmMultipartUploadListParts listParts(String volumeName, String bucketName, String keyName, String uploadID, int partNumberMarker, int maxParts) throws IOException {
        HashMap<String, String> auditMap = new HashMap<String, String>();
        auditMap.put("volume", volumeName);
        auditMap.put("bucket", bucketName);
        auditMap.put("key", keyName);
        auditMap.put("uploadID", uploadID);
        auditMap.put("partNumberMarker", Integer.toString(partNumberMarker));
        auditMap.put("maxParts", Integer.toString(maxParts));
        this.metrics.incNumListMultipartUploadParts();
        try {
            OmMultipartUploadListParts omMultipartUploadListParts = this.keyManager.listParts(volumeName, bucketName, keyName, uploadID, partNumberMarker, maxParts);
            AUDIT.logWriteSuccess(this.buildAuditMessageForSuccess((AuditAction)OMAction.LIST_MULTIPART_UPLOAD_PARTS, auditMap));
            return omMultipartUploadListParts;
        }
        catch (IOException ex) {
            this.metrics.incNumAbortMultipartUploadFails();
            AUDIT.logWriteFailure(this.buildAuditMessageForFailure((AuditAction)OMAction.LIST_MULTIPART_UPLOAD_PARTS, auditMap, ex));
            throw ex;
        }
    }

    public static Logger getLogger() {
        return LOG;
    }

    public OzoneConfiguration getConfiguration() {
        return this.configuration;
    }

    public static void setTestSecureOmFlag(boolean testSecureOmFlag) {
        OzoneManager.testSecureOmFlag = testSecureOmFlag;
    }

    public String getOMNodId() {
        return this.omNodeDetails.getOMNodeId();
    }

    public String getOMServiceId() {
        return this.omNodeDetails.getOMServiceId();
    }

    @VisibleForTesting
    public List<OMNodeDetails> getPeerNodes() {
        return this.peerNodes;
    }

    @VisibleForTesting
    public CertificateClient getCertificateClient() {
        return this.certClient;
    }

    public String getComponent() {
        return this.omComponent;
    }

    public OMFailoverProxyProvider getOMFailoverProxyProvider() {
        return null;
    }

    public static enum StartupOption {
        INIT("--init"),
        HELP("--help"),
        REGULAR("--regular");

        private final String name;

        private StartupOption(String arg) {
            this.name = arg;
        }

        public static StartupOption parse(String value) {
            for (StartupOption option : StartupOption.values()) {
                if (!option.name.equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }
    }

    private class ScheduleOMMetricsWriteTask
    extends TimerTask {
        private ScheduleOMMetricsWriteTask() {
        }

        @Override
        public void run() {
            OzoneManager.this.saveOmMetrics();
        }
    }
}

