/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.ozone.om.BucketManager;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.S3BucketManager;
import org.apache.hadoop.ozone.om.VolumeManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3BucketManagerImpl
implements S3BucketManager {
    private static final Logger LOG = LoggerFactory.getLogger(S3BucketManagerImpl.class);
    private static final String S3_ADMIN_NAME = "OzoneS3Manager";
    private final OzoneConfiguration configuration;
    private final OMMetadataManager omMetadataManager;
    private final VolumeManager volumeManager;
    private final BucketManager bucketManager;

    public S3BucketManagerImpl(OzoneConfiguration configuration, OMMetadataManager omMetadataManager, VolumeManager volumeManager, BucketManager bucketManager) {
        this.configuration = configuration;
        this.omMetadataManager = omMetadataManager;
        this.volumeManager = volumeManager;
        this.bucketManager = bucketManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createS3Bucket(String userName, String bucketName) throws IOException {
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)bucketName), (Object)"Bucket name cannot be null or empty.");
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)userName), (Object)"User name cannot be null or empty.");
        Preconditions.checkArgument((bucketName.length() >= 3 && bucketName.length() < 64 ? 1 : 0) != 0, (Object)"Length of the S3 Bucket is not correct.");
        String ozoneVolumeName = this.formatOzoneVolumeName(userName);
        this.omMetadataManager.getLock().acquireS3Lock(bucketName);
        try {
            byte[] bucket = (byte[])this.omMetadataManager.getS3Table().get((Object)bucketName.getBytes(StandardCharsets.UTF_8));
            if (bucket != null) {
                LOG.debug("Bucket already exists. {}", (Object)bucketName);
                throw new OMException("Unable to create S3 bucket. " + bucketName + " already exists.", OMException.ResultCodes.S3_BUCKET_ALREADY_EXISTS);
            }
            String ozoneBucketName = bucketName;
            this.createOzoneBucket(ozoneVolumeName, ozoneBucketName);
            String finalName = String.format("%s/%s", ozoneVolumeName, ozoneBucketName);
            this.omMetadataManager.getS3Table().put((Object)bucketName.getBytes(StandardCharsets.UTF_8), (Object)finalName.getBytes(StandardCharsets.UTF_8));
        }
        finally {
            this.omMetadataManager.getLock().releaseS3Lock(bucketName);
        }
    }

    @Override
    public void deleteS3Bucket(String bucketName) throws IOException {
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)bucketName), (Object)"Bucket name cannot be null or empty");
        this.omMetadataManager.getLock().acquireS3Lock(bucketName);
        try {
            byte[] bucket = bucketName.getBytes(StandardCharsets.UTF_8);
            byte[] map = (byte[])this.omMetadataManager.getS3Table().get((Object)bucket);
            if (map == null) {
                throw new OMException("No such S3 bucket. " + bucketName, OMException.ResultCodes.S3_BUCKET_NOT_FOUND);
            }
            this.bucketManager.deleteBucket(this.getOzoneVolumeName(bucketName), bucketName);
            this.omMetadataManager.getS3Table().delete((Object)bucket);
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            this.omMetadataManager.getLock().releaseS3Lock(bucketName);
        }
    }

    private String formatOzoneVolumeName(String userName) {
        return String.format("s3%s", userName);
    }

    @Override
    public boolean createOzoneVolumeIfNeeded(String userName) throws IOException {
        boolean newVolumeCreate = true;
        String ozoneVolumeName = this.formatOzoneVolumeName(userName);
        try {
            OmVolumeArgs args = OmVolumeArgs.newBuilder().setAdminName(S3_ADMIN_NAME).setOwnerName(userName).setVolume(ozoneVolumeName).setQuotaInBytes(0x1000000000000000L).build();
            this.volumeManager.createVolume(args);
        }
        catch (OMException exp) {
            newVolumeCreate = false;
            if (exp.getResult().compareTo((Enum)OMException.ResultCodes.VOLUME_ALREADY_EXISTS) == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Volume already exists. {}", (Object)exp.getMessage());
                }
            }
            throw exp;
        }
        return newVolumeCreate;
    }

    private void createOzoneBucket(String volumeName, String bucketName) throws IOException {
        OmBucketInfo.Builder builder = OmBucketInfo.newBuilder();
        OmBucketInfo bucketInfo = builder.setVolumeName(volumeName).setBucketName(bucketName).setIsVersionEnabled(Boolean.FALSE).setStorageType(StorageType.DEFAULT).build();
        this.bucketManager.createBucket(bucketInfo);
    }

    @Override
    public String getOzoneBucketMapping(String s3BucketName) throws IOException {
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)s3BucketName), (Object)"Bucket name cannot be null or empty.");
        Preconditions.checkArgument((s3BucketName.length() >= 3 && s3BucketName.length() < 64 ? 1 : 0) != 0, (Object)"Length of the S3 Bucket is not correct.");
        this.omMetadataManager.getLock().acquireS3Lock(s3BucketName);
        try {
            byte[] mapping = (byte[])this.omMetadataManager.getS3Table().get((Object)s3BucketName.getBytes(StandardCharsets.UTF_8));
            if (mapping != null) {
                String string = new String(mapping, StandardCharsets.UTF_8);
                return string;
            }
            throw new OMException("No such S3 bucket.", OMException.ResultCodes.S3_BUCKET_NOT_FOUND);
        }
        finally {
            this.omMetadataManager.getLock().releaseS3Lock(s3BucketName);
        }
    }

    @Override
    public String getOzoneVolumeName(String s3BucketName) throws IOException {
        String mapping = this.getOzoneBucketMapping(s3BucketName);
        return mapping.split("/")[0];
    }

    @Override
    public String getOzoneBucketName(String s3BucketName) throws IOException {
        String mapping = this.getOzoneBucketMapping(s3BucketName);
        return mapping.split("/")[1];
    }

    @Override
    public String getOzoneVolumeNameForUser(String userName) throws IOException {
        Objects.requireNonNull(userName, "UserName cannot be null");
        return this.formatOzoneVolumeName(userName);
    }
}

