/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.VolumeManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.utils.RocksDBStore;
import org.apache.hadoop.utils.db.BatchOperation;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeManagerImpl
implements VolumeManager {
    private static final Logger LOG = LoggerFactory.getLogger(VolumeManagerImpl.class);
    private final OMMetadataManager metadataManager;
    private final int maxUserVolumeCount;

    public VolumeManagerImpl(OMMetadataManager metadataManager, OzoneConfiguration conf) throws IOException {
        this.metadataManager = metadataManager;
        this.maxUserVolumeCount = conf.getInt("ozone.om.user.max.volume", 1024);
    }

    private void addVolumeToOwnerList(String volume, String owner, BatchOperation batchOperation) throws IOException {
        String dbUserKey = this.metadataManager.getUserKey(owner);
        OzoneManagerProtocolProtos.VolumeList volumeList = (OzoneManagerProtocolProtos.VolumeList)this.metadataManager.getUserTable().get((Object)dbUserKey);
        ArrayList<String> prevVolList = new ArrayList<String>();
        if (volumeList != null) {
            prevVolList.addAll(volumeList.getVolumeNamesList());
        }
        if (prevVolList.size() >= this.maxUserVolumeCount) {
            LOG.debug("Too many volumes for user:{}", (Object)owner);
            throw new OMException(OMException.ResultCodes.USER_TOO_MANY_VOLUMES);
        }
        prevVolList.add(volume);
        OzoneManagerProtocolProtos.VolumeList newVolList = OzoneManagerProtocolProtos.VolumeList.newBuilder().addAllVolumeNames(prevVolList).build();
        this.metadataManager.getUserTable().putWithBatch(batchOperation, (Object)dbUserKey, (Object)newVolList);
    }

    private void delVolumeFromOwnerList(String volume, String owner, BatchOperation batch) throws RocksDBException, IOException {
        String dbUserKey = this.metadataManager.getUserKey(owner);
        OzoneManagerProtocolProtos.VolumeList volumeList = (OzoneManagerProtocolProtos.VolumeList)this.metadataManager.getUserTable().get((Object)dbUserKey);
        ArrayList prevVolList = new ArrayList();
        if (volumeList == null) {
            LOG.debug("volume:{} not found for user:{}");
            throw new OMException(OMException.ResultCodes.USER_NOT_FOUND);
        }
        prevVolList.addAll(volumeList.getVolumeNamesList());
        prevVolList.remove(volume);
        if (prevVolList.size() == 0) {
            this.metadataManager.getUserTable().deleteWithBatch(batch, (Object)dbUserKey);
        } else {
            OzoneManagerProtocolProtos.VolumeList newVolList = OzoneManagerProtocolProtos.VolumeList.newBuilder().addAllVolumeNames(prevVolList).build();
            this.metadataManager.getUserTable().putWithBatch(batch, (Object)dbUserKey, (Object)newVolList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createVolume(OmVolumeArgs args) throws IOException {
        block20: {
            Preconditions.checkNotNull((Object)args);
            this.metadataManager.getLock().acquireUserLock(args.getOwnerName());
            this.metadataManager.getLock().acquireVolumeLock(args.getVolume());
            try {
                String dbVolumeKey = this.metadataManager.getVolumeKey(args.getVolume());
                OmVolumeArgs volumeInfo = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
                if (volumeInfo != null) {
                    LOG.debug("volume:{} already exists", (Object)args.getVolume());
                    throw new OMException(OMException.ResultCodes.VOLUME_ALREADY_EXISTS);
                }
                try (BatchOperation batch = this.metadataManager.getStore().initBatchOperation();){
                    this.metadataManager.getVolumeTable().putWithBatch(batch, (Object)dbVolumeKey, (Object)args);
                    this.addVolumeToOwnerList(args.getVolume(), args.getOwnerName(), batch);
                    this.metadataManager.getStore().commitBatchOperation(batch);
                }
                LOG.debug("created volume:{} user:{}", (Object)args.getVolume(), (Object)args.getOwnerName());
            }
            catch (IOException ex) {
                if (!(ex instanceof OMException)) {
                    LOG.error("Volume creation failed for user:{} volume:{}", new Object[]{args.getOwnerName(), args.getVolume(), ex});
                    break block20;
                }
                throw ex;
            }
            finally {
                this.metadataManager.getLock().releaseVolumeLock(args.getVolume());
                this.metadataManager.getLock().releaseUserLock(args.getOwnerName());
            }
        }
    }

    @Override
    public void setOwner(String volume, String owner) throws IOException {
        Preconditions.checkNotNull((Object)volume);
        Preconditions.checkNotNull((Object)owner);
        this.metadataManager.getLock().acquireUserLock(owner);
        this.metadataManager.getLock().acquireVolumeLock(volume);
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("Changing volume ownership failed for user:{} volume:{}", (Object)owner, (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
            try (BatchOperation batch = this.metadataManager.getStore().initBatchOperation();){
                this.delVolumeFromOwnerList(volume, volumeArgs.getOwnerName(), batch);
                this.addVolumeToOwnerList(volume, owner, batch);
                OmVolumeArgs newVolumeArgs = OmVolumeArgs.newBuilder().setVolume(volumeArgs.getVolume()).setAdminName(volumeArgs.getAdminName()).setOwnerName(owner).setQuotaInBytes(volumeArgs.getQuotaInBytes()).setCreationTime(volumeArgs.getCreationTime()).build();
                this.metadataManager.getVolumeTable().putWithBatch(batch, (Object)dbVolumeKey, (Object)newVolumeArgs);
                this.metadataManager.getStore().commitBatchOperation(batch);
            }
        }
        catch (IOException | RocksDBException ex) {
            if (!(ex instanceof OMException)) {
                LOG.error("Changing volume ownership failed for user:{} volume:{}", new Object[]{owner, volume, ex});
            }
            if (ex instanceof RocksDBException) {
                throw RocksDBStore.toIOException((String)"Volume creation failed.", (RocksDBException)((RocksDBException)ex));
            }
            throw (IOException)ex;
        }
        finally {
            this.metadataManager.getLock().releaseVolumeLock(volume);
            this.metadataManager.getLock().releaseUserLock(owner);
        }
    }

    @Override
    public void setQuota(String volume, long quota) throws IOException {
        Preconditions.checkNotNull((Object)volume);
        this.metadataManager.getLock().acquireVolumeLock(volume);
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException(OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
            OmVolumeArgs newVolumeArgs = OmVolumeArgs.newBuilder().setVolume(volumeArgs.getVolume()).setAdminName(volumeArgs.getAdminName()).setOwnerName(volumeArgs.getOwnerName()).setQuotaInBytes(quota).setCreationTime(volumeArgs.getCreationTime()).build();
            this.metadataManager.getVolumeTable().put((Object)dbVolumeKey, (Object)newVolumeArgs);
        }
        catch (IOException ex) {
            if (!(ex instanceof OMException)) {
                LOG.error("Changing volume quota failed for volume:{} quota:{}", new Object[]{volume, quota, ex});
            }
            throw ex;
        }
        finally {
            this.metadataManager.getLock().releaseVolumeLock(volume);
        }
    }

    @Override
    public OmVolumeArgs getVolumeInfo(String volume) throws IOException {
        Preconditions.checkNotNull((Object)volume);
        this.metadataManager.getLock().acquireVolumeLock(volume);
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            OmVolumeArgs omVolumeArgs = volumeArgs;
            return omVolumeArgs;
        }
        catch (IOException ex) {
            if (!(ex instanceof OMException)) {
                LOG.warn("Info volume failed for volume:{}", (Object)volume, (Object)ex);
            }
            throw ex;
        }
        finally {
            this.metadataManager.getLock().releaseVolumeLock(volume);
        }
    }

    @Override
    public void deleteVolume(String volume) throws IOException {
        String owner;
        Preconditions.checkNotNull((Object)volume);
        this.metadataManager.getLock().acquireVolumeLock(volume);
        try {
            owner = this.getVolumeInfo(volume).getOwnerName();
        }
        finally {
            this.metadataManager.getLock().releaseVolumeLock(volume);
        }
        this.metadataManager.getLock().acquireUserLock(owner);
        this.metadataManager.getLock().acquireVolumeLock(volume);
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            if (!this.metadataManager.isVolumeEmpty(volume)) {
                LOG.debug("volume:{} is not empty", (Object)volume);
                throw new OMException(OMException.ResultCodes.VOLUME_NOT_EMPTY);
            }
            Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
            try (BatchOperation batch = this.metadataManager.getStore().initBatchOperation();){
                this.delVolumeFromOwnerList(volume, volumeArgs.getOwnerName(), batch);
                this.metadataManager.getVolumeTable().deleteWithBatch(batch, (Object)dbVolumeKey);
                this.metadataManager.getStore().commitBatchOperation(batch);
            }
        }
        catch (IOException | RocksDBException ex) {
            if (!(ex instanceof OMException)) {
                LOG.error("Delete volume failed for volume:{}", (Object)volume, (Object)ex);
            }
            if (ex instanceof RocksDBException) {
                throw RocksDBStore.toIOException((String)"Volume creation failed.", (RocksDBException)((RocksDBException)ex));
            }
            throw (IOException)ex;
        }
        finally {
            this.metadataManager.getLock().releaseVolumeLock(volume);
            this.metadataManager.getLock().releaseUserLock(owner);
        }
    }

    @Override
    public boolean checkVolumeAccess(String volume, OzoneManagerProtocolProtos.OzoneAclInfo userAcl) throws IOException {
        Preconditions.checkNotNull((Object)volume);
        Preconditions.checkNotNull((Object)userAcl);
        this.metadataManager.getLock().acquireVolumeLock(volume);
        try {
            String dbVolumeKey = this.metadataManager.getVolumeKey(volume);
            OmVolumeArgs volumeArgs = (OmVolumeArgs)this.metadataManager.getVolumeTable().get((Object)dbVolumeKey);
            if (volumeArgs == null) {
                LOG.debug("volume:{} does not exist", (Object)volume);
                throw new OMException("Volume " + volume + " is not found", OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            Preconditions.checkState((boolean)volume.equals(volumeArgs.getVolume()));
            boolean bl = volumeArgs.getAclMap().hasAccess(userAcl);
            return bl;
        }
        catch (IOException ex) {
            if (!(ex instanceof OMException)) {
                LOG.error("Check volume access failed for volume:{} user:{} rights:{}", new Object[]{volume, userAcl.getName(), userAcl.getRights(), ex});
            }
            throw ex;
        }
        finally {
            this.metadataManager.getLock().releaseVolumeLock(volume);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OmVolumeArgs> listVolumes(String userName, String prefix, String startKey, int maxKeys) throws IOException {
        this.metadataManager.getLock().acquireUserLock(userName);
        try {
            List list = this.metadataManager.listVolumes(userName, prefix, startKey, maxKeys);
            return list;
        }
        finally {
            this.metadataManager.getLock().releaseUserLock(userName);
        }
    }
}

