/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis;

import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.SizeInBytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OMRatisHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OMRatisHelper.class);

    private OMRatisHelper() {
    }

    static RaftClient newRaftClient(RpcType rpcType, String omId, RaftGroup group, RetryPolicy retryPolicy, Configuration conf) {
        LOG.trace("newRaftClient: {}, leader={}, group={}", new Object[]{rpcType, omId, group});
        RaftProperties properties = new RaftProperties();
        RaftConfigKeys.Rpc.setType((RaftProperties)properties, (RpcType)rpcType);
        int raftSegmentPreallocatedSize = (int)conf.getStorageSize("ozone.om.ratis.segment.preallocated.size", "16KB", StorageUnit.BYTES);
        GrpcConfigKeys.setMessageSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentPreallocatedSize));
        return RaftClient.newBuilder().setRaftGroup(group).setLeaderId(OMRatisHelper.getRaftPeerId(omId)).setProperties(properties).setRetryPolicy(retryPolicy).build();
    }

    static RaftPeerId getRaftPeerId(String omId) {
        return RaftPeerId.valueOf((String)omId);
    }

    static ByteString convertRequestToByteString(OzoneManagerProtocolProtos.OMRequest request) {
        byte[] requestBytes = request.toByteArray();
        return ByteString.copyFrom((byte[])requestBytes);
    }

    static OzoneManagerProtocolProtos.OMRequest convertByteStringToOMRequest(ByteString byteString) throws InvalidProtocolBufferException {
        byte[] bytes = byteString.toByteArray();
        return OzoneManagerProtocolProtos.OMRequest.parseFrom((byte[])bytes);
    }

    static Message convertResponseToMessage(OzoneManagerProtocolProtos.OMResponse response) {
        byte[] requestBytes = response.toByteArray();
        return Message.valueOf((ByteString)ByteString.copyFrom((byte[])requestBytes));
    }

    static OzoneManagerProtocolProtos.OMResponse getOMResponseFromRaftClientReply(RaftClientReply reply) throws InvalidProtocolBufferException {
        byte[] bytes = reply.getMessage().getContent().toByteArray();
        return OzoneManagerProtocolProtos.OMResponse.newBuilder((OzoneManagerProtocolProtos.OMResponse)OzoneManagerProtocolProtos.OMResponse.parseFrom((byte[])bytes)).setLeaderOMNodeId(reply.getReplierId()).build();
    }

    static OzoneManagerProtocolProtos.OMResponse getErrorResponse(OzoneManagerProtocolProtos.Type cmdType, Exception e) {
        return OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(cmdType).setSuccess(false).setMessage(e.getMessage()).setStatus(OzoneManagerProtocolProtos.Status.INTERNAL_ERROR).build();
    }
}

