/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ServiceException;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.ratis.OMRatisHelper;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftRetryFailureException;
import org.apache.ratis.retry.RetryPolicies;
import org.apache.ratis.retry.RetryPolicy;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneManagerRatisClient
implements Closeable {
    static final Logger LOG = LoggerFactory.getLogger(OzoneManagerRatisClient.class);
    private final RaftGroup raftGroup;
    private final String omNodeID;
    private final RpcType rpcType;
    private RaftClient raftClient;
    private final RetryPolicy retryPolicy;
    private final Configuration conf;

    private OzoneManagerRatisClient(String omNodeId, RaftGroup raftGroup, RpcType rpcType, RetryPolicy retryPolicy, Configuration config) {
        this.raftGroup = raftGroup;
        this.omNodeID = omNodeId;
        this.rpcType = rpcType;
        this.retryPolicy = retryPolicy;
        this.conf = config;
    }

    public static OzoneManagerRatisClient newOzoneManagerRatisClient(String omNodeId, RaftGroup raftGroup, Configuration conf) {
        String rpcType = conf.get("ozone.om.ratis.rpc.type", "GRPC");
        int maxRetryCount = conf.getInt("ozone.om.ratis.client.request.max.retries", 180);
        long retryInterval = conf.getTimeDuration("ozone.om.ratis.client.request.retry.interval", (long)OMConfigKeys.OZONE_OM_RATIS_CLIENT_REQUEST_RETRY_INTERVAL_DEFAULT.toIntExact(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        TimeDuration sleepDuration = TimeDuration.valueOf((long)retryInterval, (TimeUnit)TimeUnit.MILLISECONDS);
        RetryPolicies.RetryLimited retryPolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)maxRetryCount, (TimeDuration)sleepDuration);
        return new OzoneManagerRatisClient(omNodeId, raftGroup, (RpcType)SupportedRpcType.valueOfIgnoreCase((String)rpcType), (RetryPolicy)retryPolicy, conf);
    }

    public void connect() {
        LOG.debug("Connecting to OM Ratis Server GroupId:{} OM:{}", (Object)this.raftGroup.getGroupId().getUuid().toString(), (Object)this.omNodeID);
        this.raftClient = OMRatisHelper.newRaftClient(this.rpcType, this.omNodeID, this.raftGroup, this.retryPolicy, this.conf);
    }

    @Override
    public void close() {
        if (this.raftClient != null) {
            try {
                this.raftClient.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public OzoneManagerProtocolProtos.OMResponse sendCommand(OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        try {
            CompletableFuture<OzoneManagerProtocolProtos.OMResponse> reply = this.sendCommandAsync(request);
            return reply.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private CompletableFuture<OzoneManagerProtocolProtos.OMResponse> sendCommandAsync(OzoneManagerProtocolProtos.OMRequest request) {
        CompletableFuture<RaftClientReply> raftClientReply = this.sendRequestAsync(request);
        CompletionStage omRatisResponse = ((CompletableFuture)raftClientReply.whenComplete((reply, e) -> LOG.debug("received reply {} for request: cmdType={} traceID={} exception: {}", new Object[]{reply, request.getCmdType(), request.getTraceID(), e}))).thenApply(reply -> {
            try {
                RaftRetryFailureException raftRetryFailureException = reply.getRetryFailureException();
                if (raftRetryFailureException != null) {
                    throw new CompletionException((Throwable)raftRetryFailureException);
                }
                OzoneManagerProtocolProtos.OMResponse response = OMRatisHelper.getOMResponseFromRaftClientReply(reply);
                return response;
            }
            catch (InvalidProtocolBufferException e) {
                throw new CompletionException(e);
            }
        });
        return omRatisResponse;
    }

    private CompletableFuture<RaftClientReply> sendRequestAsync(OzoneManagerProtocolProtos.OMRequest request) {
        boolean isReadOnlyRequest = OmUtils.isReadOnly((OzoneManagerProtocolProtos.OMRequest)request);
        ByteString byteString = OMRatisHelper.convertRequestToByteString(request);
        LOG.debug("sendOMRequestAsync {} {}", (Object)isReadOnlyRequest, (Object)request);
        return isReadOnlyRequest ? this.raftClient.sendReadOnlyAsync(() -> byteString) : this.raftClient.sendAsync(() -> byteString);
    }
}

