/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.StorageUnit;
import org.apache.hadoop.hdds.scm.HddsServerUtil;
import org.apache.hadoop.ozone.om.OMConfigKeys;
import org.apache.hadoop.ozone.om.OMNodeDetails;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerStateMachine;
import org.apache.ratis.RaftConfigKeys;
import org.apache.ratis.client.RaftClientConfigKeys;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.grpc.GrpcConfigKeys;
import org.apache.ratis.netty.NettyConfigKeys;
import org.apache.ratis.protocol.RaftGroup;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.protocol.RaftPeer;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.rpc.RpcType;
import org.apache.ratis.rpc.SupportedRpcType;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.util.LifeCycle;
import org.apache.ratis.util.SizeInBytes;
import org.apache.ratis.util.TimeDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OzoneManagerRatisServer {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerRatisServer.class);
    private final int port;
    private final InetSocketAddress omRatisAddress;
    private final RaftServer server;
    private final RaftGroupId raftGroupId;
    private final RaftGroup raftGroup;
    private final RaftPeerId raftPeerId;
    private final OzoneManagerProtocol ozoneManager;

    private OzoneManagerRatisServer(Configuration conf, OzoneManagerProtocol om, String raftGroupIdStr, RaftPeerId localRaftPeerId, InetSocketAddress addr, List<RaftPeer> raftPeers) throws IOException {
        this.ozoneManager = om;
        this.omRatisAddress = addr;
        this.port = addr.getPort();
        RaftProperties serverProperties = this.newRaftProperties(conf);
        this.raftPeerId = localRaftPeerId;
        this.raftGroupId = RaftGroupId.valueOf((UUID)this.getRaftGroupIdFromOmServiceId(raftGroupIdStr));
        this.raftGroup = RaftGroup.valueOf((RaftGroupId)this.raftGroupId, raftPeers);
        StringBuilder raftPeersStr = new StringBuilder();
        for (RaftPeer peer : raftPeers) {
            raftPeersStr.append(", ").append(peer.getAddress());
        }
        LOG.info("Instantiating OM Ratis server with GroupID: {} and Raft Peers: {}", (Object)raftGroupIdStr, (Object)raftPeersStr.toString().substring(2));
        this.server = RaftServer.newBuilder().setServerId(this.raftPeerId).setGroup(this.raftGroup).setProperties(serverProperties).setStateMachine((StateMachine)this.getStateMachine(this.raftGroupId)).build();
    }

    public static OzoneManagerRatisServer newOMRatisServer(Configuration ozoneConf, OzoneManagerProtocol om, OMNodeDetails omNodeDetails, List<OMNodeDetails> peerNodes) throws IOException {
        String omServiceId = omNodeDetails.getOMServiceId();
        String omNodeId = omNodeDetails.getOMNodeId();
        RaftPeerId localRaftPeerId = RaftPeerId.getRaftPeerId((String)omNodeId);
        InetSocketAddress ratisAddr = new InetSocketAddress(omNodeDetails.getAddress(), omNodeDetails.getRatisPort());
        RaftPeer localRaftPeer = new RaftPeer(localRaftPeerId, ratisAddr);
        ArrayList<RaftPeer> raftPeers = new ArrayList<RaftPeer>();
        raftPeers.add(localRaftPeer);
        for (OMNodeDetails peerInfo : peerNodes) {
            String peerNodeId = peerInfo.getOMNodeId();
            InetSocketAddress peerRatisAddr = new InetSocketAddress(peerInfo.getAddress(), peerInfo.getRatisPort());
            RaftPeerId raftPeerId = RaftPeerId.valueOf((String)peerNodeId);
            RaftPeer raftPeer = new RaftPeer(raftPeerId, peerRatisAddr);
            raftPeers.add(raftPeer);
        }
        return new OzoneManagerRatisServer(ozoneConf, om, omServiceId, localRaftPeerId, ratisAddr, raftPeers);
    }

    public RaftGroup getRaftGroup() {
        return this.raftGroup;
    }

    private BaseStateMachine getStateMachine(RaftGroupId gid) {
        return new OzoneManagerStateMachine(this.ozoneManager);
    }

    public void start() throws IOException {
        LOG.info("Starting {} {} at port {}", new Object[]{this.getClass().getSimpleName(), this.server.getId(), this.port});
        this.server.start();
    }

    public void stop() {
        try {
            this.server.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private RaftProperties newRaftProperties(Configuration conf) {
        RaftProperties properties = new RaftProperties();
        String rpcType = conf.get("ozone.om.ratis.rpc.type", "GRPC");
        SupportedRpcType rpc = SupportedRpcType.valueOfIgnoreCase((String)rpcType);
        RaftConfigKeys.Rpc.setType((RaftProperties)properties, (RpcType)rpc);
        if (rpc == SupportedRpcType.GRPC) {
            GrpcConfigKeys.Server.setPort((RaftProperties)properties, (int)this.port);
        } else if (rpc == SupportedRpcType.NETTY) {
            NettyConfigKeys.Server.setPort((RaftProperties)properties, (int)this.port);
        }
        String storageDir = OzoneManagerRatisServer.getOMRatisDirectory(conf);
        RaftServerConfigKeys.setStorageDirs((RaftProperties)properties, Collections.singletonList(new File(storageDir)));
        int raftSegmentSize = (int)conf.getStorageSize("ozone.om.ratis.segment.size", "16KB", StorageUnit.BYTES);
        RaftServerConfigKeys.Log.setSegmentSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentSize));
        int raftSegmentPreallocatedSize = (int)conf.getStorageSize("ozone.om.ratis.segment.preallocated.size", "16KB", StorageUnit.BYTES);
        int logAppenderQueueNumElements = conf.getInt("ozone.om.ratis.log.appender.queue.num-elements", 1024);
        int logAppenderQueueByteLimit = (int)conf.getStorageSize("ozone.om.ratis.log.appender.queue.byte-limit", "32MB", StorageUnit.BYTES);
        RaftServerConfigKeys.Log.Appender.setBufferElementLimit((RaftProperties)properties, (int)logAppenderQueueNumElements);
        RaftServerConfigKeys.Log.Appender.setBufferByteLimit((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)logAppenderQueueByteLimit));
        RaftServerConfigKeys.Log.setPreallocatedSize((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)raftSegmentPreallocatedSize));
        GrpcConfigKeys.setMessageSizeMax((RaftProperties)properties, (SizeInBytes)SizeInBytes.valueOf((long)logAppenderQueueByteLimit));
        TimeUnit serverRequestTimeoutUnit = OMConfigKeys.OZONE_OM_RATIS_SERVER_REQUEST_TIMEOUT_DEFAULT.getUnit();
        long serverRequestTimeoutDuration = conf.getTimeDuration("ozone.om.ratis.server.request.timeout", OMConfigKeys.OZONE_OM_RATIS_SERVER_REQUEST_TIMEOUT_DEFAULT.getDuration(), serverRequestTimeoutUnit);
        TimeDuration serverRequestTimeout = TimeDuration.valueOf((long)serverRequestTimeoutDuration, (TimeUnit)serverRequestTimeoutUnit);
        RaftServerConfigKeys.Rpc.setRequestTimeout((RaftProperties)properties, (TimeDuration)serverRequestTimeout);
        TimeUnit retryCacheTimeoutUnit = OMConfigKeys.OZONE_OM_RATIS_SERVER_RETRY_CACHE_TIMEOUT_DEFAULT.getUnit();
        long retryCacheTimeoutDuration = conf.getTimeDuration("ozone.om.ratis.server.retry.cache.timeout", OMConfigKeys.OZONE_OM_RATIS_SERVER_RETRY_CACHE_TIMEOUT_DEFAULT.getDuration(), retryCacheTimeoutUnit);
        TimeDuration retryCacheTimeout = TimeDuration.valueOf((long)retryCacheTimeoutDuration, (TimeUnit)retryCacheTimeoutUnit);
        RaftServerConfigKeys.RetryCache.setExpiryTime((RaftProperties)properties, (TimeDuration)retryCacheTimeout);
        TimeUnit serverMinTimeoutUnit = OMConfigKeys.OZONE_OM_RATIS_MINIMUM_TIMEOUT_DEFAULT.getUnit();
        long serverMinTimeoutDuration = conf.getTimeDuration("ozone.om.ratis.minimum.timeout", OMConfigKeys.OZONE_OM_RATIS_MINIMUM_TIMEOUT_DEFAULT.getDuration(), serverMinTimeoutUnit);
        TimeDuration serverMinTimeout = TimeDuration.valueOf((long)serverMinTimeoutDuration, (TimeUnit)serverMinTimeoutUnit);
        long serverMaxTimeoutDuration = serverMinTimeout.toLong(TimeUnit.MILLISECONDS) + 200L;
        TimeDuration serverMaxTimeout = TimeDuration.valueOf((long)serverMaxTimeoutDuration, (TimeUnit)serverMinTimeoutUnit);
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)properties, (TimeDuration)serverMinTimeout);
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)properties, (TimeDuration)serverMaxTimeout);
        RaftServerConfigKeys.Log.setMaxCachedSegmentNum((RaftProperties)properties, (int)2);
        TimeUnit clientRequestTimeoutUnit = OMConfigKeys.OZONE_OM_RATIS_CLIENT_REQUEST_TIMEOUT_DURATION_DEFAULT.getUnit();
        long clientRequestTimeoutDuration = conf.getTimeDuration("ozone.om.ratis.client.request.timeout.duration", OMConfigKeys.OZONE_OM_RATIS_CLIENT_REQUEST_TIMEOUT_DURATION_DEFAULT.getDuration(), clientRequestTimeoutUnit);
        TimeDuration clientRequestTimeout = TimeDuration.valueOf((long)clientRequestTimeoutDuration, (TimeUnit)clientRequestTimeoutUnit);
        RaftClientConfigKeys.Rpc.setRequestTimeout((RaftProperties)properties, (TimeDuration)clientRequestTimeout);
        TimeUnit leaderElectionMinTimeoutUnit = OMConfigKeys.OZONE_OM_LEADER_ELECTION_MINIMUM_TIMEOUT_DURATION_DEFAULT.getUnit();
        long leaderElectionMinTimeoutduration = conf.getTimeDuration("ozone.om.leader.election.minimum.timeout.duration", OMConfigKeys.OZONE_OM_LEADER_ELECTION_MINIMUM_TIMEOUT_DURATION_DEFAULT.getDuration(), leaderElectionMinTimeoutUnit);
        TimeDuration leaderElectionMinTimeout = TimeDuration.valueOf((long)leaderElectionMinTimeoutduration, (TimeUnit)leaderElectionMinTimeoutUnit);
        RaftServerConfigKeys.Rpc.setTimeoutMin((RaftProperties)properties, (TimeDuration)leaderElectionMinTimeout);
        long leaderElectionMaxTimeout = leaderElectionMinTimeout.toLong(TimeUnit.MILLISECONDS) + 200L;
        RaftServerConfigKeys.Rpc.setTimeoutMax((RaftProperties)properties, (TimeDuration)TimeDuration.valueOf((long)leaderElectionMaxTimeout, (TimeUnit)TimeUnit.MILLISECONDS));
        TimeUnit nodeFailureTimeoutUnit = OMConfigKeys.OZONE_OM_RATIS_SERVER_FAILURE_TIMEOUT_DURATION_DEFAULT.getUnit();
        long nodeFailureTimeoutDuration = conf.getTimeDuration("ozone.om.ratis.server.failure.timeout.duration", OMConfigKeys.OZONE_OM_RATIS_SERVER_FAILURE_TIMEOUT_DURATION_DEFAULT.getDuration(), nodeFailureTimeoutUnit);
        TimeDuration nodeFailureTimeout = TimeDuration.valueOf((long)nodeFailureTimeoutDuration, (TimeUnit)nodeFailureTimeoutUnit);
        RaftServerConfigKeys.setLeaderElectionTimeout((RaftProperties)properties, (TimeDuration)nodeFailureTimeout);
        RaftServerConfigKeys.Rpc.setSlownessTimeout((RaftProperties)properties, (TimeDuration)nodeFailureTimeout);
        return properties;
    }

    public int getServerPort() {
        return this.port;
    }

    @VisibleForTesting
    public LifeCycle.State getServerState() {
        return this.server.getLifeCycleState();
    }

    @VisibleForTesting
    public RaftPeerId getRaftPeerId() {
        return this.raftPeerId;
    }

    public static String getOMRatisDirectory(Configuration conf) {
        String storageDir = conf.get("ozone.om.ratis.storage.dir");
        if (Strings.isNullOrEmpty((String)storageDir)) {
            storageDir = HddsServerUtil.getDefaultRatisDirectory((Configuration)conf);
        }
        return storageDir;
    }

    private UUID getRaftGroupIdFromOmServiceId(String omServiceId) {
        return UUID.nameUUIDFromBytes(omServiceId.getBytes(StandardCharsets.UTF_8));
    }
}

