/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.ContainerStateMachine;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.ratis.OMRatisHelper;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.Message;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.protocol.RaftGroupId;
import org.apache.ratis.server.RaftServer;
import org.apache.ratis.server.storage.RaftStorage;
import org.apache.ratis.statemachine.StateMachine;
import org.apache.ratis.statemachine.TransactionContext;
import org.apache.ratis.statemachine.impl.BaseStateMachine;
import org.apache.ratis.statemachine.impl.SimpleStateMachineStorage;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerStateMachine
extends BaseStateMachine {
    static final Logger LOG = LoggerFactory.getLogger(ContainerStateMachine.class);
    private final SimpleStateMachineStorage storage = new SimpleStateMachineStorage();
    private final OzoneManagerRequestHandler handler;
    private RaftGroupId raftGroupId;

    public OzoneManagerStateMachine(OzoneManagerProtocol om) {
        this.handler = new OzoneManagerRequestHandler(om);
    }

    public void initialize(RaftServer server, RaftGroupId id, RaftStorage raftStorage) throws IOException {
        super.initialize(server, id, raftStorage);
        this.raftGroupId = id;
        this.storage.init(raftStorage);
    }

    public TransactionContext startTransaction(RaftClientRequest raftClientRequest) throws IOException {
        ByteString messageContent = raftClientRequest.getMessage().getContent();
        OzoneManagerProtocolProtos.OMRequest omRequest = OMRatisHelper.convertByteStringToOMRequest(messageContent);
        Preconditions.checkArgument((boolean)raftClientRequest.getRaftGroupId().equals((Object)this.raftGroupId));
        try {
            this.handler.validateRequest(omRequest);
        }
        catch (IOException ioe) {
            TransactionContext ctxt = TransactionContext.newBuilder().setClientRequest(raftClientRequest).setStateMachine((StateMachine)this).setServerRole(RaftProtos.RaftPeerRole.LEADER).build();
            ctxt.setException((Exception)ioe);
            return ctxt;
        }
        return TransactionContext.newBuilder().setClientRequest(raftClientRequest).setStateMachine((StateMachine)this).setServerRole(RaftProtos.RaftPeerRole.LEADER).setLogData(messageContent).build();
    }

    public CompletableFuture<Message> applyTransaction(TransactionContext trx) {
        try {
            OzoneManagerProtocolProtos.OMRequest request = OMRatisHelper.convertByteStringToOMRequest(trx.getStateMachineLogEntry().getLogData());
            CompletableFuture<Message> future = CompletableFuture.supplyAsync(() -> this.runCommand(request));
            return future;
        }
        catch (IOException e) {
            return OzoneManagerStateMachine.completeExceptionally(e);
        }
    }

    public CompletableFuture<Message> query(Message request) {
        try {
            OzoneManagerProtocolProtos.OMRequest omRequest = OMRatisHelper.convertByteStringToOMRequest(request.getContent());
            return CompletableFuture.completedFuture(this.runCommand(omRequest));
        }
        catch (IOException e) {
            return OzoneManagerStateMachine.completeExceptionally(e);
        }
    }

    private Message runCommand(OzoneManagerProtocolProtos.OMRequest request) {
        OzoneManagerProtocolProtos.OMResponse response = this.handler.handle(request);
        return OMRatisHelper.convertResponseToMessage(response);
    }

    private static <T> CompletableFuture<T> completeExceptionally(Exception e) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(e);
        return future;
    }
}

