/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import io.opentracing.Scope;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolPB;
import org.apache.hadoop.ozone.om.ratis.OzoneManagerRatisClient;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerProtocolServerSideTranslatorPB
implements OzoneManagerProtocolPB {
    private static final Logger LOG = LoggerFactory.getLogger(OzoneManagerProtocolServerSideTranslatorPB.class);
    private final OzoneManagerRatisClient omRatisClient;
    private final OzoneManagerRequestHandler handler;
    private final boolean isRatisEnabled;

    public OzoneManagerProtocolServerSideTranslatorPB(OzoneManagerProtocol impl, OzoneManagerRatisClient ratisClient, boolean enableRatis) {
        this.handler = new OzoneManagerRequestHandler(impl);
        this.omRatisClient = ratisClient;
        this.isRatisEnabled = enableRatis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OzoneManagerProtocolProtos.OMResponse submitRequest(RpcController controller, OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        try (Scope scope = TracingUtil.importAndCreateScope((String)request.getCmdType().name(), (String)request.getTraceID());){
            if (this.isRatisEnabled) {
                OzoneManagerProtocolProtos.OMResponse oMResponse = this.submitRequestToRatis(request);
                return oMResponse;
            }
            OzoneManagerProtocolProtos.OMResponse oMResponse = this.submitRequestDirectlyToOM(request);
            return oMResponse;
        }
    }

    private OzoneManagerProtocolProtos.OMResponse submitRequestToRatis(OzoneManagerProtocolProtos.OMRequest request) throws ServiceException {
        return this.omRatisClient.sendCommand(request);
    }

    private OzoneManagerProtocolProtos.OMResponse submitRequestDirectlyToOM(OzoneManagerProtocolProtos.OMRequest request) {
        return this.handler.handle(request);
    }
}

