/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketArgs;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartCommitUploadPartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerRequestHandler {
    static final Logger LOG = LoggerFactory.getLogger(OzoneManagerRequestHandler.class);
    private final OzoneManagerProtocol impl;

    public OzoneManagerRequestHandler(OzoneManagerProtocol om) {
        this.impl = om;
    }

    public OzoneManagerProtocolProtos.OMResponse handle(OzoneManagerProtocolProtos.OMRequest request) {
        OzoneManagerProtocolProtos.OMResponse.Builder responseBuilder;
        block36: {
            LOG.debug("Received OMRequest: {}, ", (Object)request);
            OzoneManagerProtocolProtos.Type cmdType = request.getCmdType();
            responseBuilder = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(cmdType).setStatus(OzoneManagerProtocolProtos.Status.OK);
            try {
                switch (cmdType) {
                    case CreateVolume: {
                        OzoneManagerProtocolProtos.CreateVolumeResponse createVolumeResponse = this.createVolume(request.getCreateVolumeRequest());
                        responseBuilder.setCreateVolumeResponse(createVolumeResponse);
                        break;
                    }
                    case SetVolumeProperty: {
                        OzoneManagerProtocolProtos.SetVolumePropertyResponse setVolumePropertyResponse = this.setVolumeProperty(request.getSetVolumePropertyRequest());
                        responseBuilder.setSetVolumePropertyResponse(setVolumePropertyResponse);
                        break;
                    }
                    case CheckVolumeAccess: {
                        OzoneManagerProtocolProtos.CheckVolumeAccessResponse checkVolumeAccessResponse = this.checkVolumeAccess(request.getCheckVolumeAccessRequest());
                        responseBuilder.setCheckVolumeAccessResponse(checkVolumeAccessResponse);
                        break;
                    }
                    case InfoVolume: {
                        OzoneManagerProtocolProtos.InfoVolumeResponse infoVolumeResponse = this.infoVolume(request.getInfoVolumeRequest());
                        responseBuilder.setInfoVolumeResponse(infoVolumeResponse);
                        break;
                    }
                    case DeleteVolume: {
                        OzoneManagerProtocolProtos.DeleteVolumeResponse deleteVolumeResponse = this.deleteVolume(request.getDeleteVolumeRequest());
                        responseBuilder.setDeleteVolumeResponse(deleteVolumeResponse);
                        break;
                    }
                    case ListVolume: {
                        OzoneManagerProtocolProtos.ListVolumeResponse listVolumeResponse = this.listVolumes(request.getListVolumeRequest());
                        responseBuilder.setListVolumeResponse(listVolumeResponse);
                        break;
                    }
                    case CreateBucket: {
                        OzoneManagerProtocolProtos.CreateBucketResponse createBucketResponse = this.createBucket(request.getCreateBucketRequest());
                        responseBuilder.setCreateBucketResponse(createBucketResponse);
                        break;
                    }
                    case InfoBucket: {
                        OzoneManagerProtocolProtos.InfoBucketResponse infoBucketResponse = this.infoBucket(request.getInfoBucketRequest());
                        responseBuilder.setInfoBucketResponse(infoBucketResponse);
                        break;
                    }
                    case SetBucketProperty: {
                        OzoneManagerProtocolProtos.SetBucketPropertyResponse setBucketPropertyResponse = this.setBucketProperty(request.getSetBucketPropertyRequest());
                        responseBuilder.setSetBucketPropertyResponse(setBucketPropertyResponse);
                        break;
                    }
                    case DeleteBucket: {
                        OzoneManagerProtocolProtos.DeleteBucketResponse deleteBucketResponse = this.deleteBucket(request.getDeleteBucketRequest());
                        responseBuilder.setDeleteBucketResponse(deleteBucketResponse);
                        break;
                    }
                    case ListBuckets: {
                        OzoneManagerProtocolProtos.ListBucketsResponse listBucketsResponse = this.listBuckets(request.getListBucketsRequest());
                        responseBuilder.setListBucketsResponse(listBucketsResponse);
                        break;
                    }
                    case CreateKey: {
                        OzoneManagerProtocolProtos.CreateKeyResponse createKeyResponse = this.createKey(request.getCreateKeyRequest());
                        responseBuilder.setCreateKeyResponse(createKeyResponse);
                        break;
                    }
                    case LookupKey: {
                        OzoneManagerProtocolProtos.LookupKeyResponse lookupKeyResponse = this.lookupKey(request.getLookupKeyRequest());
                        responseBuilder.setLookupKeyResponse(lookupKeyResponse);
                        break;
                    }
                    case RenameKey: {
                        OzoneManagerProtocolProtos.RenameKeyResponse renameKeyResponse = this.renameKey(request.getRenameKeyRequest());
                        responseBuilder.setRenameKeyResponse(renameKeyResponse);
                        break;
                    }
                    case DeleteKey: {
                        OzoneManagerProtocolProtos.DeleteKeyResponse deleteKeyResponse = this.deleteKey(request.getDeleteKeyRequest());
                        responseBuilder.setDeleteKeyResponse(deleteKeyResponse);
                        break;
                    }
                    case ListKeys: {
                        OzoneManagerProtocolProtos.ListKeysResponse listKeysResponse = this.listKeys(request.getListKeysRequest());
                        responseBuilder.setListKeysResponse(listKeysResponse);
                        break;
                    }
                    case CommitKey: {
                        OzoneManagerProtocolProtos.CommitKeyResponse commitKeyResponse = this.commitKey(request.getCommitKeyRequest());
                        responseBuilder.setCommitKeyResponse(commitKeyResponse);
                        break;
                    }
                    case AllocateBlock: {
                        OzoneManagerProtocolProtos.AllocateBlockResponse allocateBlockResponse = this.allocateBlock(request.getAllocateBlockRequest());
                        responseBuilder.setAllocateBlockResponse(allocateBlockResponse);
                        break;
                    }
                    case CreateS3Bucket: {
                        OzoneManagerProtocolProtos.S3CreateBucketResponse s3CreateBucketResponse = this.createS3Bucket(request.getCreateS3BucketRequest());
                        responseBuilder.setCreateS3BucketResponse(s3CreateBucketResponse);
                        break;
                    }
                    case DeleteS3Bucket: {
                        OzoneManagerProtocolProtos.S3DeleteBucketResponse s3DeleteBucketResponse = this.deleteS3Bucket(request.getDeleteS3BucketRequest());
                        responseBuilder.setDeleteS3BucketResponse(s3DeleteBucketResponse);
                        break;
                    }
                    case InfoS3Bucket: {
                        OzoneManagerProtocolProtos.S3BucketInfoResponse s3BucketInfoResponse = this.getS3Bucketinfo(request.getInfoS3BucketRequest());
                        responseBuilder.setInfoS3BucketResponse(s3BucketInfoResponse);
                        break;
                    }
                    case ListS3Buckets: {
                        OzoneManagerProtocolProtos.S3ListBucketsResponse s3ListBucketsResponse = this.listS3Buckets(request.getListS3BucketsRequest());
                        responseBuilder.setListS3BucketsResponse(s3ListBucketsResponse);
                        break;
                    }
                    case InitiateMultiPartUpload: {
                        OzoneManagerProtocolProtos.MultipartInfoInitiateResponse multipartInfoInitiateResponse = this.initiateMultiPartUpload(request.getInitiateMultiPartUploadRequest());
                        responseBuilder.setInitiateMultiPartUploadResponse(multipartInfoInitiateResponse);
                        break;
                    }
                    case CommitMultiPartUpload: {
                        OzoneManagerProtocolProtos.MultipartCommitUploadPartResponse commitUploadPartResponse = this.commitMultipartUploadPart(request.getCommitMultiPartUploadRequest());
                        responseBuilder.setCommitMultiPartUploadResponse(commitUploadPartResponse);
                        break;
                    }
                    case CompleteMultiPartUpload: {
                        OzoneManagerProtocolProtos.MultipartUploadCompleteResponse completeMultiPartUploadResponse = this.completeMultipartUpload(request.getCompleteMultiPartUploadRequest());
                        responseBuilder.setCompleteMultiPartUploadResponse(completeMultiPartUploadResponse);
                        break;
                    }
                    case AbortMultiPartUpload: {
                        OzoneManagerProtocolProtos.MultipartUploadAbortResponse abortMultiPartAbortResponse = this.abortMultipartUpload(request.getAbortMultiPartUploadRequest());
                        responseBuilder.setAbortMultiPartUploadResponse(abortMultiPartAbortResponse);
                        break;
                    }
                    case ListMultiPartUploadParts: {
                        OzoneManagerProtocolProtos.MultipartUploadListPartsResponse listPartsResponse = this.listParts(request.getListMultipartUploadPartsRequest());
                        responseBuilder.setListMultipartUploadPartsResponse(listPartsResponse);
                        break;
                    }
                    case ServiceList: {
                        OzoneManagerProtocolProtos.ServiceListResponse serviceListResponse = this.getServiceList(request.getServiceListRequest());
                        responseBuilder.setServiceListResponse(serviceListResponse);
                        break;
                    }
                    case GetDelegationToken: {
                        OzoneManagerProtocolProtos.GetDelegationTokenResponseProto getDtResp = this.getDelegationToken(request.getGetDelegationTokenRequest());
                        responseBuilder.setGetDelegationTokenResponse(getDtResp);
                        break;
                    }
                    case RenewDelegationToken: {
                        OzoneManagerProtocolProtos.RenewDelegationTokenResponseProto renewDtResp = this.renewDelegationToken(request.getRenewDelegationTokenRequest());
                        responseBuilder.setRenewDelegationTokenResponse(renewDtResp);
                        break;
                    }
                    case CancelDelegationToken: {
                        OzoneManagerProtocolProtos.CancelDelegationTokenResponseProto cancelDtResp = this.cancelDelegationToken(request.getCancelDelegationTokenRequest());
                        responseBuilder.setCancelDelegationTokenResponse(cancelDtResp);
                        break;
                    }
                    case GetS3Secret: {
                        OzoneManagerProtocolProtos.GetS3SecretResponse getS3SecretResp = this.getS3Secret(request.getGetS3SecretRequest());
                        responseBuilder.setGetS3SecretResponse(getS3SecretResp);
                        break;
                    }
                    default: {
                        responseBuilder.setSuccess(false);
                        responseBuilder.setMessage("Unrecognized Command Type: " + cmdType);
                    }
                }
                responseBuilder.setSuccess(true);
            }
            catch (IOException ex) {
                responseBuilder.setSuccess(false);
                responseBuilder.setStatus(this.exceptionToResponseStatus(ex));
                if (ex.getMessage() == null) break block36;
                responseBuilder.setMessage(ex.getMessage());
            }
        }
        return responseBuilder.build();
    }

    private OzoneManagerProtocolProtos.Status exceptionToResponseStatus(IOException ex) {
        if (ex instanceof OMException) {
            return OzoneManagerProtocolProtos.Status.values()[((OMException)ex).getResult().ordinal()];
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unknown error occurs", (Throwable)ex);
        }
        return OzoneManagerProtocolProtos.Status.INTERNAL_ERROR;
    }

    public void validateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) throws OMException {
        OzoneManagerProtocolProtos.Type cmdType = omRequest.getCmdType();
        if (cmdType == null) {
            throw new OMException("CmdType is null", OMException.ResultCodes.INVALID_REQUEST);
        }
        if (omRequest.getClientId() == null) {
            throw new OMException("ClientId is null", OMException.ResultCodes.INVALID_REQUEST);
        }
    }

    private OzoneManagerProtocolProtos.CreateVolumeResponse createVolume(OzoneManagerProtocolProtos.CreateVolumeRequest request) throws IOException {
        this.impl.createVolume(OmVolumeArgs.getFromProtobuf((OzoneManagerProtocolProtos.VolumeInfo)request.getVolumeInfo()));
        return OzoneManagerProtocolProtos.CreateVolumeResponse.newBuilder().build();
    }

    private OzoneManagerProtocolProtos.SetVolumePropertyResponse setVolumeProperty(OzoneManagerProtocolProtos.SetVolumePropertyRequest request) throws IOException {
        OzoneManagerProtocolProtos.SetVolumePropertyResponse.Builder resp = OzoneManagerProtocolProtos.SetVolumePropertyResponse.newBuilder();
        String volume = request.getVolumeName();
        if (request.hasQuotaInBytes()) {
            long quota = request.getQuotaInBytes();
            this.impl.setQuota(volume, quota);
        } else {
            String owner = request.getOwnerName();
            this.impl.setOwner(volume, owner);
        }
        return resp.build();
    }

    private OzoneManagerProtocolProtos.CheckVolumeAccessResponse checkVolumeAccess(OzoneManagerProtocolProtos.CheckVolumeAccessRequest request) throws IOException {
        OzoneManagerProtocolProtos.CheckVolumeAccessResponse.Builder resp = OzoneManagerProtocolProtos.CheckVolumeAccessResponse.newBuilder();
        boolean access = this.impl.checkVolumeAccess(request.getVolumeName(), request.getUserAcl());
        if (!access) {
            throw new OMException(OMException.ResultCodes.ACCESS_DENIED);
        }
        return resp.build();
    }

    private OzoneManagerProtocolProtos.InfoVolumeResponse infoVolume(OzoneManagerProtocolProtos.InfoVolumeRequest request) throws IOException {
        OzoneManagerProtocolProtos.InfoVolumeResponse.Builder resp = OzoneManagerProtocolProtos.InfoVolumeResponse.newBuilder();
        String volume = request.getVolumeName();
        OmVolumeArgs ret = this.impl.getVolumeInfo(volume);
        resp.setVolumeInfo(ret.getProtobuf());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.DeleteVolumeResponse deleteVolume(OzoneManagerProtocolProtos.DeleteVolumeRequest request) throws IOException {
        OzoneManagerProtocolProtos.DeleteVolumeResponse.Builder resp = OzoneManagerProtocolProtos.DeleteVolumeResponse.newBuilder();
        this.impl.deleteVolume(request.getVolumeName());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.ListVolumeResponse listVolumes(OzoneManagerProtocolProtos.ListVolumeRequest request) throws IOException {
        OzoneManagerProtocolProtos.ListVolumeResponse.Builder resp = OzoneManagerProtocolProtos.ListVolumeResponse.newBuilder();
        List result = Lists.newArrayList();
        if (request.getScope() == OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_USER) {
            result = this.impl.listVolumeByUser(request.getUserName(), request.getPrefix(), request.getPrevKey(), request.getMaxKeys());
        } else if (request.getScope() == OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_CLUSTER) {
            result = this.impl.listAllVolumes(request.getPrefix(), request.getPrevKey(), request.getMaxKeys());
        }
        result.forEach(item -> resp.addVolumeInfo(item.getProtobuf()));
        return resp.build();
    }

    private OzoneManagerProtocolProtos.CreateBucketResponse createBucket(OzoneManagerProtocolProtos.CreateBucketRequest request) throws IOException {
        OzoneManagerProtocolProtos.CreateBucketResponse.Builder resp = OzoneManagerProtocolProtos.CreateBucketResponse.newBuilder();
        this.impl.createBucket(OmBucketInfo.getFromProtobuf((OzoneManagerProtocolProtos.BucketInfo)request.getBucketInfo()));
        return resp.build();
    }

    private OzoneManagerProtocolProtos.InfoBucketResponse infoBucket(OzoneManagerProtocolProtos.InfoBucketRequest request) throws IOException {
        OzoneManagerProtocolProtos.InfoBucketResponse.Builder resp = OzoneManagerProtocolProtos.InfoBucketResponse.newBuilder();
        OmBucketInfo omBucketInfo = this.impl.getBucketInfo(request.getVolumeName(), request.getBucketName());
        resp.setBucketInfo(omBucketInfo.getProtobuf());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.CreateKeyResponse createKey(OzoneManagerProtocolProtos.CreateKeyRequest request) throws IOException {
        OzoneManagerProtocolProtos.CreateKeyResponse.Builder resp = OzoneManagerProtocolProtos.CreateKeyResponse.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        HddsProtos.ReplicationType type = keyArgs.hasType() ? keyArgs.getType() : null;
        HddsProtos.ReplicationFactor factor = keyArgs.hasFactor() ? keyArgs.getFactor() : null;
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setDataSize(keyArgs.getDataSize()).setType(type).setFactor(factor).setIsMultipartKey(keyArgs.getIsMultipartKey()).setMultipartUploadID(keyArgs.getMultipartUploadID()).setMultipartUploadPartNumber(keyArgs.getMultipartNumber()).build();
        if (keyArgs.hasDataSize()) {
            omKeyArgs.setDataSize(keyArgs.getDataSize());
        } else {
            omKeyArgs.setDataSize(0L);
        }
        OpenKeySession openKey = this.impl.openKey(omKeyArgs);
        resp.setKeyInfo(openKey.getKeyInfo().getProtobuf());
        resp.setID(openKey.getId());
        resp.setOpenVersion(openKey.getOpenVersion());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.LookupKeyResponse lookupKey(OzoneManagerProtocolProtos.LookupKeyRequest request) throws IOException {
        OzoneManagerProtocolProtos.LookupKeyResponse.Builder resp = OzoneManagerProtocolProtos.LookupKeyResponse.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setRefreshPipeline(true).build();
        OmKeyInfo keyInfo = this.impl.lookupKey(omKeyArgs);
        resp.setKeyInfo(keyInfo.getProtobuf());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.RenameKeyResponse renameKey(OzoneManagerProtocolProtos.RenameKeyRequest request) throws IOException {
        OzoneManagerProtocolProtos.RenameKeyResponse.Builder resp = OzoneManagerProtocolProtos.RenameKeyResponse.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setRefreshPipeline(true).build();
        this.impl.renameKey(omKeyArgs, request.getToKeyName());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.SetBucketPropertyResponse setBucketProperty(OzoneManagerProtocolProtos.SetBucketPropertyRequest request) throws IOException {
        OzoneManagerProtocolProtos.SetBucketPropertyResponse.Builder resp = OzoneManagerProtocolProtos.SetBucketPropertyResponse.newBuilder();
        this.impl.setBucketProperty(OmBucketArgs.getFromProtobuf((OzoneManagerProtocolProtos.BucketArgs)request.getBucketArgs()));
        return resp.build();
    }

    private OzoneManagerProtocolProtos.DeleteKeyResponse deleteKey(OzoneManagerProtocolProtos.DeleteKeyRequest request) throws IOException {
        OzoneManagerProtocolProtos.DeleteKeyResponse.Builder resp = OzoneManagerProtocolProtos.DeleteKeyResponse.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).build();
        this.impl.deleteKey(omKeyArgs);
        return resp.build();
    }

    private OzoneManagerProtocolProtos.DeleteBucketResponse deleteBucket(OzoneManagerProtocolProtos.DeleteBucketRequest request) throws IOException {
        OzoneManagerProtocolProtos.DeleteBucketResponse.Builder resp = OzoneManagerProtocolProtos.DeleteBucketResponse.newBuilder();
        this.impl.deleteBucket(request.getVolumeName(), request.getBucketName());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.ListBucketsResponse listBuckets(OzoneManagerProtocolProtos.ListBucketsRequest request) throws IOException {
        OzoneManagerProtocolProtos.ListBucketsResponse.Builder resp = OzoneManagerProtocolProtos.ListBucketsResponse.newBuilder();
        List buckets = this.impl.listBuckets(request.getVolumeName(), request.getStartKey(), request.getPrefix(), request.getCount());
        for (OmBucketInfo bucket : buckets) {
            resp.addBucketInfo(bucket.getProtobuf());
        }
        return resp.build();
    }

    private OzoneManagerProtocolProtos.ListKeysResponse listKeys(OzoneManagerProtocolProtos.ListKeysRequest request) throws IOException {
        OzoneManagerProtocolProtos.ListKeysResponse.Builder resp = OzoneManagerProtocolProtos.ListKeysResponse.newBuilder();
        List keys = this.impl.listKeys(request.getVolumeName(), request.getBucketName(), request.getStartKey(), request.getPrefix(), request.getCount());
        for (OmKeyInfo key : keys) {
            resp.addKeyInfo(key.getProtobuf());
        }
        return resp.build();
    }

    private OzoneManagerProtocolProtos.CommitKeyResponse commitKey(OzoneManagerProtocolProtos.CommitKeyRequest request) throws IOException {
        OzoneManagerProtocolProtos.CommitKeyResponse.Builder resp = OzoneManagerProtocolProtos.CommitKeyResponse.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        HddsProtos.ReplicationType type = keyArgs.hasType() ? keyArgs.getType() : null;
        HddsProtos.ReplicationFactor factor = keyArgs.hasFactor() ? keyArgs.getFactor() : null;
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setLocationInfoList(keyArgs.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.toList())).setType(type).setFactor(factor).setDataSize(keyArgs.getDataSize()).build();
        this.impl.commitKey(omKeyArgs, request.getClientID());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.AllocateBlockResponse allocateBlock(OzoneManagerProtocolProtos.AllocateBlockRequest request) throws IOException {
        OzoneManagerProtocolProtos.AllocateBlockResponse.Builder resp = OzoneManagerProtocolProtos.AllocateBlockResponse.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).build();
        OmKeyLocationInfo newLocation = this.impl.allocateBlock(omKeyArgs, request.getClientID(), ExcludeList.getFromProtoBuf((HddsProtos.ExcludeListProto)request.getExcludeList()));
        resp.setKeyLocation(newLocation.getProtobuf());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.ServiceListResponse getServiceList(OzoneManagerProtocolProtos.ServiceListRequest request) throws IOException {
        OzoneManagerProtocolProtos.ServiceListResponse.Builder resp = OzoneManagerProtocolProtos.ServiceListResponse.newBuilder();
        resp.addAllServiceInfo((Iterable)this.impl.getServiceList().stream().map(ServiceInfo::getProtobuf).collect(Collectors.toList()));
        return resp.build();
    }

    private OzoneManagerProtocolProtos.S3CreateBucketResponse createS3Bucket(OzoneManagerProtocolProtos.S3CreateBucketRequest request) throws IOException {
        OzoneManagerProtocolProtos.S3CreateBucketResponse.Builder resp = OzoneManagerProtocolProtos.S3CreateBucketResponse.newBuilder();
        this.impl.createS3Bucket(request.getUserName(), request.getS3Bucketname());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.S3DeleteBucketResponse deleteS3Bucket(OzoneManagerProtocolProtos.S3DeleteBucketRequest request) throws IOException {
        OzoneManagerProtocolProtos.S3DeleteBucketResponse.Builder resp = OzoneManagerProtocolProtos.S3DeleteBucketResponse.newBuilder();
        this.impl.deleteS3Bucket(request.getS3BucketName());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.S3BucketInfoResponse getS3Bucketinfo(OzoneManagerProtocolProtos.S3BucketInfoRequest request) throws IOException {
        OzoneManagerProtocolProtos.S3BucketInfoResponse.Builder resp = OzoneManagerProtocolProtos.S3BucketInfoResponse.newBuilder();
        resp.setOzoneMapping(this.impl.getOzoneBucketMapping(request.getS3BucketName()));
        return resp.build();
    }

    private OzoneManagerProtocolProtos.S3ListBucketsResponse listS3Buckets(OzoneManagerProtocolProtos.S3ListBucketsRequest request) throws IOException {
        OzoneManagerProtocolProtos.S3ListBucketsResponse.Builder resp = OzoneManagerProtocolProtos.S3ListBucketsResponse.newBuilder();
        List buckets = this.impl.listS3Buckets(request.getUserName(), request.getStartKey(), request.getPrefix(), request.getCount());
        for (OmBucketInfo bucket : buckets) {
            resp.addBucketInfo(bucket.getProtobuf());
        }
        return resp.build();
    }

    private OzoneManagerProtocolProtos.MultipartInfoInitiateResponse initiateMultiPartUpload(OzoneManagerProtocolProtos.MultipartInfoInitiateRequest request) throws IOException {
        OzoneManagerProtocolProtos.MultipartInfoInitiateResponse.Builder resp = OzoneManagerProtocolProtos.MultipartInfoInitiateResponse.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setType(keyArgs.getType()).setFactor(keyArgs.getFactor()).build();
        OmMultipartInfo multipartInfo = this.impl.initiateMultipartUpload(omKeyArgs);
        resp.setVolumeName(multipartInfo.getVolumeName());
        resp.setBucketName(multipartInfo.getBucketName());
        resp.setKeyName(multipartInfo.getKeyName());
        resp.setMultipartUploadID(multipartInfo.getUploadID());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.MultipartCommitUploadPartResponse commitMultipartUploadPart(OzoneManagerProtocolProtos.MultipartCommitUploadPartRequest request) throws IOException {
        OzoneManagerProtocolProtos.MultipartCommitUploadPartResponse.Builder resp = OzoneManagerProtocolProtos.MultipartCommitUploadPartResponse.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setMultipartUploadID(keyArgs.getMultipartUploadID()).setIsMultipartKey(keyArgs.getIsMultipartKey()).setMultipartUploadPartNumber(keyArgs.getMultipartNumber()).setDataSize(keyArgs.getDataSize()).setLocationInfoList(keyArgs.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.toList())).build();
        OmMultipartCommitUploadPartInfo commitUploadPartInfo = this.impl.commitMultipartUploadPart(omKeyArgs, request.getClientID());
        resp.setPartName(commitUploadPartInfo.getPartName());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.MultipartUploadCompleteResponse completeMultipartUpload(OzoneManagerProtocolProtos.MultipartUploadCompleteRequest request) throws IOException {
        OzoneManagerProtocolProtos.MultipartUploadCompleteResponse.Builder response = OzoneManagerProtocolProtos.MultipartUploadCompleteResponse.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        List partsList = request.getPartsListList();
        TreeMap<Integer, String> partsMap = new TreeMap<Integer, String>();
        for (OzoneManagerProtocolProtos.Part part : partsList) {
            partsMap.put(part.getPartNumber(), part.getPartName());
        }
        OmMultipartUploadList omMultipartUploadList = new OmMultipartUploadList(partsMap);
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setMultipartUploadID(keyArgs.getMultipartUploadID()).build();
        OmMultipartUploadCompleteInfo omMultipartUploadCompleteInfo = this.impl.completeMultipartUpload(omKeyArgs, omMultipartUploadList);
        response.setVolume(omMultipartUploadCompleteInfo.getVolume()).setBucket(omMultipartUploadCompleteInfo.getBucket()).setKey(omMultipartUploadCompleteInfo.getKey()).setHash(omMultipartUploadCompleteInfo.getHash());
        return response.build();
    }

    private OzoneManagerProtocolProtos.MultipartUploadAbortResponse abortMultipartUpload(OzoneManagerProtocolProtos.MultipartUploadAbortRequest multipartUploadAbortRequest) throws IOException {
        OzoneManagerProtocolProtos.MultipartUploadAbortResponse.Builder response = OzoneManagerProtocolProtos.MultipartUploadAbortResponse.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = multipartUploadAbortRequest.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setMultipartUploadID(keyArgs.getMultipartUploadID()).build();
        this.impl.abortMultipartUpload(omKeyArgs);
        return response.build();
    }

    private OzoneManagerProtocolProtos.MultipartUploadListPartsResponse listParts(OzoneManagerProtocolProtos.MultipartUploadListPartsRequest multipartUploadListPartsRequest) throws IOException {
        OzoneManagerProtocolProtos.MultipartUploadListPartsResponse.Builder response = OzoneManagerProtocolProtos.MultipartUploadListPartsResponse.newBuilder();
        OmMultipartUploadListParts omMultipartUploadListParts = this.impl.listParts(multipartUploadListPartsRequest.getVolume(), multipartUploadListPartsRequest.getBucket(), multipartUploadListPartsRequest.getKey(), multipartUploadListPartsRequest.getUploadID(), multipartUploadListPartsRequest.getPartNumbermarker(), multipartUploadListPartsRequest.getMaxParts());
        List omPartInfoList = omMultipartUploadListParts.getPartInfoList();
        ArrayList partInfoList = new ArrayList();
        omPartInfoList.forEach(partInfo -> partInfoList.add(partInfo.getProto()));
        response.setType(omMultipartUploadListParts.getReplicationType());
        response.setNextPartNumberMarker(omMultipartUploadListParts.getNextPartNumberMarker());
        response.setIsTruncated(omMultipartUploadListParts.isTruncated());
        return response.addAllPartsList(partInfoList).build();
    }

    private OzoneManagerProtocolProtos.GetDelegationTokenResponseProto getDelegationToken(SecurityProtos.GetDelegationTokenRequestProto request) throws OMException {
        OzoneManagerProtocolProtos.GetDelegationTokenResponseProto.Builder rb = OzoneManagerProtocolProtos.GetDelegationTokenResponseProto.newBuilder();
        Token token = this.impl.getDelegationToken(new Text(request.getRenewer()));
        if (token != null) {
            rb.setResponse(SecurityProtos.GetDelegationTokenResponseProto.newBuilder().setToken(OMPBHelper.convertToTokenProto((Token)token)).build());
        }
        return rb.build();
    }

    private OzoneManagerProtocolProtos.RenewDelegationTokenResponseProto renewDelegationToken(SecurityProtos.RenewDelegationTokenRequestProto request) throws OMException {
        OzoneManagerProtocolProtos.RenewDelegationTokenResponseProto.Builder rb = OzoneManagerProtocolProtos.RenewDelegationTokenResponseProto.newBuilder();
        if (request.hasToken()) {
            long expiryTime = this.impl.renewDelegationToken(OMPBHelper.convertToDelegationToken((SecurityProtos.TokenProto)request.getToken()));
            rb.setResponse(SecurityProtos.RenewDelegationTokenResponseProto.newBuilder().setNewExpiryTime(expiryTime).build());
        }
        return rb.build();
    }

    private OzoneManagerProtocolProtos.CancelDelegationTokenResponseProto cancelDelegationToken(SecurityProtos.CancelDelegationTokenRequestProto req) throws OMException {
        OzoneManagerProtocolProtos.CancelDelegationTokenResponseProto.Builder rb = OzoneManagerProtocolProtos.CancelDelegationTokenResponseProto.newBuilder();
        if (req.hasToken()) {
            this.impl.cancelDelegationToken(OMPBHelper.convertToDelegationToken((SecurityProtos.TokenProto)req.getToken()));
        }
        rb.setResponse(SecurityProtos.CancelDelegationTokenResponseProto.getDefaultInstance());
        return rb.build();
    }

    private OzoneManagerProtocolProtos.GetS3SecretResponse getS3Secret(OzoneManagerProtocolProtos.GetS3SecretRequest request) throws IOException {
        OzoneManagerProtocolProtos.GetS3SecretResponse.Builder rb = OzoneManagerProtocolProtos.GetS3SecretResponse.newBuilder();
        rb.setS3Secret(this.impl.getS3Secret(request.getKerberosID()).getProtobuf());
        return rb.build();
    }
}

