/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.bucket;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.OzoneClientUtils;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import org.apache.hadoop.ozone.web.utils.JsonUtils;
import picocli.CommandLine;

@CommandLine.Command(name="update", description={"allows changing bucket attributes"})
public class UpdateBucketHandler
extends Handler {
    @CommandLine.Parameters(arity="1..1", description={"URI of the volume/bucket.\nOzone URI could start with o3:// or http(s):// or without prefix. REST protocol will be used for http(s), RPC otherwise. URI may contain the host and port of the OM server. Both are optional. If they are not specified it will be identified from the config files."})
    private String uri;
    @CommandLine.Option(names={"--addAcl"}, description={"Comma separated list of acl rules to add (eg. user:bilbo:rw)"})
    private String addAcl;
    @CommandLine.Option(names={"--removeAcl"}, description={"Comma separated list of acl rules to remove (eg. user:bilbo:rw)"})
    private String removeAcl;

    @Override
    public Void call() throws Exception {
        List aclList;
        String[] aclArray;
        OzoneAddress address = new OzoneAddress(this.uri);
        address.ensureBucketAddress();
        OzoneClient client = address.createClient(this.createOzoneConfiguration());
        String volumeName = address.getVolumeName();
        String bucketName = address.getBucketName();
        if (this.isVerbose()) {
            System.out.printf("Volume Name : %s%n", volumeName);
            System.out.printf("Bucket Name : %s%n", bucketName);
        }
        OzoneVolume vol = client.getObjectStore().getVolume(volumeName);
        OzoneBucket bucket = vol.getBucket(bucketName);
        if (this.addAcl != null) {
            aclArray = this.addAcl.split(",");
            aclList = Arrays.stream(aclArray).map(acl -> OzoneAcl.parseAcl((String)acl)).collect(Collectors.toList());
            bucket.addAcls(aclList);
        }
        if (this.removeAcl != null) {
            aclArray = this.removeAcl.split(",");
            aclList = Arrays.stream(aclArray).map(acl -> OzoneAcl.parseAcl((String)acl)).collect(Collectors.toList());
            bucket.removeAcls(aclList);
        }
        System.out.printf("%s%n", JsonUtils.toJsonStringWithDefaultPrettyPrinter((String)JsonUtils.toJsonString((Object)OzoneClientUtils.asBucketInfo((OzoneBucket)bucket))));
        return null;
    }
}

