/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.web.ozShell.token;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.web.ozShell.Handler;
import org.apache.hadoop.ozone.web.ozShell.OzoneAddress;
import org.apache.hadoop.security.token.Token;
import picocli.CommandLine;

@CommandLine.Command(name="renew", description={"renew a delegation token."})
public class RenewTokenHandler
extends Handler {
    @CommandLine.Option(names={"--token", "-t"}, description={"file containing encoded token"}, defaultValue="/tmp/token.txt", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private String tokenFile;

    @Override
    public Void call() throws Exception {
        OzoneAddress address = new OzoneAddress("");
        OzoneClient client = address.createClient(this.createOzoneConfiguration());
        if (!OzoneSecurityUtil.isSecurityEnabled((Configuration)this.createOzoneConfiguration())) {
            System.err.println("Error:Token operations work only when security is enabled. To enable security set ozone.security.enabled to true.");
            return null;
        }
        if (Files.notExists(Paths.get(this.tokenFile, new String[0]), new LinkOption[0])) {
            System.err.println("Error:Renew token operation failed as token file: " + this.tokenFile + " containing encoded token doesn't exist.");
            return null;
        }
        Token token = new Token();
        token.decodeFromUrlString(new String(Files.readAllBytes(Paths.get(this.tokenFile, new String[0])), StandardCharsets.UTF_8));
        long expiryTime = client.getObjectStore().renewDelegationToken(token);
        System.out.printf("Token renewed successfully, expiry time: %s", expiryTime);
        return null;
    }
}

