/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.net.NetUtils;

public final class OMNodeDetails {
    private String omServiceId;
    private String omNodeId;
    private InetSocketAddress rpcAddress;
    private int rpcPort;
    private int ratisPort;
    private String httpAddress;
    private String httpsAddress;

    private OMNodeDetails(String serviceId, String nodeId, InetSocketAddress rpcAddr, int rpcPort, int ratisPort, String httpAddress, String httpsAddress) {
        this.omServiceId = serviceId;
        this.omNodeId = nodeId;
        this.rpcAddress = rpcAddr;
        this.rpcPort = rpcPort;
        this.ratisPort = ratisPort;
        this.httpAddress = httpAddress;
        this.httpsAddress = httpsAddress;
    }

    public String getOMServiceId() {
        return this.omServiceId;
    }

    public String getOMNodeId() {
        return this.omNodeId;
    }

    public InetSocketAddress getRpcAddress() {
        return this.rpcAddress;
    }

    public InetAddress getAddress() {
        return this.rpcAddress.getAddress();
    }

    public int getRatisPort() {
        return this.ratisPort;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    public String getRpcAddressString() {
        return NetUtils.getHostPortString((InetSocketAddress)this.rpcAddress);
    }

    public String getOMDBCheckpointEnpointUrl(HttpConfig.Policy httpPolicy) {
        if (httpPolicy.isHttpEnabled()) {
            if (StringUtils.isNotEmpty((CharSequence)this.httpAddress)) {
                return "http://" + this.httpAddress + "/dbCheckpoint" + "?" + "snapshotBeforeCheckpoint" + "=true";
            }
        } else if (StringUtils.isNotEmpty((CharSequence)this.httpsAddress)) {
            return "https://" + this.httpsAddress + "/dbCheckpoint" + "?" + "snapshotBeforeCheckpoint" + "=true";
        }
        return null;
    }

    public static class Builder {
        private String omServiceId;
        private String omNodeId;
        private InetSocketAddress rpcAddress;
        private int rpcPort;
        private int ratisPort;
        private String httpAddr;
        private String httpsAddr;

        public Builder setRpcAddress(InetSocketAddress rpcAddr) {
            this.rpcAddress = rpcAddr;
            this.rpcPort = this.rpcAddress.getPort();
            return this;
        }

        public Builder setRatisPort(int port) {
            this.ratisPort = port;
            return this;
        }

        public Builder setOMServiceId(String serviceId) {
            this.omServiceId = serviceId;
            return this;
        }

        public Builder setOMNodeId(String nodeId) {
            this.omNodeId = nodeId;
            return this;
        }

        public Builder setHttpAddress(String httpAddress) {
            this.httpAddr = httpAddress;
            return this;
        }

        public Builder setHttpsAddress(String httpsAddress) {
            this.httpsAddr = httpsAddress;
            return this;
        }

        public OMNodeDetails build() {
            return new OMNodeDetails(this.omServiceId, this.omNodeId, this.rpcAddress, this.rpcPort, this.ratisPort, this.httpAddr, this.httpsAddr);
        }
    }
}

