/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class OMPolicyProvider
extends PolicyProvider {
    private static AtomicReference<OMPolicyProvider> atomicReference = new AtomicReference();
    private static final Service[] OM_SERVICES = new Service[]{new Service("ozone.om.security.client.protocol.acl", OzoneManagerProtocol.class)};

    private OMPolicyProvider() {
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static OMPolicyProvider getInstance() {
        if (atomicReference.get() == null) {
            atomicReference.compareAndSet(null, new OMPolicyProvider());
        }
        return atomicReference.get();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Service[] getServices() {
        return OM_SERVICES;
    }
}

