/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.ratis.utils;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.bucket.OMBucketCreateRequest;
import org.apache.hadoop.ozone.om.request.bucket.OMBucketDeleteRequest;
import org.apache.hadoop.ozone.om.request.bucket.OMBucketSetPropertyRequest;
import org.apache.hadoop.ozone.om.request.file.OMDirectoryCreateRequest;
import org.apache.hadoop.ozone.om.request.file.OMFileCreateRequest;
import org.apache.hadoop.ozone.om.request.key.OMAllocateBlockRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyCommitRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyCreateRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyDeleteRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyPurgeRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRenameRequest;
import org.apache.hadoop.ozone.om.request.s3.bucket.S3BucketCreateRequest;
import org.apache.hadoop.ozone.om.request.s3.bucket.S3BucketDeleteRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3InitiateMultipartUploadRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadAbortRequest;
import org.apache.hadoop.ozone.om.request.s3.multipart.S3MultipartUploadCommitPartRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeCreateRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeDeleteRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeSetOwnerRequest;
import org.apache.hadoop.ozone.om.request.volume.OMVolumeSetQuotaRequest;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class OzoneManagerRatisUtils {
    private OzoneManagerRatisUtils() {
    }

    public static OMClientRequest createClientRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        OzoneManagerProtocolProtos.Type cmdType = omRequest.getCmdType();
        switch (cmdType) {
            case CreateVolume: {
                return new OMVolumeCreateRequest(omRequest);
            }
            case SetVolumeProperty: {
                boolean hasQuota = omRequest.getSetVolumePropertyRequest().hasQuotaInBytes();
                boolean hasOwner = omRequest.getSetVolumePropertyRequest().hasOwnerName();
                Preconditions.checkState((hasOwner || hasQuota ? 1 : 0) != 0, (Object)"Either Quota or owner should be set in the SetVolumeProperty request");
                Preconditions.checkState((!hasOwner || !hasQuota ? 1 : 0) != 0, (Object)"Either Quota or owner should be set in the SetVolumeProperty request. Should not set both");
                if (hasQuota) {
                    return new OMVolumeSetQuotaRequest(omRequest);
                }
                return new OMVolumeSetOwnerRequest(omRequest);
            }
            case DeleteVolume: {
                return new OMVolumeDeleteRequest(omRequest);
            }
            case CreateBucket: {
                return new OMBucketCreateRequest(omRequest);
            }
            case DeleteBucket: {
                return new OMBucketDeleteRequest(omRequest);
            }
            case SetBucketProperty: {
                return new OMBucketSetPropertyRequest(omRequest);
            }
            case AllocateBlock: {
                return new OMAllocateBlockRequest(omRequest);
            }
            case CreateKey: {
                return new OMKeyCreateRequest(omRequest);
            }
            case CommitKey: {
                return new OMKeyCommitRequest(omRequest);
            }
            case DeleteKey: {
                return new OMKeyDeleteRequest(omRequest);
            }
            case RenameKey: {
                return new OMKeyRenameRequest(omRequest);
            }
            case CreateDirectory: {
                return new OMDirectoryCreateRequest(omRequest);
            }
            case CreateFile: {
                return new OMFileCreateRequest(omRequest);
            }
            case PurgeKeys: {
                return new OMKeyPurgeRequest(omRequest);
            }
            case CreateS3Bucket: {
                return new S3BucketCreateRequest(omRequest);
            }
            case DeleteS3Bucket: {
                return new S3BucketDeleteRequest(omRequest);
            }
            case InitiateMultiPartUpload: {
                return new S3InitiateMultipartUploadRequest(omRequest);
            }
            case CommitMultiPartUpload: {
                return new S3MultipartUploadCommitPartRequest(omRequest);
            }
            case AbortMultiPartUpload: {
                return new S3MultipartUploadAbortRequest(omRequest);
            }
        }
        return null;
    }

    public static OzoneManagerProtocolProtos.Status exceptionToResponseStatus(IOException exception) {
        if (exception instanceof OMException) {
            return OzoneManagerProtocolProtos.Status.values()[((OMException)((Object)exception)).getResult().ordinal()];
        }
        return OzoneManagerProtocolProtos.Status.INTERNAL_ERROR;
    }
}

