/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditEventStatus;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.AuditMessage;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.om.request.RequestAuditor;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.security.UserGroupInformation;

public abstract class OMClientRequest
implements RequestAuditor {
    private OzoneManagerProtocolProtos.OMRequest omRequest;

    public OMClientRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        Preconditions.checkNotNull((Object)omRequest);
        this.omRequest = omRequest;
    }

    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        this.omRequest = this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).build();
        return this.omRequest;
    }

    public abstract OMClientResponse validateAndUpdateCache(OzoneManager var1, long var2);

    @VisibleForTesting
    public OzoneManagerProtocolProtos.OMRequest getOmRequest() {
        return this.omRequest;
    }

    public OzoneManagerProtocolProtos.UserInfo getUserInfo() {
        UserGroupInformation user = ProtobufRpcEngine.Server.getRemoteUser();
        InetAddress remoteAddress = ProtobufRpcEngine.Server.getRemoteIp();
        OzoneManagerProtocolProtos.UserInfo.Builder userInfo = OzoneManagerProtocolProtos.UserInfo.newBuilder();
        if (user != null) {
            userInfo.setUserName(user.getUserName());
        }
        if (remoteAddress != null) {
            userInfo.setRemoteAddress(remoteAddress.getHostAddress()).build();
        }
        return userInfo.build();
    }

    public void checkAcls(OzoneManager ozoneManager, OzoneObj.ResourceType resType, OzoneObj.StoreType storeType, IAccessAuthorizer.ACLType aclType, String vol, String bucket, String key) throws IOException {
        ozoneManager.checkAcls(resType, storeType, aclType, vol, bucket, key, this.createUGI(), this.getRemoteAddress());
    }

    @VisibleForTesting
    public UserGroupInformation createUGI() {
        if (this.omRequest.hasUserInfo()) {
            return UserGroupInformation.createRemoteUser((String)this.omRequest.getUserInfo().getUserName());
        }
        return null;
    }

    @VisibleForTesting
    public InetAddress getRemoteAddress() throws IOException {
        if (this.omRequest.hasUserInfo()) {
            return InetAddress.getByName(this.omRequest.getUserInfo().getRemoteAddress());
        }
        return null;
    }

    protected OzoneManagerProtocolProtos.OMResponse createErrorOMResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse.Builder omResponse, @Nonnull IOException ex) {
        omResponse.setSuccess(false);
        if (ex.getMessage() != null) {
            omResponse.setMessage(ex.getMessage());
        }
        omResponse.setStatus(OzoneManagerRatisUtils.exceptionToResponseStatus(ex));
        return omResponse.build();
    }

    protected void auditLog(AuditLogger auditLogger, AuditMessage auditMessage) {
        auditLogger.logWrite(auditMessage);
    }

    @Override
    public AuditMessage buildAuditMessage(AuditAction op, Map<String, String> auditMap, Throwable throwable, OzoneManagerProtocolProtos.UserInfo userInfo) {
        return new AuditMessage.Builder().setUser(userInfo != null ? userInfo.getUserName() : null).atIp(userInfo != null ? userInfo.getRemoteAddress() : null).forOperation(op.getAction()).withParams(auditMap).withResult(throwable != null ? AuditEventStatus.FAILURE.toString() : AuditEventStatus.SUCCESS.toString()).withException(throwable).build();
    }

    @Override
    public Map<String, String> buildVolumeAuditMap(String volume) {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", volume);
        return auditMap;
    }
}

