/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket;

import com.google.common.base.Optional;
import java.io.IOException;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.OMBucketCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.OMPBHelper;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketCreateRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMBucketCreateRequest.class);

    public OMBucketCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.CreateBucketRequest createBucketRequest = this.getOmRequest().getCreateBucketRequest();
        OzoneManagerProtocolProtos.BucketInfo bucketInfo = createBucketRequest.getBucketInfo();
        KeyProviderCryptoExtension kmsProvider = ozoneManager.getKmsProvider();
        OzoneManagerProtocolProtos.CreateBucketRequest.Builder newCreateBucketRequest = createBucketRequest.toBuilder();
        OzoneManagerProtocolProtos.BucketInfo.Builder newBucketInfo = bucketInfo.toBuilder();
        newBucketInfo.setCreationTime(Time.now());
        if (bucketInfo.hasBeinfo()) {
            newBucketInfo.setBeinfo(this.getBeinfo(kmsProvider, bucketInfo));
        }
        newCreateBucketRequest.setBucketInfo(newBucketInfo.build());
        return this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).setCreateBucketRequest(newCreateBucketRequest.build()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        IOException exception;
        OzoneManagerProtocolProtos.UserInfo userInfo;
        AuditLogger auditLogger;
        OmBucketInfo omBucketInfo;
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse;
        String bucketName;
        String volumeName;
        OMMetadataManager metadataManager;
        OMMetrics omMetrics;
        block11: {
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumBucketCreates();
            metadataManager = ozoneManager.getMetadataManager();
            OzoneManagerProtocolProtos.BucketInfo bucketInfo = this.getBucketInfoFromRequest();
            volumeName = bucketInfo.getVolumeName();
            bucketName = bucketInfo.getBucketName();
            omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CreateBucket).setStatus(OzoneManagerProtocolProtos.Status.OK);
            omBucketInfo = OmBucketInfo.getFromProtobuf((OzoneManagerProtocolProtos.BucketInfo)bucketInfo);
            auditLogger = ozoneManager.getAuditLogger();
            userInfo = this.getOmRequest().getUserInfo();
            try {
                if (ozoneManager.getAclsEnabled()) {
                    this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.CREATE, volumeName, bucketName, null);
                }
            }
            catch (IOException ex) {
                LOG.error("Bucket creation failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, ex});
                omMetrics.incNumBucketCreateFails();
                this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.CREATE_BUCKET, omBucketInfo.toAuditMap(), ex, userInfo));
                return new OMBucketCreateResponse(omBucketInfo, this.createErrorOMResponse(omResponse, ex));
            }
            String volumeKey = metadataManager.getVolumeKey(volumeName);
            String bucketKey = metadataManager.getBucketKey(volumeName, bucketName);
            exception = null;
            boolean acquiredBucketLock = false;
            metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
            try {
                acquiredBucketLock = metadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                if (metadataManager.getVolumeTable().get((Object)volumeKey) == null) {
                    LOG.debug("volume: {} not found ", (Object)volumeName);
                    throw new OMException("Volume doesn't exist", OMException.ResultCodes.VOLUME_NOT_FOUND);
                }
                if (metadataManager.getBucketTable().get((Object)bucketKey) != null) {
                    LOG.debug("bucket: {} already exists ", (Object)bucketName);
                    throw new OMException("Bucket already exist", OMException.ResultCodes.BUCKET_ALREADY_EXISTS);
                }
                metadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), new CacheValue(Optional.of((Object)omBucketInfo), transactionLogIndex));
                if (!acquiredBucketLock) break block11;
            }
            catch (IOException ex) {
                block12: {
                    try {
                        exception = ex;
                        if (!acquiredBucketLock) break block12;
                    }
                    catch (Throwable throwable) {
                        if (acquiredBucketLock) {
                            metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                        }
                        metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
                        throw throwable;
                    }
                    metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
            }
            metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        metadataManager.getLock().releaseLock(OzoneManagerLock.Resource.VOLUME_LOCK, new String[]{volumeName});
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.CREATE_BUCKET, omBucketInfo.toAuditMap(), exception, userInfo));
        if (exception == null) {
            LOG.debug("created bucket: {} in volume: {}", (Object)bucketName, (Object)volumeName);
            omMetrics.incNumBuckets();
            omResponse.setCreateBucketResponse(OzoneManagerProtocolProtos.CreateBucketResponse.newBuilder().build());
            return new OMBucketCreateResponse(omBucketInfo, omResponse.build());
        }
        omMetrics.incNumBucketCreateFails();
        LOG.error("Bucket creation failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, exception});
        return new OMBucketCreateResponse(omBucketInfo, this.createErrorOMResponse(omResponse, exception));
    }

    private OzoneManagerProtocolProtos.BucketInfo getBucketInfoFromRequest() {
        OzoneManagerProtocolProtos.CreateBucketRequest createBucketRequest = this.getOmRequest().getCreateBucketRequest();
        return createBucketRequest.getBucketInfo();
    }

    private OzoneManagerProtocolProtos.BucketEncryptionInfoProto getBeinfo(KeyProviderCryptoExtension kmsProvider, OzoneManagerProtocolProtos.BucketInfo bucketInfo) throws IOException {
        OzoneManagerProtocolProtos.BucketEncryptionInfoProto bek = bucketInfo.getBeinfo();
        OzoneManagerProtocolProtos.BucketEncryptionInfoProto.Builder bekb = null;
        if (kmsProvider == null) {
            throw new OMException("Invalid KMS provider, check configuration hadoop.security.key.provider.path", OMException.ResultCodes.INVALID_KMS_PROVIDER);
        }
        if (bek.getKeyName() == null) {
            throw new OMException("Bucket encryption key needed.", OMException.ResultCodes.BUCKET_ENCRYPTION_KEY_NOT_FOUND);
        }
        KeyProvider.Metadata metadata = kmsProvider.getMetadata(bek.getKeyName());
        if (metadata == null) {
            throw new OMException("Bucket encryption key " + bek.getKeyName() + " doesn't exist.", OMException.ResultCodes.BUCKET_ENCRYPTION_KEY_NOT_FOUND);
        }
        kmsProvider.warmUpEncryptedKeys(new String[]{bek.getKeyName()});
        bekb = OzoneManagerProtocolProtos.BucketEncryptionInfoProto.newBuilder().setKeyName(bek.getKeyName()).setCryptoProtocolVersion(OzoneManagerProtocolProtos.CryptoProtocolVersionProto.ENCRYPTION_ZONES).setSuite(OMPBHelper.convert((CipherSuite)CipherSuite.convert((String)metadata.getCipher())));
        return bekb.build();
    }
}

