/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.bucket;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.bucket.OMBucketDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMBucketDeleteRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMBucketDeleteRequest.class);

    public OMBucketDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OMMetrics omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumBucketDeletes();
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        OzoneManagerProtocolProtos.OMRequest omRequest = this.getOmRequest();
        String volumeName = omRequest.getDeleteBucketRequest().getVolumeName();
        String bucketName = omRequest.getDeleteBucketRequest().getBucketName();
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setStatus(OzoneManagerProtocolProtos.Status.OK).setCmdType(omRequest.getCmdType());
        AuditLogger auditLogger = ozoneManager.getAuditLogger();
        Map<String, String> auditMap = this.buildVolumeAuditMap(volumeName);
        auditMap.put("bucket", bucketName);
        OzoneManagerProtocolProtos.UserInfo userInfo = this.getOmRequest().getUserInfo();
        try {
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volumeName, bucketName, null);
            }
        }
        catch (IOException ex) {
            omMetrics.incNumBucketDeleteFails();
            LOG.error("Delete bucket failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, ex});
            this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.DELETE_BUCKET, auditMap, ex, userInfo));
            return new OMBucketDeleteResponse(volumeName, bucketName, this.createErrorOMResponse(omResponse, ex));
        }
        IOException exception = null;
        omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        try {
            String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
            OmBucketInfo omBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)bucketKey);
            if (omBucketInfo == null) {
                LOG.debug("bucket: {} not found ", (Object)bucketName);
                throw new OMException("Bucket doesn't exist", OMException.ResultCodes.BUCKET_NOT_FOUND);
            }
            if (!omMetadataManager.isBucketEmpty(volumeName, bucketName)) {
                LOG.debug("bucket: {} is not empty ", (Object)bucketName);
                throw new OMException("Bucket is not empty", OMException.ResultCodes.BUCKET_NOT_EMPTY);
            }
            omMetrics.decNumBuckets();
            omMetadataManager.getBucketTable().addCacheEntry(new CacheKey((Object)bucketKey), new CacheValue(Optional.absent(), transactionLogIndex));
        }
        catch (IOException ex) {
            try {
                exception = ex;
            }
            catch (Throwable throwable) {
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.DELETE_BUCKET, auditMap, exception, userInfo));
        if (exception == null) {
            LOG.debug("Deleted bucket:{} in volume:{}", (Object)bucketName, (Object)volumeName);
            omResponse.setDeleteBucketResponse(OzoneManagerProtocolProtos.DeleteBucketResponse.newBuilder().build());
            return new OMBucketDeleteResponse(volumeName, bucketName, omResponse.build());
        }
        omMetrics.incNumBucketDeleteFails();
        LOG.error("Delete bucket failed for bucket:{} in volume:{}", new Object[]{bucketName, volumeName, exception});
        return new OMBucketDeleteResponse(volumeName, bucketName, this.createErrorOMResponse(omResponse, exception));
    }
}

