/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.file;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.file.OMDirectoryCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMDirectoryCreateRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMDirectoryCreateRequest.class);

    public OMDirectoryCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) {
        OzoneManagerProtocolProtos.CreateDirectoryRequest createDirectoryRequest = this.getOmRequest().getCreateDirectoryRequest();
        Preconditions.checkNotNull((Object)createDirectoryRequest);
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = createDirectoryRequest.getKeyArgs().toBuilder().setModificationTime(Time.now());
        OzoneManagerProtocolProtos.CreateDirectoryRequest.Builder newCreateDirectoryRequest = createDirectoryRequest.toBuilder().setKeyArgs(newKeyArgs);
        return this.getOmRequest().toBuilder().setCreateDirectoryRequest(newCreateDirectoryRequest).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        block13: {
            block14: {
                keyArgs = this.getOmRequest().getCreateDirectoryRequest().getKeyArgs();
                volumeName = keyArgs.getVolumeName();
                bucketName = keyArgs.getBucketName();
                keyName = keyArgs.getKeyName();
                omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.CreateDirectory).setStatus(OzoneManagerProtocolProtos.Status.OK);
                omMetrics = ozoneManager.getMetrics();
                omMetrics.incNumCreateDirectory();
                auditLogger = ozoneManager.getAuditLogger();
                userInfo = this.getOmRequest().getUserInfo();
                auditMap = this.buildKeyArgsAuditMap(keyArgs);
                omMetadataManager = ozoneManager.getMetadataManager();
                acquiredLock = false;
                exception = null;
                dirKeyInfo = null;
                if (ozoneManager.getAclsEnabled()) {
                    this.checkAcls(ozoneManager, OzoneObj.ResourceType.BUCKET, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volumeName, bucketName, keyName);
                }
                if (keyName.length() != 0) break block13;
                var17_16 = new OMDirectoryCreateResponse(null, omResponse.setCreateDirectoryResponse(OzoneManagerProtocolProtos.CreateDirectoryResponse.newBuilder()).build());
                if (!acquiredLock) break block14;
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
            return var17_16;
        }
        try {
            acquiredLock = omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            omBucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName));
            if (omBucketInfo == null) {
                throw new OMException("Bucket not found " + bucketName, OMException.ResultCodes.BUCKET_NOT_FOUND);
            }
            omDirectoryResult = OMFileRequest.verifyFilesInPath(omMetadataManager, volumeName, bucketName, keyName, Paths.get(keyName, new String[0]));
            if (omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS || omDirectoryResult == OMFileRequest.OMDirectoryResult.FILE_EXISTS_IN_GIVENPATH) {
                throw new OMException("Unable to create directory: " + keyName + " in volume/bucket: " + volumeName + "/" + bucketName, OMException.ResultCodes.FILE_ALREADY_EXISTS);
            }
            if (omDirectoryResult == OMFileRequest.OMDirectoryResult.DIRECTORY_EXISTS_IN_GIVENPATH || omDirectoryResult == OMFileRequest.OMDirectoryResult.NONE) {
                dirKeyInfo = this.createDirectoryKeyInfo(ozoneManager, omBucketInfo, volumeName, bucketName, keyName, keyArgs);
                omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getOzoneKey(volumeName, bucketName, dirKeyInfo.getKeyName())), new CacheValue(Optional.of((Object)dirKeyInfo), transactionLogIndex));
            }
            ** if (!acquiredLock) goto lbl-1000
        }
        catch (IOException ex) {
            try {
                exception = ex;
                ** if (!acquiredLock) goto lbl-1000
            }
            catch (Throwable var19_20) {
                if (acquiredLock) {
                    omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                }
                throw var19_20;
            }
lbl-1000:
            // 1 sources

            {
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
lbl-1000:
        // 2 sources

        {
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.CREATE_DIRECTORY, auditMap, exception, userInfo));
        if (exception == null) {
            OMDirectoryCreateRequest.LOG.debug("Directory is successfully created for Key: {} in volume/bucket:{}/{}", new Object[]{keyName, volumeName, bucketName});
            omResponse.setCreateDirectoryResponse(OzoneManagerProtocolProtos.CreateDirectoryResponse.newBuilder());
            return new OMDirectoryCreateResponse(dirKeyInfo, omResponse.build());
        }
        OMDirectoryCreateRequest.LOG.error("CreateDirectory failed for Key: {} in volume/bucket:{}/{}", new Object[]{keyName, volumeName, bucketName, exception});
        omMetrics.incNumCreateDirectoryFails();
        return new OMDirectoryCreateResponse(null, this.createErrorOMResponse(omResponse, exception));
    }

    private OmKeyInfo createDirectoryKeyInfo(OzoneManager ozoneManager, OmBucketInfo omBucketInfo, String volumeName, String bucketName, String keyName, OzoneManagerProtocolProtos.KeyArgs keyArgs) throws IOException {
        Optional<FileEncryptionInfo> encryptionInfo = this.getFileEncryptionInfo(ozoneManager, omBucketInfo);
        String dirName = OzoneFSUtils.addTrailingSlashIfNeeded((String)keyName);
        return new OmKeyInfo.Builder().setVolumeName(volumeName).setBucketName(bucketName).setKeyName(dirName).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, new ArrayList()))).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setDataSize(0L).setReplicationType(HddsProtos.ReplicationType.RATIS).setReplicationFactor(HddsProtos.ReplicationFactor.ONE).setFileEncryptionInfo((FileEncryptionInfo)encryptionInfo.orNull()).setAcls(OzoneAclUtil.fromProtobuf((List)keyArgs.getAclsList())).build();
    }
}

