/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMAllocateBlockResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMAllocateBlockRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMAllocateBlockRequest.class);

    public OMAllocateBlockRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.AllocateBlockRequest allocateBlockRequest = this.getOmRequest().getAllocateBlockRequest();
        Preconditions.checkNotNull((Object)allocateBlockRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = allocateBlockRequest.getKeyArgs();
        ExcludeList excludeList = new ExcludeList();
        if (allocateBlockRequest.hasExcludeList()) {
            excludeList = ExcludeList.getFromProtoBuf((HddsProtos.ExcludeListProto)allocateBlockRequest.getExcludeList());
        }
        List<OmKeyLocationInfo> omKeyLocationInfoList = this.allocateBlock(ozoneManager.getScmClient(), ozoneManager.getBlockTokenSecretManager(), keyArgs.getType(), keyArgs.getFactor(), excludeList, ozoneManager.getScmBlockSize(), ozoneManager.getScmBlockSize(), ozoneManager.getPreallocateBlocksMax(), ozoneManager.isGrpcBlockTokenEnabled(), ozoneManager.getOMNodeId());
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now());
        OzoneManagerProtocolProtos.AllocateBlockRequest.Builder newAllocatedBlockRequest = OzoneManagerProtocolProtos.AllocateBlockRequest.newBuilder().setClientID(allocateBlockRequest.getClientID()).setKeyArgs(newKeyArgs);
        if (allocateBlockRequest.hasExcludeList()) {
            newAllocatedBlockRequest.setExcludeList(allocateBlockRequest.getExcludeList());
        }
        newAllocatedBlockRequest.setKeyLocation(omKeyLocationInfoList.get(0).getProtobuf());
        return this.getOmRequest().toBuilder().setUserInfo(this.getUserInfo()).setAllocateBlockRequest(newAllocatedBlockRequest).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OzoneManagerProtocolProtos.AllocateBlockRequest allocateBlockRequest = this.getOmRequest().getAllocateBlockRequest();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = allocateBlockRequest.getKeyArgs();
        OzoneManagerProtocolProtos.KeyLocation blockLocation = allocateBlockRequest.getKeyLocation();
        Preconditions.checkNotNull((Object)blockLocation);
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        String keyName = keyArgs.getKeyName();
        long clientID = allocateBlockRequest.getClientID();
        OMMetrics omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumBlockAllocateCalls();
        AuditLogger auditLogger = ozoneManager.getAuditLogger();
        Map<String, String> auditMap = this.buildKeyArgsAuditMap(keyArgs);
        auditMap.put("clientID", String.valueOf(clientID));
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.AllocateBlock).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        try {
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volumeName, bucketName, keyName);
            }
        }
        catch (IOException ex) {
            LOG.error("AllocateBlock failed for Key: {} in volume/bucket:{}/{}", new Object[]{keyName, bucketName, volumeName, ex});
            omMetrics.incNumBlockAllocateCallFails();
            this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.ALLOCATE_BLOCK, auditMap, ex, this.getOmRequest().getUserInfo()));
            return new OMAllocateBlockResponse(null, -1L, this.createErrorOMResponse(omResponse, ex));
        }
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        try {
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
        }
        catch (IOException ex) {
            LOG.error("AllocateBlock failed for Key: {} in volume/bucket:{}/{}", new Object[]{keyName, bucketName, volumeName, ex});
            omMetrics.incNumBlockAllocateCallFails();
            this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.ALLOCATE_BLOCK, auditMap, ex, this.getOmRequest().getUserInfo()));
            return new OMAllocateBlockResponse(null, -1L, this.createErrorOMResponse(omResponse, ex));
        }
        String openKey = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
        IOException exception = null;
        OmKeyInfo omKeyInfo = null;
        try {
            omKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable().get((Object)openKey);
            if (omKeyInfo == null) {
                throw new OMException("Open Key not found " + openKey, OMException.ResultCodes.KEY_NOT_FOUND);
            }
            omKeyInfo.appendNewBlocks(Collections.singletonList(OmKeyLocationInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyLocation)blockLocation)), false);
            omKeyInfo.setModificationTime(keyArgs.getModificationTime());
            omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)openKey), new CacheValue(Optional.of((Object)omKeyInfo), transactionLogIndex));
        }
        catch (IOException ex) {
            exception = ex;
        }
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.ALLOCATE_BLOCK, auditMap, exception, this.getOmRequest().getUserInfo()));
        if (exception == null) {
            omResponse.setAllocateBlockResponse(OzoneManagerProtocolProtos.AllocateBlockResponse.newBuilder().setKeyLocation(blockLocation).build());
            return new OMAllocateBlockResponse(omKeyInfo, clientID, omResponse.build());
        }
        omMetrics.incNumBlockAllocateCallFails();
        return new OMAllocateBlockResponse(null, -1L, this.createErrorOMResponse(omResponse, exception));
    }
}

