/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.UniqueId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyCreateRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyCreateRequest.class);

    public OMKeyCreateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.CreateKeyRequest createKeyRequest = this.getOmRequest().getCreateKeyRequest();
        Preconditions.checkNotNull((Object)createKeyRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = createKeyRequest.getKeyArgs();
        OzoneManagerProtocolProtos.CreateKeyRequest.Builder newCreateKeyRequest = null;
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = null;
        if (!keyArgs.getIsMultipartKey()) {
            HddsProtos.ReplicationType type;
            long scmBlockSize = ozoneManager.getScmBlockSize();
            long requestedSize = keyArgs.getDataSize() > 0L ? keyArgs.getDataSize() : scmBlockSize;
            boolean useRatis = ozoneManager.shouldUseRatis();
            HddsProtos.ReplicationFactor factor = keyArgs.getFactor();
            if (factor == null) {
                HddsProtos.ReplicationFactor replicationFactor = factor = useRatis ? HddsProtos.ReplicationFactor.THREE : HddsProtos.ReplicationFactor.ONE;
            }
            if ((type = keyArgs.getType()) == null) {
                type = useRatis ? HddsProtos.ReplicationType.RATIS : HddsProtos.ReplicationType.STAND_ALONE;
            }
            List<OmKeyLocationInfo> omKeyLocationInfoList = this.allocateBlock(ozoneManager.getScmClient(), ozoneManager.getBlockTokenSecretManager(), type, factor, new ExcludeList(), requestedSize, scmBlockSize, ozoneManager.getPreallocateBlocksMax(), ozoneManager.isGrpcBlockTokenEnabled(), ozoneManager.getOMNodeId());
            newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setType(type).setFactor(factor).setDataSize(requestedSize);
            newKeyArgs.addAllKeyLocations((Iterable)omKeyLocationInfoList.stream().map(OmKeyLocationInfo::getProtobuf).collect(Collectors.toList()));
        } else {
            newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now());
        }
        newCreateKeyRequest = createKeyRequest.toBuilder().setKeyArgs(newKeyArgs).setClientID(UniqueId.next());
        return this.getOmRequest().toBuilder().setCreateKeyRequest(newCreateKeyRequest).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OzoneManagerProtocolProtos.CreateKeyRequest createKeyRequest = this.getOmRequest().getCreateKeyRequest();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = createKeyRequest.getKeyArgs();
        String volumeName = keyArgs.getVolumeName();
        String bucketName = keyArgs.getBucketName();
        String keyName = keyArgs.getKeyName();
        OMMetrics omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumKeyAllocates();
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        OmKeyInfo omKeyInfo = null;
        ArrayList<OmKeyLocationInfo> locations = new ArrayList<OmKeyLocationInfo>();
        Optional<FileEncryptionInfo> encryptionInfo = Optional.absent();
        IOException exception = null;
        boolean acquireLock = false;
        try {
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.WRITE, volumeName, bucketName, keyName);
            }
            acquireLock = omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
            OmBucketInfo bucketInfo = (OmBucketInfo)omMetadataManager.getBucketTable().get((Object)omMetadataManager.getBucketKey(volumeName, bucketName));
            encryptionInfo = this.getFileEncryptionInfo(ozoneManager, bucketInfo);
            omKeyInfo = this.prepareKeyInfo(omMetadataManager, keyArgs, omMetadataManager.getOzoneKey(volumeName, bucketName, keyName), keyArgs.getDataSize(), locations, (FileEncryptionInfo)encryptionInfo.orNull());
            if (!acquireLock) return this.prepareCreateKeyResponse(keyArgs, omKeyInfo, locations, (FileEncryptionInfo)encryptionInfo.orNull(), exception, createKeyRequest.getClientID(), transactionLogIndex, volumeName, bucketName, keyName, ozoneManager, OMAction.ALLOCATE_KEY);
        }
        catch (IOException ex) {
            try {
                LOG.error("Key open failed for volume:{} bucket:{} key:{}", new Object[]{volumeName, bucketName, keyName, ex});
                exception = ex;
                if (!acquireLock) return this.prepareCreateKeyResponse(keyArgs, omKeyInfo, locations, (FileEncryptionInfo)encryptionInfo.orNull(), exception, createKeyRequest.getClientID(), transactionLogIndex, volumeName, bucketName, keyName, ozoneManager, OMAction.ALLOCATE_KEY);
            }
            catch (Throwable throwable) {
                if (!acquireLock) throw throwable;
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
            return this.prepareCreateKeyResponse(keyArgs, omKeyInfo, locations, (FileEncryptionInfo)encryptionInfo.orNull(), exception, createKeyRequest.getClientID(), transactionLogIndex, volumeName, bucketName, keyName, ozoneManager, OMAction.ALLOCATE_KEY);
        }
        omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        return this.prepareCreateKeyResponse(keyArgs, omKeyInfo, locations, (FileEncryptionInfo)encryptionInfo.orNull(), exception, createKeyRequest.getClientID(), transactionLogIndex, volumeName, bucketName, keyName, ozoneManager, OMAction.ALLOCATE_KEY);
    }
}

