/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyCreateResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyDeleteRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyDeleteRequest.class);

    public OMKeyDeleteRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManagerProtocolProtos.DeleteKeyRequest deleteKeyRequest = this.getOmRequest().getDeleteKeyRequest();
        Preconditions.checkNotNull((Object)deleteKeyRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = deleteKeyRequest.getKeyArgs();
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now());
        return this.getOmRequest().toBuilder().setDeleteKeyRequest(deleteKeyRequest.toBuilder().setKeyArgs(newKeyArgs)).setUserInfo(this.getUserInfo()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OzoneManagerProtocolProtos.DeleteKeyRequest deleteKeyRequest = this.getOmRequest().getDeleteKeyRequest();
        OzoneManagerProtocolProtos.KeyArgs deleteKeyArgs = deleteKeyRequest.getKeyArgs();
        String volumeName = deleteKeyArgs.getVolumeName();
        String bucketName = deleteKeyArgs.getBucketName();
        String keyName = deleteKeyArgs.getKeyName();
        OMMetrics omMetrics = ozoneManager.getMetrics();
        omMetrics.incNumKeyDeletes();
        AuditLogger auditLogger = ozoneManager.getAuditLogger();
        OzoneManagerProtocolProtos.UserInfo userInfo = this.getOmRequest().getUserInfo();
        Map<String, String> auditMap = this.buildKeyArgsAuditMap(deleteKeyArgs);
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.DeleteKey).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true);
        try {
            if (ozoneManager.getAclsEnabled()) {
                this.checkAcls(ozoneManager, OzoneObj.ResourceType.KEY, OzoneObj.StoreType.OZONE, IAccessAuthorizer.ACLType.DELETE, volumeName, bucketName, keyName);
            }
        }
        catch (IOException ex) {
            LOG.error("Delete failed for Key: {} in volume/bucket:{}/{}", new Object[]{keyName, bucketName, volumeName, ex});
            omMetrics.incNumKeyDeleteFails();
            this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.DELETE_KEY, auditMap, ex, userInfo));
            return new OMKeyCreateResponse(null, -1L, this.createErrorOMResponse(omResponse, ex));
        }
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        String objectKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
        omMetadataManager.getLock().acquireLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        IOException exception = null;
        OmKeyInfo omKeyInfo = null;
        try {
            omKeyInfo = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)objectKey);
            if (omKeyInfo == null) {
                throw new OMException("Key not found", OMException.ResultCodes.KEY_NOT_FOUND);
            }
            omMetadataManager.getKeyTable().addCacheEntry(new CacheKey((Object)omMetadataManager.getOzoneKey(volumeName, bucketName, keyName)), new CacheValue(Optional.absent(), transactionLogIndex));
        }
        catch (IOException ex) {
            try {
                exception = ex;
            }
            catch (Throwable throwable) {
                omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                throw throwable;
            }
            omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        }
        omMetadataManager.getLock().releaseLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
        this.auditLog(auditLogger, this.buildAuditMessage((AuditAction)OMAction.DELETE_KEY, auditMap, exception, userInfo));
        if (exception == null) {
            omMetrics.decNumKeys();
            return new OMKeyDeleteResponse(omKeyInfo, deleteKeyArgs.getModificationTime(), omResponse.setDeleteKeyResponse(OzoneManagerProtocolProtos.DeleteKeyResponse.newBuilder()).build());
        }
        omMetrics.incNumKeyDeleteFails();
        return new OMKeyDeleteResponse(null, 0L, this.createErrorOMResponse(omResponse, exception));
    }
}

