/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import java.util.List;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyPurgeResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMKeyPurgeRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyPurgeRequest.class);

    public OMKeyPurgeRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, long transactionLogIndex) {
        OzoneManagerProtocolProtos.PurgeKeysRequest purgeKeysRequest = this.getOmRequest().getPurgeKeysRequest();
        List purgeKeysList = purgeKeysRequest.getKeysList();
        LOG.debug("Processing Purge Keys for {} number of keys.", (Object)purgeKeysList.size());
        OzoneManagerProtocolProtos.OMResponse omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.PurgeKeys).setPurgeKeysResponse(OzoneManagerProtocolProtos.PurgeKeysResponse.newBuilder().build()).setStatus(OzoneManagerProtocolProtos.Status.OK).setSuccess(true).build();
        return new OMKeyPurgeResponse(purgeKeysList, omResponse);
    }
}

