/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import org.apache.hadoop.fs.FileEncryptionInfo;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.AllocatedBlock;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.exceptions.SCMException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ozone.audit.AuditAction;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.ScmClient;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketEncryptionKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OzoneAclUtil;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.file.OMFileCreateResponse;
import org.apache.hadoop.ozone.om.response.key.OMKeyCreateResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.OzoneBlockTokenSecretManager;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.utils.db.cache.CacheKey;
import org.apache.hadoop.utils.db.cache.CacheValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OMKeyRequest
extends OMClientRequest {
    private static final Logger LOG = LoggerFactory.getLogger(OMKeyRequest.class);

    public OMKeyRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    protected List<OmKeyLocationInfo> allocateBlock(ScmClient scmClient, OzoneBlockTokenSecretManager secretManager, HddsProtos.ReplicationType replicationType, HddsProtos.ReplicationFactor replicationFactor, ExcludeList excludeList, long requestedSize, long scmBlockSize, int preallocateBlocksMax, boolean grpcBlockTokenEnabled, String omID) throws IOException {
        List allocatedBlocks;
        int numBlocks = Math.min((int)((requestedSize - 1L) / scmBlockSize + 1L), preallocateBlocksMax);
        ArrayList<OmKeyLocationInfo> locationInfos = new ArrayList<OmKeyLocationInfo>(numBlocks);
        String remoteUser = this.getRemoteUser().getShortUserName();
        try {
            allocatedBlocks = scmClient.getBlockClient().allocateBlock(scmBlockSize, numBlocks, replicationType, replicationFactor, omID, excludeList);
        }
        catch (SCMException ex) {
            if (ex.getResult().equals((Object)SCMException.ResultCodes.SAFE_MODE_EXCEPTION)) {
                throw new OMException(ex.getMessage(), OMException.ResultCodes.SCM_IN_SAFE_MODE);
            }
            throw ex;
        }
        for (AllocatedBlock allocatedBlock : allocatedBlocks) {
            OmKeyLocationInfo.Builder builder = new OmKeyLocationInfo.Builder().setBlockID(new BlockID(allocatedBlock.getBlockID())).setLength(scmBlockSize).setOffset(0L).setPipeline(allocatedBlock.getPipeline());
            if (grpcBlockTokenEnabled) {
                builder.setToken(secretManager.generateToken(remoteUser, allocatedBlock.getBlockID().toString(), this.getAclForUser(remoteUser), scmBlockSize));
            }
            locationInfos.add(builder.build());
        }
        return locationInfos;
    }

    private UserGroupInformation getRemoteUser() throws IOException {
        UserGroupInformation ugi = Server.getRemoteUser();
        return ugi != null ? ugi : UserGroupInformation.getCurrentUser();
    }

    private EnumSet<HddsProtos.BlockTokenSecretProto.AccessModeProto> getAclForUser(String user) {
        return EnumSet.allOf(HddsProtos.BlockTokenSecretProto.AccessModeProto.class);
    }

    public void validateBucketAndVolume(OMMetadataManager omMetadataManager, String volumeName, String bucketName) throws IOException {
        String bucketKey = omMetadataManager.getBucketKey(volumeName, bucketName);
        if (!omMetadataManager.getBucketTable().isExist((Object)bucketKey)) {
            String volumeKey = omMetadataManager.getVolumeKey(volumeName);
            if (!omMetadataManager.getVolumeTable().isExist((Object)volumeKey)) {
                throw new OMException("Volume not found " + volumeName, OMException.ResultCodes.VOLUME_NOT_FOUND);
            }
            throw new OMException("Bucket not found " + bucketName, OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
    }

    protected Optional<FileEncryptionInfo> getFileEncryptionInfo(OzoneManager ozoneManager, OmBucketInfo bucketInfo) throws IOException {
        Optional encInfo = Optional.absent();
        BucketEncryptionKeyInfo ezInfo = bucketInfo.getEncryptionKeyInfo();
        if (ezInfo != null) {
            if (ozoneManager.getKmsProvider() == null) {
                throw new OMException("Invalid KMS provider, check configuration hadoop.security.key.provider.path", OMException.ResultCodes.INVALID_KMS_PROVIDER);
            }
            String ezKeyName = ezInfo.getKeyName();
            KeyProviderCryptoExtension.EncryptedKeyVersion edek = this.generateEDEK(ozoneManager, ezKeyName);
            encInfo = Optional.of((Object)new FileEncryptionInfo(ezInfo.getSuite(), ezInfo.getVersion(), edek.getEncryptedKeyVersion().getMaterial(), edek.getEncryptedKeyIv(), ezKeyName, edek.getEncryptionKeyVersionName()));
        }
        return encInfo;
    }

    private KeyProviderCryptoExtension.EncryptedKeyVersion generateEDEK(final OzoneManager ozoneManager, final String ezKeyName) throws IOException {
        if (ezKeyName == null) {
            return null;
        }
        long generateEDEKStartTime = Time.monotonicNow();
        KeyProviderCryptoExtension.EncryptedKeyVersion edek = (KeyProviderCryptoExtension.EncryptedKeyVersion)SecurityUtil.doAsLoginUser((PrivilegedExceptionAction)new PrivilegedExceptionAction<KeyProviderCryptoExtension.EncryptedKeyVersion>(){

            @Override
            public KeyProviderCryptoExtension.EncryptedKeyVersion run() throws IOException {
                try {
                    return ozoneManager.getKmsProvider().generateEncryptedKey(ezKeyName);
                }
                catch (GeneralSecurityException e) {
                    throw new IOException(e);
                }
            }
        });
        long generateEDEKTime = Time.monotonicNow() - generateEDEKStartTime;
        LOG.debug("generateEDEK takes {} ms", (Object)generateEDEKTime);
        Preconditions.checkNotNull((Object)edek);
        return edek;
    }

    protected OMClientResponse prepareCreateKeyResponse(@Nonnull OzoneManagerProtocolProtos.KeyArgs keyArgs, OmKeyInfo omKeyInfo, @Nonnull List<OmKeyLocationInfo> locations, FileEncryptionInfo encryptionInfo, @Nullable IOException exception, long clientID, long transactionLogIndex, @Nonnull String volumeName, @Nonnull String bucketName, @Nonnull String keyName, @Nonnull OzoneManager ozoneManager, @Nonnull OMAction omAction) {
        OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OzoneManagerProtocolProtos.OMResponse.newBuilder().setStatus(OzoneManagerProtocolProtos.Status.OK);
        OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
        Map<String, String> auditMap = this.buildKeyArgsAuditMap(keyArgs);
        OMClientResponse omClientResponse = null;
        if (exception == null) {
            if (omKeyInfo == null) {
                omKeyInfo = this.createKeyInfo(keyArgs, locations, keyArgs.getFactor(), keyArgs.getType(), keyArgs.getDataSize(), encryptionInfo);
            }
            long openVersion = omKeyInfo.getLatestVersionLocations().getVersion();
            try {
                omKeyInfo.appendNewBlocks(keyArgs.getKeyLocationsList().stream().map(OmKeyLocationInfo::getFromProtobuf).collect(Collectors.toList()), false);
            }
            catch (IOException ex) {
                exception = ex;
            }
            if (exception != null) {
                LOG.error("{} failed for Key: {} in volume/bucket:{}/{}", new Object[]{omAction.getAction(), keyName, bucketName, volumeName, exception});
                omClientResponse = this.createKeyErrorResponse(ozoneManager.getMetrics(), omAction, exception, omResponse);
            } else {
                String dbOpenKeyName = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
                omMetadataManager.getOpenKeyTable().addCacheEntry(new CacheKey((Object)dbOpenKeyName), new CacheValue(Optional.of((Object)omKeyInfo), transactionLogIndex));
                LOG.debug("{} for Key: {} in volume/bucket: {}/{}", new Object[]{omAction.getAction(), keyName, volumeName, bucketName});
                if (omAction == OMAction.CREATE_FILE) {
                    ozoneManager.getMetrics().incNumCreateFile();
                    omResponse.setCreateFileResponse(OzoneManagerProtocolProtos.CreateFileResponse.newBuilder().setKeyInfo(omKeyInfo.getProtobuf()).setID(clientID).setOpenVersion(openVersion).build());
                    omResponse.setCmdType(OzoneManagerProtocolProtos.Type.CreateFile);
                    omClientResponse = new OMFileCreateResponse(omKeyInfo, clientID, omResponse.build());
                } else {
                    ozoneManager.getMetrics().incNumKeyAllocates();
                    omResponse.setCreateKeyResponse(OzoneManagerProtocolProtos.CreateKeyResponse.newBuilder().setKeyInfo(omKeyInfo.getProtobuf()).setID(clientID).setOpenVersion(openVersion).build());
                    omResponse.setCmdType(OzoneManagerProtocolProtos.Type.CreateKey);
                    omClientResponse = new OMKeyCreateResponse(omKeyInfo, clientID, omResponse.build());
                }
            }
        } else {
            LOG.error("{} failed for Key: {} in volume/bucket:{}/{}", new Object[]{omAction.getAction(), keyName, volumeName, bucketName, exception});
            omClientResponse = this.createKeyErrorResponse(ozoneManager.getMetrics(), omAction, exception, omResponse);
        }
        this.auditLog(ozoneManager.getAuditLogger(), this.buildAuditMessage((AuditAction)omAction, auditMap, exception, this.getOmRequest().getUserInfo()));
        return omClientResponse;
    }

    protected OmKeyInfo createKeyInfo(@Nonnull OzoneManagerProtocolProtos.KeyArgs keyArgs, @Nonnull List<OmKeyLocationInfo> locations, @Nonnull HddsProtos.ReplicationFactor factor, @Nonnull HddsProtos.ReplicationType type, long size, @Nullable FileEncryptionInfo encInfo) {
        OmKeyInfo.Builder builder = new OmKeyInfo.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setOmKeyLocationInfos(Collections.singletonList(new OmKeyLocationInfoGroup(0L, locations))).setCreationTime(keyArgs.getModificationTime()).setModificationTime(keyArgs.getModificationTime()).setDataSize(size).setReplicationType(type).setReplicationFactor(factor).setFileEncryptionInfo(encInfo);
        if (keyArgs.getAclsList() != null) {
            builder.setAcls(OzoneAclUtil.fromProtobuf((List)keyArgs.getAclsList()));
        }
        return builder.build();
    }

    protected OmKeyInfo prepareKeyInfo(@Nonnull OMMetadataManager omMetadataManager, @Nonnull OzoneManagerProtocolProtos.KeyArgs keyArgs, @Nonnull String dbKeyName, long size, @Nonnull List<OmKeyLocationInfo> locations, @Nullable FileEncryptionInfo encInfo) throws IOException {
        OmKeyInfo keyInfo = null;
        if (keyArgs.getIsMultipartKey()) {
            keyInfo = this.prepareMultipartKeyInfo(omMetadataManager, keyArgs, size, locations, encInfo);
        } else if (omMetadataManager.getKeyTable().isExist((Object)dbKeyName)) {
            keyInfo = (OmKeyInfo)omMetadataManager.getKeyTable().get((Object)dbKeyName);
            keyInfo.addNewVersion(locations, false);
            keyInfo.setDataSize(size + keyInfo.getDataSize());
            keyInfo.setModificationTime(keyArgs.getModificationTime());
        }
        return keyInfo;
    }

    private OmKeyInfo prepareMultipartKeyInfo(@Nonnull OMMetadataManager omMetadataManager, @Nonnull OzoneManagerProtocolProtos.KeyArgs args, long size, @Nonnull List<OmKeyLocationInfo> locations, FileEncryptionInfo encInfo) throws IOException {
        Preconditions.checkArgument((args.getMultipartNumber() > 0 ? 1 : 0) != 0, (Object)"PartNumber Should be greater than zero");
        String uploadID = args.getMultipartUploadID();
        Preconditions.checkNotNull((Object)uploadID);
        String multipartKey = omMetadataManager.getMultipartKey(args.getVolumeName(), args.getBucketName(), args.getKeyName(), uploadID);
        OmKeyInfo partKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable().get((Object)multipartKey);
        if (partKeyInfo == null) {
            throw new OMException("No such Multipart upload is with specified uploadId " + uploadID, OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
        }
        HddsProtos.ReplicationFactor factor = partKeyInfo.getFactor();
        HddsProtos.ReplicationType type = partKeyInfo.getType();
        return this.createKeyInfo(args, locations, factor, type, size, encInfo);
    }

    private OMClientResponse createKeyErrorResponse(@Nonnull OMMetrics omMetrics, @Nonnull OMAction omAction, @Nonnull IOException exception, @Nonnull OzoneManagerProtocolProtos.OMResponse.Builder omResponse) {
        if (omAction == OMAction.CREATE_FILE) {
            omMetrics.incNumCreateFileFails();
            omResponse.setCmdType(OzoneManagerProtocolProtos.Type.CreateFile);
            return new OMFileCreateResponse(null, -1L, this.createErrorOMResponse(omResponse, exception));
        }
        omMetrics.incNumKeyAllocateFails();
        omResponse.setCmdType(OzoneManagerProtocolProtos.Type.CreateKey);
        return new OMKeyCreateResponse(null, -1L, this.createErrorOMResponse(omResponse, exception));
    }
}

